/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.machine;

import edu.mayo.bmi.fsm.condition.DecimalCondition;
import edu.mayo.bmi.fsm.condition.IntegerCondition;
import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.output.FractionToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class FractionFSM {
    Set<String> iv_textNumeratorSet = new HashSet<String>();
    Set<String> iv_textDenominatorSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public FractionFSM() {
        this.iv_textNumeratorSet.add("one");
        this.iv_textNumeratorSet.add("two");
        this.iv_textNumeratorSet.add("three");
        this.iv_textNumeratorSet.add("four");
        this.iv_textNumeratorSet.add("five");
        this.iv_textNumeratorSet.add("six");
        this.iv_textNumeratorSet.add("seven");
        this.iv_textNumeratorSet.add("eight");
        this.iv_textNumeratorSet.add("nine");
        this.iv_textNumeratorSet.add("ten");
        this.iv_textDenominatorSet.add("half");
        this.iv_textDenominatorSet.add("halfs");
        this.iv_textDenominatorSet.add("third");
        this.iv_textDenominatorSet.add("thirds");
        this.iv_textDenominatorSet.add("fourth");
        this.iv_textDenominatorSet.add("fourths");
        this.iv_textDenominatorSet.add("fifth");
        this.iv_textDenominatorSet.add("fifths");
        this.iv_textDenominatorSet.add("sixth");
        this.iv_textDenominatorSet.add("sixths");
        this.iv_textDenominatorSet.add("seventh");
        this.iv_textDenominatorSet.add("sevenths");
        this.iv_textDenominatorSet.add("eighth");
        this.iv_textDenominatorSet.add("eighths");
        this.iv_textDenominatorSet.add("nineths");
        this.iv_textDenominatorSet.add("nineth");
        this.iv_textDenominatorSet.add("tenth");
        this.iv_textDenominatorSet.add("tenths");
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState numeratorNumState = new NamedState("NUMERATOR_NUM");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        NamedState numeratorTextState = new NamedState("NUMERATOR_TEXT");
        IntegerCondition intNumeratorCondition = new IntegerCondition();
        PunctuationValueCondition fslashCondition = new PunctuationValueCondition('/');
        IntegerCondition intDenominatorCondition = new IntegerCondition();
        DecimalCondition decimalCondition = new DecimalCondition();
        WordSetCondition textNumeratorCondition = new WordSetCondition(this.iv_textNumeratorSet, false);
        WordSetCondition textDenominatorCondition = new WordSetCondition(this.iv_textDenominatorSet, false);
        startState.addTransition(intNumeratorCondition, numeratorNumState);
        startState.addTransition(decimalCondition, endState);
        startState.addTransition(textNumeratorCondition, numeratorTextState);
        startState.addTransition(textDenominatorCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        numeratorNumState.addTransition(fslashCondition, fslashState);
        numeratorNumState.addTransition(textDenominatorCondition, endState);
        numeratorNumState.addTransition(new AnyCondition(), startState);
        fslashState.addTransition(intDenominatorCondition, endState);
        fslashState.addTransition(new AnyCondition(), startState);
        numeratorTextState.addTransition(textDenominatorCondition, endState);
        numeratorTextState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set<FractionToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<FractionToken> fractionSet = new HashSet<FractionToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                FractionToken fractionToken = new FractionToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

