/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.pad.machine;

import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.TextSetCondition;
import edu.mayo.bmi.fsm.pad.output.IllnessDxIndicator;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.state.NonTerminalEndState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class DxIndicatorFSM {
    private Set<String> iv_breastDxSet = new HashSet<String>();
    private Set<String> iv_brainDxSet = new HashSet<String>();
    private Set<String> iv_colonDxSet = new HashSet<String>();
    private Set<String> iv_padDxSet = new HashSet<String>();
    private Set<String> iv_padDxHyphenBeginSet = new HashSet<String>();
    private Set<String> iv_padDxHyphenEndSet = new HashSet<String>();
    private Set<String> iv_padOneOfTwoDxSet = new HashSet<String>();
    private Set<String> iv_padTwoOfTwoDxSet = new HashSet<String>();
    private Set<String> iv_padOneOfThreeDxSet = new HashSet<String>();
    private Set<String> iv_padTwoOfThreeDxSet = new HashSet<String>();
    private Set<String> iv_padThreeOfThreeDxSet = new HashSet<String>();
    private Set<String> iv_padOneOfTwoNegConfirmDxSet = new HashSet<String>();
    private Set<String> iv_padTwoOfTwoNegConfirmDxSet = new HashSet<String>();
    private Machine iv_breastDxMachine;
    private Machine iv_brainDxMachine;
    private Machine iv_colonDxMachine;
    private Machine iv_padDxMachine;
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public DxIndicatorFSM() {
        this.iv_breastDxSet.add("breast");
        this.iv_breastDxSet.add("left-breast");
        this.iv_breastDxSet.add("right-breast");
        this.iv_brainDxSet.add("brain");
        this.iv_colonDxSet.add("colon");
        this.iv_padDxSet.add("stent");
        this.iv_padDxSet.add("stents");
        this.iv_padDxSet.add("stented");
        this.iv_padDxSet.add("stenting");
        this.iv_padDxSet.add("aortobifemoral");
        this.iv_padDxSet.add("angioplasty");
        this.iv_padDxSet.add("femoropopliteal");
        this.iv_padDxSet.add("anastomotic");
        this.iv_padDxSet.add("ileofemoral");
        this.iv_padDxSet.add("axillobifemoral");
        this.iv_padDxSet.add("aortobiiliac");
        this.iv_padDxSet.add("reconstitution");
        this.iv_padDxSet.add("reconstitute");
        this.iv_padDxSet.add("reconstitutes");
        this.iv_padDxSet.add("graft");
        this.iv_padDxSet.add("occluded");
        this.iv_padDxSet.add("occlude");
        this.iv_padDxSet.add("occludes");
        this.iv_padDxSet.add("occluding");
        this.iv_padDxSet.add("atherosclerosis");
        this.iv_padDxSet.add("collateral");
        this.iv_padDxSet.add("collaterals");
        this.iv_padDxSet.add("diffuse");
        this.iv_padDxSet.add("extensive");
        this.iv_padDxSet.add("plaque");
        this.iv_padDxSet.add("plaques");
        this.iv_padDxHyphenBeginSet.add("aortobi");
        this.iv_padDxHyphenEndSet.add("femoral");
        this.iv_padDxHyphenEndSet.add("iliac");
        this.iv_padOneOfTwoNegConfirmDxSet.add("not");
        this.iv_padTwoOfTwoNegConfirmDxSet.add("visualized");
        this.iv_padOneOfTwoDxSet.add("artery");
        this.iv_padOneOfTwoDxSet.add("bypass");
        this.iv_padOneOfTwoDxSet.add("outflow");
        this.iv_padOneOfTwoDxSet.add("critical");
        this.iv_padOneOfTwoDxSet.add("balloon");
        this.iv_padOneOfTwoDxSet.add("moderate");
        this.iv_padOneOfTwoDxSet.add("aortobifemoral");
        this.iv_padOneOfTwoDxSet.add("multi-focal");
        this.iv_padOneOfTwoDxSet.add("focal");
        this.iv_padOneOfTwoDxSet.add("vascular");
        this.iv_padOneOfTwoDxSet.add("arterial");
        this.iv_padTwoOfTwoDxSet.add("calcification");
        this.iv_padTwoOfTwoDxSet.add("calcifications");
        this.iv_padTwoOfTwoDxSet.add("narrowing");
        this.iv_padTwoOfTwoDxSet.add("graft");
        this.iv_padTwoOfTwoDxSet.add("grafts");
        this.iv_padTwoOfTwoDxSet.add("grafting");
        this.iv_padTwoOfTwoDxSet.add("artery");
        this.iv_padTwoOfTwoDxSet.add("bypass");
        this.iv_padTwoOfTwoDxSet.add("obstruction");
        this.iv_padTwoOfTwoDxSet.add("lesions");
        this.iv_padTwoOfTwoDxSet.add("angioplastied");
        this.iv_padTwoOfTwoDxSet.add("atherosclerotic");
        this.iv_padTwoOfTwoDxSet.add("stenoses");
        this.iv_padTwoOfTwoDxSet.add("plaque");
        this.iv_padTwoOfTwoDxSet.add("plaques");
        this.iv_padTwoOfTwoDxSet.add("stenosis");
        this.iv_padOneOfThreeDxSet.add("femoral");
        this.iv_padOneOfThreeDxSet.add("artery");
        this.iv_padOneOfThreeDxSet.add("aorto");
        this.iv_padOneOfThreeDxSet.add("possible");
        this.iv_padOneOfThreeDxSet.add("mild");
        this.iv_padOneOfThreeDxSet.add("lower");
        this.iv_padOneOfThreeDxSet.add("iliac");
        this.iv_padOneOfThreeDxSet.add("moderate");
        this.iv_padTwoOfThreeDxSet.add("bypass");
        this.iv_padTwoOfThreeDxSet.add("bifemoral");
        this.iv_padTwoOfThreeDxSet.add("bi-iliac");
        this.iv_padTwoOfThreeDxSet.add("stents");
        this.iv_padTwoOfThreeDxSet.add("outflow");
        this.iv_padTwoOfThreeDxSet.add("focal");
        this.iv_padTwoOfThreeDxSet.add("to");
        this.iv_padTwoOfThreeDxSet.add("artery");
        this.iv_padTwoOfThreeDxSet.add("aorta");
        this.iv_padTwoOfThreeDxSet.add("atheromatous");
        this.iv_padThreeOfThreeDxSet.add("graft");
        this.iv_padThreeOfThreeDxSet.add("grafts");
        this.iv_padThreeOfThreeDxSet.add("stents");
        this.iv_padThreeOfThreeDxSet.add("obstruction");
        this.iv_padThreeOfThreeDxSet.add("narrowing");
        this.iv_padThreeOfThreeDxSet.add("plaque");
        this.iv_padThreeOfThreeDxSet.add("moderate");
        this.iv_brainDxMachine = this.getBrainDxMachine();
        this.iv_breastDxMachine = this.getBreastDxMachine();
        this.iv_colonDxMachine = this.getColonDxMachine();
        this.iv_padDxMachine = this.getPADDxMachine();
        this.iv_machineSet.add(this.iv_brainDxMachine);
        this.iv_machineSet.add(this.iv_breastDxMachine);
        this.iv_machineSet.add(this.iv_colonDxMachine);
        this.iv_machineSet.add(this.iv_padDxMachine);
    }

    private Machine getBreastDxMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition breastDxC = new TextSetCondition(this.iv_breastDxSet, false);
        startState.addTransition(breastDxC, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getBrainDxMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition brainDxC = new TextSetCondition(this.iv_brainDxSet, false);
        startState.addTransition(brainDxC, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getColonDxMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition colonDxC = new TextSetCondition(this.iv_colonDxSet, false);
        startState.addTransition(colonDxC, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getPADDxMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState padHyphenBeginState = new NamedState("HYPHENB");
        NamedState padHyphenEndState = new NamedState("HYPHENE");
        NamedState pad2of2NegConfirmState = new NamedState("TWOOFTWONEG");
        NamedState pad2of2State = new NamedState("TWOOFTWO");
        NamedState pad2of3State = new NamedState("TWOOFTHREE");
        NamedState pad3of3State = new NamedState("THREEOFTHREE");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition padDxC = new TextSetCondition(this.iv_padDxSet, false);
        TextSetCondition padDxHyphenBeginC = new TextSetCondition(this.iv_padDxHyphenBeginSet, false);
        TextSetCondition padDxHyphenEndC = new TextSetCondition(this.iv_padDxHyphenEndSet, false);
        TextSetCondition pad1of2DxC = new TextSetCondition(this.iv_padOneOfTwoDxSet, false);
        TextSetCondition pad2of2DxC = new TextSetCondition(this.iv_padTwoOfTwoDxSet, false);
        TextSetCondition pad1of3DxC = new TextSetCondition(this.iv_padOneOfThreeDxSet, false);
        TextSetCondition pad2of3DxC = new TextSetCondition(this.iv_padTwoOfThreeDxSet, false);
        TextSetCondition pad3of3DxC = new TextSetCondition(this.iv_padThreeOfThreeDxSet, false);
        TextSetCondition padNegConfirm1Of2DxC = new TextSetCondition(this.iv_padOneOfTwoNegConfirmDxSet, false);
        TextSetCondition padNegConfirm2Of2DxC = new TextSetCondition(this.iv_padTwoOfTwoNegConfirmDxSet, false);
        startState.addTransition(padDxC, endState);
        startState.addTransition(padNegConfirm1Of2DxC, pad2of2NegConfirmState);
        startState.addTransition(pad1of2DxC, pad2of2State);
        startState.addTransition(pad1of3DxC, pad2of3State);
        startState.addTransition(padDxHyphenBeginC, padHyphenBeginState);
        startState.addTransition(new AnyCondition(), startState);
        pad2of2NegConfirmState.addTransition(padNegConfirm2Of2DxC, endState);
        pad2of2NegConfirmState.addTransition(new AnyCondition(), startState);
        pad2of2State.addTransition(pad2of2DxC, endState);
        pad2of2State.addTransition(new AnyCondition(), startState);
        pad2of3State.addTransition(pad2of3DxC, pad3of3State);
        pad2of3State.addTransition(new AnyCondition(), startState);
        pad3of3State.addTransition(pad3of3DxC, endState);
        pad3of3State.addTransition(new AnyCondition(), startState);
        padHyphenBeginState.addTransition(new PunctuationValueCondition('-'), padHyphenEndState);
        padHyphenBeginState.addTransition(new AnyCondition(), startState);
        padHyphenEndState.addTransition(padDxHyphenEndC, endState);
        padHyphenEndState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set<IllnessDxIndicator> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<IllnessDxIndicator> outSet = new HashSet<IllnessDxIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = tokens.get(i);
            for (Machine m : this.iv_machineSet) {
                int tokenStartIndex;
                m.input(token);
                State currentState = m.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(m, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(m);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? tokens.get(i - 1) : token;
                BaseToken startToken = tokens.get(tokenStartIndex);
                IllnessDxIndicator si = null;
                if (m.equals(this.iv_brainDxMachine)) {
                    si = new IllnessDxIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 5);
                } else if (m.equals(this.iv_breastDxMachine)) {
                    si = new IllnessDxIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 4);
                } else if (m.equals(this.iv_colonDxMachine)) {
                    si = new IllnessDxIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 6);
                } else if (m.equals(this.iv_padDxMachine)) {
                    si = new IllnessDxIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 7);
                }
                outSet.add(si);
                m.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine m : this.iv_machineSet) {
            m.reset();
        }
        return outSet;
    }
}

