/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.token.adapter;

import edu.mayo.bmi.fsm.token.BaseToken;
import edu.mayo.bmi.fsm.token.adapter.DecimalTokenAdapter;
import edu.mayo.bmi.fsm.token.adapter.IntegerTokenAdapter;
import edu.mayo.bmi.fsm.token.adapter.PunctuationTokenAdapter;
import edu.mayo.bmi.fsm.token.adapter.WordTokenAdapter;
import edu.mayo.bmi.nlp.tokenizer.Token;
import java.util.ArrayList;
import java.util.List;

public class TokenConverter {
    public static List<BaseToken> convertTokens(List<Token> tokens) {
        ArrayList<BaseToken> baseTokens = new ArrayList<BaseToken>();
        int i = 0;
        while (i < tokens.size()) {
            Token t = tokens.get(i);
            switch (t.getType()) {
                case 1: {
                    WordTokenAdapter wt = new WordTokenAdapter(t);
                    baseTokens.add(wt);
                    break;
                }
                case 3: {
                    PunctuationTokenAdapter pt = new PunctuationTokenAdapter(t);
                    baseTokens.add(pt);
                    break;
                }
                case 2: {
                    if (t.isInteger()) {
                        IntegerTokenAdapter it = new IntegerTokenAdapter(t);
                        baseTokens.add(it);
                        break;
                    }
                    DecimalTokenAdapter dt = new DecimalTokenAdapter(t);
                    baseTokens.add(dt);
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++i;
        }
        return baseTokens;
    }
}

