/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.lookup.algorithms;

import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.lookup.algorithms.PermutationUtil;
import edu.mayo.bmi.lookup.phrasebuilder.PhraseBuilder;
import edu.mayo.bmi.lookup.vo.LookupAnnotation;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.lookup.vo.LookupToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FirstTokenPermutationImpl
implements LookupAlgorithm {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    public static final String CTX_KEY_WINDOW_ANNOTATIONS = "WINDOW_ANNOTATIONS";
    public static final String LT_KEY_USE_FOR_LOOKUP = "USE_FOR_LOOKUP";
    private DictionaryEngine iv_firstTokenDictEngine;
    private PhraseBuilder iv_phrBuilder;
    private int iv_maxPermutationLevel;
    private Map iv_permCacheMap = new HashMap();
    private String[] iv_textMetaFieldNames;

    public FirstTokenPermutationImpl(DictionaryEngine firstTokenDictEngine, PhraseBuilder phraseBuilder, String[] textMetaFieldNames, int maxPermutationLevel) {
        this.iv_firstTokenDictEngine = firstTokenDictEngine;
        this.iv_phrBuilder = phraseBuilder;
        this.iv_textMetaFieldNames = textMetaFieldNames;
        this.iv_maxPermutationLevel = maxPermutationLevel;
        int i = 0;
        while (i <= maxPermutationLevel) {
            Integer level = new Integer(i);
            List permList = PermutationUtil.getPermutationList(i);
            this.iv_permCacheMap.put(level, permList);
            ++i;
        }
    }

    @Override
    public Collection lookup(List ltList, Map ctxMap) throws Exception {
        boolean useWindowAnnots = false;
        List wAnnotList = this.getWindowAnnotations(ctxMap);
        if (wAnnotList.size() > 0) {
            useWindowAnnots = true;
        }
        Map wStartOffsetMap = this.getStartOffsetMap(wAnnotList, true);
        Map wEndOffsetMap = this.getEndOffsetMap(wAnnotList, true);
        Map ltListIndexMap = this.getListIndexMap(ltList);
        Map ltStartOffsetMap = this.getStartOffsetMap(ltList, true);
        Map ltEndOffsetMap = this.getEndOffsetMap(ltList, true);
        ArrayList lhList = new ArrayList();
        int ltIdx = 0;
        while (ltIdx < ltList.size()) {
            Collection mdhCol;
            LookupToken lt = (LookupToken)ltList.get(ltIdx);
            Boolean useForLookup = Boolean.valueOf(lt.getStringAttribute(LT_KEY_USE_FOR_LOOKUP));
            if ((useForLookup == null || useForLookup.booleanValue()) && (mdhCol = this.getFirstTokenHits(lt)) != null && mdhCol.size() > 0) {
                LookupAnnotation wAnnot;
                int wEndOffset = -1;
                if (useWindowAnnots && (wAnnot = this.getLargestWindowAnnotation(ltIdx, lt, ltStartOffsetMap, ltEndOffsetMap, ltListIndexMap, wStartOffsetMap, wEndOffsetMap)) != null) {
                    wEndOffset = wAnnot.getEndOffset();
                }
                if (wEndOffset == -1) {
                    this.iv_logger.debug("Window size set to max perm level.");
                    wEndOffset = this.getFixedWindowEndOffset(ltIdx, lt, ltList);
                }
                List endLookupTokenList = this.getLookupTokenList(wEndOffset, ltEndOffsetMap, false);
                LookupToken endLookupToken = (LookupToken)endLookupTokenList.get(endLookupTokenList.size() - 1);
                int startTokenIdx = ltIdx;
                int endTokenIdx = (Integer)ltListIndexMap.get(endLookupToken);
                List wLookupTokenList = ltList.subList(startTokenIdx, endTokenIdx + 1);
                Collection lhCol = this.getLookupHits(mdhCol, wLookupTokenList, new Integer(ltIdx - startTokenIdx));
                lhList.addAll(lhCol);
            }
            ++ltIdx;
        }
        return lhList;
    }

    private Collection getLookupHits(Collection mdhCol, List wLookupTokenList, Integer firstTokenIndex) throws Exception {
        if (wLookupTokenList.size() - 1 > this.iv_maxPermutationLevel) {
            this.iv_logger.debug("Beyond permutation cache size.");
            return new ArrayList();
        }
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        int i = 0;
        while (i < wLookupTokenList.size()) {
            if (i != firstTokenIndex) {
                idxList.add(new Integer(i));
            }
            ++i;
        }
        Collection permCol = (Collection)this.iv_permCacheMap.get(new Integer(idxList.size()));
        ArrayList<LookupHit> lhList = new ArrayList<LookupHit>();
        HashMap<String, HashSet<MetaDataHit>> mdhMap = new HashMap<String, HashSet<MetaDataHit>>();
        for (MetaDataHit mdh : mdhCol) {
            int i2 = 0;
            while (i2 < this.iv_textMetaFieldNames.length) {
                String text = mdh.getMetaFieldValue(this.iv_textMetaFieldNames[i2]);
                if (text != null) {
                    HashSet<MetaDataHit> mdhSet = (HashSet<MetaDataHit>)mdhMap.get(text = text.toLowerCase());
                    if (mdhSet == null) {
                        mdhSet = new HashSet<MetaDataHit>();
                    }
                    mdhSet.add(mdh);
                    mdhMap.put(text, mdhSet);
                } else if (this.iv_logger.isDebugEnabled()) {
                    this.iv_logger.debug("MetaField " + this.iv_textMetaFieldNames[i2] + " contains no data.");
                }
                ++i2;
            }
        }
        LookupToken firstWordLookupToken = (LookupToken)wLookupTokenList.get(firstTokenIndex);
        Iterator permItr = permCol.iterator();
        while (permItr.hasNext()) {
            ArrayList<LookupToken> tempList = new ArrayList<LookupToken>();
            List permutation = (List)permItr.next();
            Iterator idxItr = permutation.iterator();
            while (idxItr.hasNext()) {
                int idx = (Integer)idxItr.next();
                if (idx <= firstTokenIndex) {
                    --idx;
                }
                LookupToken lt = (LookupToken)wLookupTokenList.get(idx);
                tempList.add(lt);
            }
            ArrayList<LookupToken> singleTokenList = new ArrayList<LookupToken>();
            singleTokenList.add(firstWordLookupToken);
            String[] fwPerms = this.iv_phrBuilder.getPhrases(singleTokenList);
            String[] phrArr = this.iv_phrBuilder.getPhrases(tempList);
            int i3 = 0;
            while (i3 < phrArr.length) {
                int fwPermIdx = 0;
                while (fwPermIdx < fwPerms.length) {
                    StringBuffer phraseSB = new StringBuffer();
                    phraseSB.append(fwPerms[fwPermIdx]);
                    phraseSB.append(' ');
                    phraseSB.append(phrArr[i3]);
                    String phrase = phraseSB.toString().trim().toLowerCase();
                    Set mdhSet = (Set)mdhMap.get(phrase);
                    if (mdhSet != null) {
                        for (MetaDataHit mdh : mdhSet) {
                            int endOffset;
                            int startOffset;
                            Collections.sort(permutation);
                            if (permutation.size() > 0) {
                                LookupToken lt;
                                int firstIdx = (Integer)permutation.get(0);
                                if (firstIdx <= firstTokenIndex) {
                                    --firstIdx;
                                }
                                startOffset = (lt = (LookupToken)wLookupTokenList.get(firstIdx)).getStartOffset() < firstWordLookupToken.getStartOffset() ? lt.getStartOffset() : firstWordLookupToken.getStartOffset();
                            } else {
                                startOffset = firstWordLookupToken.getStartOffset();
                            }
                            if (permutation.size() > 0) {
                                LookupToken lt;
                                int lastIdx = (Integer)permutation.get(permutation.size() - 1);
                                if (lastIdx <= firstTokenIndex) {
                                    --lastIdx;
                                }
                                endOffset = (lt = (LookupToken)wLookupTokenList.get(lastIdx)).getEndOffset() > firstWordLookupToken.getEndOffset() ? lt.getEndOffset() : firstWordLookupToken.getEndOffset();
                            } else {
                                endOffset = firstWordLookupToken.getEndOffset();
                            }
                            LookupHit lh = new LookupHit(mdh, startOffset, endOffset);
                            lhList.add(lh);
                        }
                    }
                    ++fwPermIdx;
                }
                ++i3;
            }
        }
        return lhList;
    }

    private List getWindowAnnotations(Map contextMap) {
        List list = (List)contextMap.get(CTX_KEY_WINDOW_ANNOTATIONS);
        if (list == null || list.size() == 0) {
            this.iv_logger.debug("No context window annotations.");
            return new ArrayList();
        }
        return list;
    }

    private int getNumberOfListTokens(Map ltStartOffsetMap, Map ltEndOffsetMap, Map ltListIndexMap, int startOffset, int endOffset) {
        List startLookupTokenList = this.getLookupTokenList(startOffset, ltStartOffsetMap, true);
        List endLookupTokenList = this.getLookupTokenList(endOffset, ltEndOffsetMap, false);
        if (startLookupTokenList == null || endLookupTokenList == null) {
            this.iv_logger.debug("Invalid window:" + startOffset + "," + endOffset);
            return -1;
        }
        LookupToken startLookupToken = (LookupToken)startLookupTokenList.get(0);
        Integer startIdx = (Integer)ltListIndexMap.get(startLookupToken);
        LookupToken endLookupToken = (LookupToken)endLookupTokenList.get(endLookupTokenList.size() - 1);
        Integer endIdx = (Integer)ltListIndexMap.get(endLookupToken);
        return endIdx - startIdx + 1;
    }

    private List getLookupTokenList(int offset, Map ltOffsetMap, boolean traverseRight) {
        int i;
        List lookupTokenList = (List)ltOffsetMap.get(new Integer(offset));
        if (lookupTokenList != null) {
            return lookupTokenList;
        }
        int offsetWindow = 10;
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        if (traverseRight) {
            int max = offset + 10;
            i = offset;
            while (i <= max) {
                offsetList.add(new Integer(i));
                ++i;
            }
        } else {
            int min = offset - 10;
            i = offset;
            while (i >= min) {
                offsetList.add(new Integer(i));
                --i;
            }
        }
        for (Integer tempOffset : offsetList) {
            lookupTokenList = (List)ltOffsetMap.get(tempOffset);
            if (lookupTokenList == null) continue;
            return lookupTokenList;
        }
        return null;
    }

    private LookupAnnotation getLargestWindowAnnotation(int tokenIdx, LookupToken lt, Map ltStartOffsetMap, Map ltEndOffsetMap, Map ltListIndexMap, Map wStartOffsetMap, Map wEndOffsetMap) {
        HashSet startCandidateSet = new HashSet();
        HashSet endCandidateSet = new HashSet();
        for (Integer startOffset : wStartOffsetMap.keySet()) {
            if (startOffset > lt.getStartOffset()) continue;
            List wAnnotList = (List)wStartOffsetMap.get(startOffset);
            startCandidateSet.addAll(wAnnotList);
        }
        for (Integer endOffset : wEndOffsetMap.keySet()) {
            if (endOffset < lt.getEndOffset()) continue;
            List wAnnotList = (List)wEndOffsetMap.get(endOffset);
            endCandidateSet.addAll(wAnnotList);
        }
        startCandidateSet.retainAll(endCandidateSet);
        LookupAnnotation largestWindowAnnot = null;
        for (LookupAnnotation tempLookupAnnot : startCandidateSet) {
            if (largestWindowAnnot != null && tempLookupAnnot.getLength() <= largestWindowAnnot.getLength()) continue;
            int ltCount = this.getNumberOfListTokens(ltStartOffsetMap, ltEndOffsetMap, ltListIndexMap, tempLookupAnnot.getStartOffset(), tempLookupAnnot.getEndOffset());
            if (ltCount <= this.iv_maxPermutationLevel && ltCount > 0) {
                largestWindowAnnot = tempLookupAnnot;
                continue;
            }
            if (!this.iv_logger.isDebugEnabled()) continue;
            this.iv_logger.debug("Window size of " + ltCount + " exceeds the max permutation level of " + this.iv_maxPermutationLevel + ".");
        }
        return largestWindowAnnot;
    }

    private int getFixedWindowEndOffset(int tokenIdx, LookupToken lt, List ltList) {
        int fixedEndOffset = 0;
        int i = tokenIdx;
        while (i < tokenIdx + this.iv_maxPermutationLevel && i < ltList.size()) {
            LookupToken tempLookupToken = (LookupToken)ltList.get(i);
            if (tempLookupToken != null) {
                fixedEndOffset = tempLookupToken.getEndOffset();
            }
            ++i;
        }
        return fixedEndOffset;
    }

    private Map getListIndexMap(List list) {
        HashMap m = new HashMap();
        int i = 0;
        while (i < list.size()) {
            Integer index = new Integer(i);
            m.put(list.get(i), index);
            ++i;
        }
        return m;
    }

    private Map getStartOffsetMap(List lookupAnnotList, boolean hasMultiples) {
        HashMap<Integer, Object> m = new HashMap<Integer, Object>();
        for (LookupAnnotation la : lookupAnnotList) {
            Integer key = new Integer(la.getStartOffset());
            if (hasMultiples) {
                ArrayList<LookupAnnotation> list = (ArrayList<LookupAnnotation>)m.get(key);
                if (list == null) {
                    list = new ArrayList<LookupAnnotation>();
                }
                list.add(la);
                m.put(key, list);
                continue;
            }
            m.put(key, la);
        }
        return m;
    }

    private Map getEndOffsetMap(List lookupAnnotList, boolean hasMultiples) {
        HashMap<Integer, Object> m = new HashMap<Integer, Object>();
        for (LookupAnnotation la : lookupAnnotList) {
            Integer key = new Integer(la.getEndOffset());
            if (hasMultiples) {
                ArrayList<LookupAnnotation> list = (ArrayList<LookupAnnotation>)m.get(key);
                if (list == null) {
                    list = new ArrayList<LookupAnnotation>();
                }
                list.add(la);
                m.put(key, list);
                continue;
            }
            m.put(key, la);
        }
        return m;
    }

    private Collection getFirstTokenHits(LookupToken firstLookupToken) throws Exception {
        ArrayList<LookupToken> singleLtList = new ArrayList<LookupToken>();
        singleLtList.add(firstLookupToken);
        String[] phrases = this.iv_phrBuilder.getPhrases(singleLtList);
        ArrayList mdhCol = new ArrayList();
        int i = 0;
        while (i < phrases.length) {
            Collection curMdhCol = this.iv_firstTokenDictEngine.metaLookup(phrases[i]);
            if (curMdhCol.size() > 0) {
                mdhCol.addAll(curMdhCol);
            }
            ++i;
        }
        return mdhCol;
    }
}

