/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.lookup.phrasebuilder;

import edu.mayo.bmi.lookup.phrasebuilder.PhraseBuilder;
import edu.mayo.bmi.lookup.vo.LookupAnnotation;
import edu.mayo.bmi.lookup.vo.LookupToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class VariantPhraseBuilderImpl
implements PhraseBuilder {
    private List iv_textExtractorList = new ArrayList();

    public VariantPhraseBuilderImpl(String[] variantAttrNames, boolean useOriginalText) {
        if (useOriginalText) {
            this.iv_textExtractorList.add(new OriginalTextImpl());
        }
        int i = 0;
        while (i < variantAttrNames.length) {
            this.iv_textExtractorList.add(new AttributeTextImpl(variantAttrNames[i]));
            ++i;
        }
    }

    @Override
    public String[] getPhrases(List lookupTokenList) {
        HashSet<String> phraseSet = new HashSet<String>();
        for (TextExtractor te : this.iv_textExtractorList) {
            StringBuffer sb = new StringBuffer();
            LookupAnnotation previousLt = null;
            for (LookupToken lt : lookupTokenList) {
                String variant = te.getText(lt);
                if (variant == null) {
                    variant = lt.getText();
                }
                if (previousLt != null && previousLt.getEndOffset() != lt.getStartOffset()) {
                    sb.append(' ');
                }
                sb.append(variant);
                previousLt = lt;
            }
            String phrase = sb.toString().trim();
            phraseSet.add(phrase);
        }
        String[] phraseArr = new String[phraseSet.size()];
        phraseSet.toArray(phraseArr);
        return phraseArr;
    }

    class AttributeTextImpl
    implements TextExtractor {
        private String iv_varAttrName;

        public AttributeTextImpl(String varAttrName) {
            this.iv_varAttrName = varAttrName;
        }

        @Override
        public String getText(LookupToken lt) {
            return lt.getStringAttribute(this.iv_varAttrName);
        }
    }

    class OriginalTextImpl
    implements TextExtractor {
        OriginalTextImpl() {
        }

        @Override
        public String getText(LookupToken lt) {
            return lt.getText();
        }
    }

    private static interface TextExtractor {
        public String getText(LookupToken var1);
    }
}

