/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser.ae;

import clear.dep.DepNode;
import clear.dep.DepParser;
import clear.dep.DepTree;
import clear.morph.MorphEnAnalyzer;
import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.nlp.parser.util.ClearDependencyUtility;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class ClearParserAE
extends JCasAnnotator_ImplBase {
    public Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String DEPENDENCY_MODEL_FILE_PARAM = "DependencyModelFile";
    public static final String LEXICON_DIR_PARAM = "LexiconDirectory";
    public static final String FEATURE_TEMPLATE_PARAM = "FeatureTemplateFile";
    public static final String MORPH_DICT_PARAM = "MorphDictionaryDirectory";
    protected DepParser parser;
    protected MorphEnAnalyzer morph;
    private boolean useMorphy = false;
    private int parseFailureCount = 0;
    private int sentenceCount = 0;

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        String absParserModelPath = null;
        String absLexiconDirectoryPath = null;
        String absFeatureTemplateFile = null;
        try {
            String morphDictionaryPath = (String)uimaContext.getConfigParameterValue(MORPH_DICT_PARAM);
            File morphDictionaryFile = FileLocator.locateFile(morphDictionaryPath);
            if (morphDictionaryFile.exists()) {
                String absMorphDictionaryPath = morphDictionaryFile.getAbsolutePath();
                this.useMorphy = new File(absMorphDictionaryPath).isDirectory();
                this.morph = new MorphEnAnalyzer(absMorphDictionaryPath);
            } else {
                this.useMorphy = false;
            }
            this.logger.info("using Morphy analysis? " + this.useMorphy);
            String parserModelPath = (String)uimaContext.getConfigParameterValue(DEPENDENCY_MODEL_FILE_PARAM);
            File parserModelFile = FileLocator.locateFile(parserModelPath);
            absParserModelPath = parserModelFile.getAbsolutePath();
            this.logger.info("parser model file: " + absParserModelPath);
            String lexiconDirectoryPath = (String)uimaContext.getConfigParameterValue(LEXICON_DIR_PARAM);
            File lexiconDirectoryFile = FileLocator.locateFile(lexiconDirectoryPath);
            absLexiconDirectoryPath = lexiconDirectoryFile.getAbsolutePath();
            this.logger.info("lexicon directory: " + absLexiconDirectoryPath);
            String featureTemplatePath = (String)uimaContext.getConfigParameterValue(FEATURE_TEMPLATE_PARAM);
            File featureTemplateFile = FileLocator.locateFile(featureTemplatePath);
            absFeatureTemplateFile = featureTemplateFile.getAbsolutePath();
            this.logger.info("feature template file: " + absFeatureTemplateFile);
            this.parser = new DepParser(absLexiconDirectoryPath, absParserModelPath, absFeatureTemplateFile, 3);
            this.logger.info("done.");
        }
        catch (Exception e) {
            this.logger.info("Error initializing parser model: " + absParserModelPath);
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info(" process(JCas)");
        ArrayList<BaseToken> tokens = new ArrayList<BaseToken>();
        AnnotationIndex baseTokenIndex = jCas.getAnnotationIndex(BaseToken.type);
        FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
        while (sentences.hasNext()) {
            Sentence sentence = (Sentence)sentences.next();
            if (sentence.getBegin() == sentence.getEnd()) continue;
            tokens.clear();
            FSIterator tokenIterator = baseTokenIndex.subiterator(sentence);
            while (tokenIterator.hasNext()) {
                BaseToken token = (BaseToken)tokenIterator.next();
                tokens.add(token);
            }
            String[] words = new String[tokens.size()];
            String[] tags = new String[tokens.size()];
            String[] lemmas = new String[tokens.size()];
            String[] conlltokens = new String[tokens.size()];
            int i = 0;
            while (i < tokens.size()) {
                words[i] = ((BaseToken)tokens.get(i)).getCoveredText();
                tags[i] = ((BaseToken)tokens.get(i)).getPartOfSpeech();
                if (!this.useMorphy) {
                    lemmas[i] = ((BaseToken)tokens.get(i)).getNormalizedForm();
                }
                conlltokens[i] = String.valueOf(i + 1) + "\t" + words[i] + "\t_\t" + tags[i] + "\t" + tags[i] + "\t" + "_";
                ++i;
            }
            DepTree tree = new DepTree();
            int i2 = 0;
            while (i2 < words.length) {
                int id = i2 + 1;
                String form = words[i2];
                String pos = tags[i2];
                String lemma = this.useMorphy ? this.morph.getLemma(form, pos) : lemmas[i2];
                DepNode node = new DepNode();
                node.id = id;
                node.form = form;
                node.lemma = lemma == null ? form.toLowerCase() : lemma;
                node.pos = pos == null ? "_" : pos;
                tree.add(node);
                ++i2;
            }
            this.parser.parse(tree);
            ArrayList<ConllDependencyNode> nodes = ClearDependencyUtility.convert(jCas, tree, sentence, tokens);
            ClearDependencyUtility.addToIndexes(jCas, nodes);
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        System.out.println("total number of sentences that were not parsed was: " + this.parseFailureCount + " out of " + this.sentenceCount);
    }
}

