/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.smoking.ae;

import edu.mayo.bmi.smoking.Const;
import edu.mayo.bmi.uima.SmokingStatus.type.NonSmokerNamedEntityAnnotation;
import edu.mayo.bmi.uima.SmokingStatus.type.SmokerNamedEntityAnnotation;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.libsvm.type.NominalAttributeValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

public class ResolutionAnnotator {
    Set<String> conWords;
    public Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private String apiMacroHome = "\\$main_root";

    public void initialize(UimaContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.conWords = new HashSet<String>();
        try {
            String conWordsFileName = (String)aContext.getConfigParameterValue("negationContradictionWords");
            this.conWords = this.readLinesFromFile(FileLocator.locateFile(conWordsFileName).getAbsolutePath());
        }
        catch (Exception ace) {
            throw new AnnotatorConfigurationException(ace);
        }
    }

    public void process(JCas jcas) throws AnnotatorProcessException {
        String kuClassification = null;
        String pcsClassification = null;
        FSIterator navItr = jcas.getJFSIndexRepository().getAnnotationIndex(NominalAttributeValue.type).iterator();
        String navName = null;
        ArrayList<NominalAttributeValue> removalList = new ArrayList<NominalAttributeValue>();
        while (navItr.hasNext()) {
            NominalAttributeValue nav = (NominalAttributeValue)navItr.next();
            String string = nav.getNominalValue();
            if (string.equals("KNOWN") || string.equals("UNKNOWN")) {
                kuClassification = string;
                navName = nav.getAttributeName();
            } else if (string.equals("CURRENT_SMOKER") || string.equals("PAST_SMOKER") || string.equals("SMOKER")) {
                pcsClassification = string;
                navName = nav.getAttributeName();
            } else {
                throw new AnnotatorProcessException(new Exception("Nominal value not part of " + Const.class + ": " + string));
            }
            removalList.add(nav);
        }
        for (TOP tOP : removalList) {
            tOP.removeFromIndexes();
        }
        int n = this.getSmokerNegatedCount(jcas);
        int nonsmokerCnt = this.getNonSmokerNegatedCount(jcas);
        int negConCnt = this.getNegConCount(jcas);
        String finalClassification = null;
        finalClassification = kuClassification.equals("UNKNOWN") ? kuClassification : (n > 0 && negConCnt == 0 || nonsmokerCnt > 0 ? "NON_SMOKER" : pcsClassification);
        if (this.iv_logger.isInfoEnabled() && finalClassification != "UNKNOWN") {
            FSIterator senIter = jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type).iterator();
            while (senIter.hasNext()) {
                Sentence sen = (Sentence)senIter.next();
                this.iv_logger.info("|" + sen.getCoveredText() + "|" + finalClassification + "|" + n);
            }
        }
        NominalAttributeValue finalNav = new NominalAttributeValue(jcas);
        finalNav.setAttributeName(navName);
        finalNav.setNominalValue(finalClassification);
        finalNav.addToIndexes();
    }

    private Set<String> readLinesFromFile(String fileName) throws IOException {
        String line;
        HashSet<String> returnValues = new HashSet<String>();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            line = line.toLowerCase();
            returnValues.add(line);
        }
        return returnValues;
    }

    private int getSmokerNegatedCount(JCas jcas) {
        int negCnt = 0;
        FSIterator neItr = jcas.getJFSIndexRepository().getAnnotationIndex(SmokerNamedEntityAnnotation.type).iterator();
        while (neItr.hasNext()) {
            SmokerNamedEntityAnnotation neAnn = (SmokerNamedEntityAnnotation)neItr.next();
            int certainty = neAnn.getCertainty();
            if (certainty == -1) {
                ++negCnt;
            }
            this.iv_logger.info("***SmokerNameEntity***" + neAnn.getCoveredText() + " " + negCnt);
        }
        return negCnt;
    }

    private int getNonSmokerNegatedCount(JCas jcas) {
        int nonSmokerCnt = 0;
        FSIterator neItr = jcas.getJFSIndexRepository().getAnnotationIndex(NonSmokerNamedEntityAnnotation.type).iterator();
        while (neItr.hasNext()) {
            NonSmokerNamedEntityAnnotation neAnn = (NonSmokerNamedEntityAnnotation)neItr.next();
            this.iv_logger.info("***NonSmokerNameEntity***" + neAnn.getCoveredText() + " " + ++nonSmokerCnt + " " + neAnn.getCertainty());
        }
        return nonSmokerCnt;
    }

    private int getNegConCount(JCas jcas) {
        int conCnt = 0;
        FSIterator wordTokenItr = jcas.getJFSIndexRepository().getAnnotationIndex(WordToken.type).iterator();
        while (wordTokenItr.hasNext()) {
            WordToken token = (WordToken)wordTokenItr.next();
            String tok = token.getCoveredText();
            if (tok == null) continue;
            tok = tok.toLowerCase().replaceAll("[\\W]", " ").trim();
            String[] toks = tok.split("\\s");
            int i = 0;
            while (i < toks.length) {
                if (this.conWords.contains(toks[i])) {
                    ++conCnt;
                }
                ++i;
            }
        }
        return conCnt;
    }
}

