/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.adjuster;

import edu.mayo.bmi.uima.chunker.type.Chunk;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class ChunkAdjuster
extends JTextAnnotator_ImplBase {
    public static final String PARAM_CHUNK_PATTERN = "ChunkPattern";
    public static final String PARAM_EXTEND_TO_INCLUDE_TOKEN = "IndexOfTokenToInclude";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private AnnotatorContext context;
    private String[] chunksTypesInPattern;
    private int indexOfTokenToInclude;

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        this.context = aContext;
        try {
            this.configInit();
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorConfigurationException(ace);
        }
        catch (Exception e) {
            throw new AnnotatorConfigurationException(e);
        }
    }

    private void configInit() throws AnnotatorContextException, AnnotatorInitializationException {
        this.chunksTypesInPattern = (String[])this.context.getConfigParameterValue(PARAM_CHUNK_PATTERN);
        this.indexOfTokenToInclude = (Integer)this.context.getConfigParameterValue(PARAM_EXTEND_TO_INCLUDE_TOKEN);
        if (this.indexOfTokenToInclude < 0 || this.indexOfTokenToInclude >= this.chunksTypesInPattern.length) {
            Object[] msgArgs = new String[]{Integer.toString(this.indexOfTokenToInclude), PARAM_EXTEND_TO_INCLUDE_TOKEN};
            throw new AnnotatorInitializationException("annotator_parameter_not_valid", msgArgs);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        this.logger.info(" process(JCas)");
        String text = jcas.getDocumentText();
        try {
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator sentenceItr = indexes.getAnnotationIndex(Sentence.type).iterator();
            while (sentenceItr.hasNext()) {
                Sentence sentence = (Sentence)sentenceItr.next();
                int start = sentence.getBegin();
                int end = sentence.getEnd();
                this.annotateRange(jcas, text, start, end, resultSpec);
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    protected void annotateRange(JCas jcas, String text, int rangeBegin, int rangeEnd, ResultSpecification resultSpec) throws AnnotatorContextException, AnnotatorProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator chunkItr = indexes.getAnnotationIndex(Chunk.type).iterator();
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        while (chunkItr.hasNext()) {
            Chunk baseChunk = (Chunk)chunkItr.next();
            if (baseChunk.getBegin() < rangeBegin || baseChunk.getEnd() > rangeEnd) continue;
            list.add(baseChunk);
        }
        int i = 0;
        while (i < list.size()) {
            boolean matches = true;
            Chunk chunk = (Chunk)list.get(i);
            while (matches) {
                matches = this.compareToPattern(list, i);
                if (!matches) continue;
                this.extendChunk(chunk, list.get(i + this.indexOfTokenToInclude).getEnd());
                this.removeEnvelopedChunks(list, i);
            }
            ++i;
        }
    }

    private void removeEnvelopedChunks(ArrayList<Chunk> list, int i) {
        int j = 0;
        while (j < this.indexOfTokenToInclude) {
            Chunk chunk = list.remove(i + 1);
            ++j;
        }
    }

    private boolean compareToPattern(ArrayList<Chunk> list, int i) throws AnnotatorProcessException {
        boolean match = true;
        int len = list.size();
        int j = 0;
        while (j < this.chunksTypesInPattern.length) {
            if (i + j >= len || !list.get(i + j).getChunkType().equals(this.chunksTypesInPattern[j])) {
                match = false;
                break;
            }
            ++j;
        }
        return match;
    }

    private Chunk extendChunk(Chunk chunk, int newEnd) throws AnnotatorProcessException {
        if (newEnd < chunk.getBegin()) {
            Exception e = new Exception("New end offset (" + newEnd + ") < begin offset (" + chunk.getBegin() + ").");
            throw new AnnotatorProcessException(e);
        }
        chunk.setEnd(newEnd);
        return chunk;
    }
}

