/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.cdt.ae;

import edu.mayo.bmi.fsm.machine.DateFSM;
import edu.mayo.bmi.fsm.machine.FractionFSM;
import edu.mayo.bmi.fsm.machine.MeasurementFSM;
import edu.mayo.bmi.fsm.machine.PersonTitleFSM;
import edu.mayo.bmi.fsm.machine.RangeFSM;
import edu.mayo.bmi.fsm.machine.RomanNumeralFSM;
import edu.mayo.bmi.fsm.machine.TimeFSM;
import edu.mayo.bmi.fsm.output.DateToken;
import edu.mayo.bmi.fsm.output.FractionToken;
import edu.mayo.bmi.fsm.output.MeasurementToken;
import edu.mayo.bmi.fsm.output.PersonTitleToken;
import edu.mayo.bmi.fsm.output.RangeToken;
import edu.mayo.bmi.fsm.output.RomanNumeralToken;
import edu.mayo.bmi.fsm.output.TimeToken;
import edu.mayo.bmi.uima.cdt.type.DateAnnotation;
import edu.mayo.bmi.uima.cdt.type.FractionAnnotation;
import edu.mayo.bmi.uima.cdt.type.MeasurementAnnotation;
import edu.mayo.bmi.uima.cdt.type.PersonTitleAnnotation;
import edu.mayo.bmi.uima.cdt.type.RangeAnnotation;
import edu.mayo.bmi.uima.cdt.type.RomanNumeralAnnotation;
import edu.mayo.bmi.uima.cdt.type.TimeAnnotation;
import edu.mayo.bmi.uima.core.fsm.adapters.ContractionTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.DecimalTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.IntegerTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.NewlineTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.PunctuationTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.SymbolTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.WordTokenAdapter;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.NumToken;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class ContextDependentTokenizerAnnotator
extends JTextAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private DateFSM iv_dateFSM;
    private TimeFSM iv_timeFSM;
    private FractionFSM iv_fractionFSM;
    private RomanNumeralFSM iv_romanNumeralFSM;
    private RangeFSM iv_rangeFSM;
    private MeasurementFSM iv_measurementFSM;
    private PersonTitleFSM iv_personTitleFSM;

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        this.iv_dateFSM = new DateFSM();
        this.iv_timeFSM = new TimeFSM();
        this.iv_fractionFSM = new FractionFSM();
        this.iv_romanNumeralFSM = new RomanNumeralFSM();
        this.iv_rangeFSM = new RangeFSM();
        this.iv_measurementFSM = new MeasurementFSM();
        this.iv_personTitleFSM = new PersonTitleFSM();
        this.iv_logger.info("Finite state machines loaded.");
    }

    @Override
    public void process(JCas jcas, ResultSpecification rs) throws AnnotatorProcessException {
        try {
            this.iv_logger.info(" process(JCas, ResultSpecification)");
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator sentItr = indexes.getAnnotationIndex(Sentence.type).iterator();
            AnnotationIndex baseTokenIndex = jcas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type);
            while (sentItr.hasNext()) {
                Sentence sentAnnot = (Sentence)sentItr.next();
                FSIterator btaItr = baseTokenIndex.subiterator(sentAnnot);
                ArrayList<edu.mayo.bmi.fsm.token.BaseToken> baseTokenList = new ArrayList<edu.mayo.bmi.fsm.token.BaseToken>();
                while (btaItr.hasNext()) {
                    BaseToken bta = (BaseToken)btaItr.next();
                    baseTokenList.add(this.adaptToBaseToken(bta));
                }
                this.executeFSMs(jcas, baseTokenList);
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private void executeFSMs(JCas jcas, List<? extends edu.mayo.bmi.fsm.token.BaseToken> baseTokenList) throws AnnotatorProcessException {
        try {
            Set<DateToken> dateTokenSet = this.iv_dateFSM.execute(baseTokenList);
            for (DateToken dt : dateTokenSet) {
                DateAnnotation dta = new DateAnnotation(jcas, dt.getStartOffset(), dt.getEndOffset());
                dta.addToIndexes();
            }
            Set<TimeToken> timeTokenSet = this.iv_timeFSM.execute(baseTokenList);
            for (TimeToken tt : timeTokenSet) {
                TimeAnnotation ta = new TimeAnnotation(jcas, tt.getStartOffset(), tt.getEndOffset());
                ta.addToIndexes();
            }
            Set<RomanNumeralToken> romanNumeralTokenSet = this.iv_romanNumeralFSM.execute(baseTokenList);
            for (RomanNumeralToken rnt : romanNumeralTokenSet) {
                RomanNumeralAnnotation rna = new RomanNumeralAnnotation(jcas, rnt.getStartOffset(), rnt.getEndOffset());
                rna.addToIndexes();
            }
            Set<FractionToken> fractionTokenSet = this.iv_fractionFSM.execute(baseTokenList);
            for (FractionToken ft : fractionTokenSet) {
                FractionAnnotation fa = new FractionAnnotation(jcas, ft.getStartOffset(), ft.getEndOffset());
                fa.addToIndexes();
            }
            Set<RangeToken> rangeTokenSet = this.iv_rangeFSM.execute(baseTokenList, romanNumeralTokenSet);
            for (RangeToken rt : rangeTokenSet) {
                RangeAnnotation ra = new RangeAnnotation(jcas, rt.getStartOffset(), rt.getEndOffset());
                ra.addToIndexes();
            }
            Set<MeasurementToken> measurementTokenSet = this.iv_measurementFSM.execute(baseTokenList, rangeTokenSet);
            for (MeasurementToken mt : measurementTokenSet) {
                MeasurementAnnotation ma = new MeasurementAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma.addToIndexes();
            }
            Set<PersonTitleToken> personTitleTokenSet = this.iv_personTitleFSM.execute(baseTokenList);
            for (PersonTitleToken ptt : personTitleTokenSet) {
                PersonTitleAnnotation pta = new PersonTitleAnnotation(jcas, ptt.getStartOffset(), ptt.getEndOffset());
                pta.addToIndexes();
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private edu.mayo.bmi.fsm.token.BaseToken adaptToBaseToken(BaseToken obj) throws Exception {
        if (obj instanceof WordToken) {
            WordToken wta = (WordToken)obj;
            return new WordTokenAdapter(wta);
        }
        if (obj instanceof NumToken) {
            NumToken nta = (NumToken)obj;
            if (nta.getNumType() == 1) {
                return new IntegerTokenAdapter(nta);
            }
            return new DecimalTokenAdapter(nta);
        }
        if (obj instanceof PunctuationToken) {
            PunctuationToken pta = (PunctuationToken)obj;
            return new PunctuationTokenAdapter(pta);
        }
        if (obj instanceof NewlineToken) {
            NewlineToken nta = (NewlineToken)obj;
            return new NewlineTokenAdapter(nta);
        }
        if (obj instanceof ContractionToken) {
            ContractionToken cta = (ContractionToken)obj;
            return new ContractionTokenAdapter(cta);
        }
        if (obj instanceof SymbolToken) {
            SymbolToken sta = (SymbolToken)obj;
            return new SymbolTokenAdapter(sta);
        }
        throw new Exception("No Context Dependent Tokenizer adapter for class: " + obj.getClass());
    }
}

