/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.chunker;

import edu.mayo.bmi.uima.chunker.ChunkCreator;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.io.File;
import java.util.ArrayList;
import opennlp.tools.lang.english.TreebankChunker;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class Chunker
extends JCasAnnotator_ImplBase {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String CHUNKER_MODEL_FILE_PARAM = "ChunkerModelFile";
    public static final String CHUNKER_CREATOR_CLASS_PARAM = "ChunkCreatorClass";
    private opennlp.tools.chunker.Chunker chunker;
    ChunkCreator chunkerCreator;

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        String chunkerModelPath = null;
        try {
            chunkerModelPath = (String)uimaContext.getConfigParameterValue(CHUNKER_MODEL_FILE_PARAM);
            File chunkerModelFile = FileLocator.locateFile(chunkerModelPath);
            String chunkerModelAbsPath = chunkerModelFile.getAbsolutePath();
            this.logger.info("Chunker model file: " + chunkerModelAbsPath);
            this.chunker = new TreebankChunker(chunkerModelAbsPath);
            String chunkerCreatorClassName = (String)uimaContext.getConfigParameterValue(CHUNKER_CREATOR_CLASS_PARAM);
            this.chunkerCreator = (ChunkCreator)Class.forName(chunkerCreatorClassName).newInstance();
            this.chunkerCreator.initialize(uimaContext);
        }
        catch (Exception e) {
            this.logger.info("Chunker model: " + chunkerModelPath);
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info(" process(JCas)");
        ArrayList<BaseToken> tokens = new ArrayList<BaseToken>();
        AnnotationIndex baseTokenIndex = jCas.getAnnotationIndex(BaseToken.type);
        FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
        while (sentences.hasNext()) {
            int chunkEnd;
            Sentence sentence = (Sentence)sentences.next();
            tokens.clear();
            FSIterator tokenIterator = baseTokenIndex.subiterator(sentence);
            while (tokenIterator.hasNext()) {
                BaseToken token = (BaseToken)tokenIterator.next();
                tokens.add(token);
            }
            Object[] words = new String[tokens.size()];
            String[] tags = new String[tokens.size()];
            int i = 0;
            while (i < tokens.size()) {
                words[i] = ((BaseToken)tokens.get(i)).getCoveredText();
                tags[i] = ((BaseToken)tokens.get(i)).getPartOfSpeech();
                ++i;
            }
            String[] chunks = this.chunker.chunk(words, tags);
            int chunkBegin = 0;
            String chunkType = "";
            int i2 = 0;
            while (i2 < chunks.length) {
                if (i2 > 0 && !chunks[i2].startsWith("I-") && !chunks[i2 - 1].equals("O")) {
                    chunkEnd = ((BaseToken)tokens.get(i2 - 1)).getEnd();
                    this.chunkerCreator.createChunk(jCas, chunkBegin, chunkEnd, chunkType);
                }
                if (chunks[i2].startsWith("B-")) {
                    chunkBegin = ((BaseToken)tokens.get(i2)).getBegin();
                    chunkType = chunks[i2].substring(2);
                }
                ++i2;
            }
            if (chunks.length <= 0 || chunks[chunks.length - 1].equals("O")) continue;
            chunkEnd = ((BaseToken)tokens.get(chunks.length - 1)).getEnd();
            this.chunkerCreator.createChunk(jCas, chunkBegin, chunkEnd, chunkType);
        }
    }
}

