/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.nlp.preprocessor.ClinicalNotePreProcessor;
import edu.mayo.bmi.nlp.preprocessor.DocumentMetaData;
import edu.mayo.bmi.nlp.preprocessor.SegmentMetaData;
import edu.mayo.bmi.uima.core.ci.HyphenTextModifierImpl;
import edu.mayo.bmi.uima.core.ci.TextModification;
import edu.mayo.bmi.uima.core.ci.TextModifier;
import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.type.DocumentID;
import edu.mayo.bmi.uima.core.type.Properties;
import edu.mayo.bmi.uima.core.type.Property;
import edu.mayo.bmi.uima.core.type.Segment;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;

public class CdaCasInitializer
extends JCasAnnotator_ImplBase {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private File dtdFile;
    private Boolean includeSectionMarkers;
    private TextModifier tm;
    private UimaContext uimaContext;

    @Override
    public void initialize(UimaContext aCtx) throws ResourceInitializationException {
        super.initialize(aCtx);
        this.uimaContext = aCtx;
        this.initialize();
    }

    public void initialize() throws ResourceInitializationException {
        this.includeSectionMarkers = new Boolean(false);
        int hyphWindow = 3;
        try {
            FileResource hyphResrc = (FileResource)this.uimaContext.getResourceObject("HyphenDictionary");
            File hyphFile = hyphResrc.getFile();
            this.logger.info("Hyphen dictionary: " + hyphFile.getAbsolutePath());
            this.tm = new HyphenTextModifierImpl(hyphFile.getAbsolutePath(), hyphWindow);
            FileResource dtdResrc = (FileResource)this.uimaContext.getResourceObject("DTD");
            this.dtdFile = dtdResrc.getFile();
            this.logger.info("DTD: " + this.dtdFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    private void applyTextModifier(String text, StringBuffer sb) throws Exception {
        TextModification[] textModArr = this.tm.modify(text);
        int i = 0;
        while (i < textModArr.length) {
            TextModification textMod = textModArr[i];
            if (textMod.getOrigStartOffset() != textMod.getNewStartOffset() || textMod.getOrigEndOffset() != textMod.getNewEndOffset()) {
                this.logger.warn("UNSUPPORTED: TextModification with offset changes.");
            } else {
                sb.replace(textMod.getOrigStartOffset(), textMod.getOrigEndOffset(), textMod.getNewText());
            }
            ++i;
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.logger.info(" process(JCas)");
        String originalText = null;
        try {
            JCas originalView = jcas.getView("_InitialView");
            originalText = originalView.getSofaDataString();
            FSIterator docItr = originalView.getAnnotationIndex(DocumentID.type).iterator();
            DocumentID docID = null;
            if (docItr.hasNext()) {
                docID = (DocumentID)docItr.next();
            }
            ClinicalNotePreProcessor pp = new ClinicalNotePreProcessor(this.dtdFile, this.includeSectionMarkers);
            DocumentMetaData dmd = pp.process(originalText);
            String text = dmd.getText();
            StringBuffer sb = new StringBuffer(text);
            this.applyTextModifier(text, sb);
            JCas plaintextView = jcas.createView("plaintext");
            plaintextView.setDocumentText(sb.toString());
            for (String segmentID : dmd.getSegmentIdentifiers()) {
                SegmentMetaData smd = dmd.getSegment(segmentID);
                Segment sa = new Segment(plaintextView);
                sa.setBegin(smd.span.start);
                sa.setEnd(smd.span.end);
                sa.setId(smd.id);
                sa.addToIndexes();
            }
            if (docID != null) {
                DocumentID newDocId = new DocumentID(plaintextView);
                newDocId.setBegin(docID.getBegin());
                newDocId.setEnd(docID.getEnd());
                newDocId.setDocumentID(docID.getDocumentID());
                newDocId.addToIndexes();
            }
            Properties propAnnot = new Properties(plaintextView);
            Map metaDataMap = dmd.getMetaData();
            FSArray fsArr = new FSArray(plaintextView, metaDataMap.size());
            Iterator keyItr = metaDataMap.keySet().iterator();
            int pos = 0;
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                Object value = metaDataMap.get(key);
                if (value instanceof String) {
                    Property prop = new Property(plaintextView);
                    prop.setKey(key);
                    prop.setValue((String)value);
                    fsArr.set(pos++, prop);
                    continue;
                }
                boolean cfr_ignored_0 = value instanceof HashSet;
            }
            propAnnot.setPropArr(fsArr);
            propAnnot.addToIndexes();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
    }
}

