/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.uima.core.util.JCasUtil;
import edu.mayo.bmi.uima.core.util.ParamUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.TOP;

public class CopyAnnotator
extends JTextAnnotator_ImplBase {
    private int iv_srcType;
    private Constructor iv_destContr;
    private Map iv_getSetMap;

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        try {
            String className = (String)annotCtx.getConfigParameterValue("srcObjClass");
            Class<?> srcClass = Class.forName(className);
            this.iv_srcType = JCasUtil.getType(className);
            className = (String)annotCtx.getConfigParameterValue("destObjClass");
            Class<?> destClass = Class.forName(className);
            Class[] constrArgs = new Class[]{JCas.class};
            this.iv_destContr = destClass.getConstructor(constrArgs);
            Map<String, String> m = ParamUtil.getStringParameterValuesMap("dataBindMap", annotCtx, "|");
            this.iv_getSetMap = new HashMap();
            for (String getterMethName : m.keySet()) {
                String setterMethName = m.get(getterMethName);
                Method getterMeth = srcClass.getMethod(getterMethName, null);
                Class[] setterArgs = new Class[]{getterMeth.getReturnType()};
                Method setterMeth = destClass.getMethod(setterMethName, setterArgs);
                this.iv_getSetMap.put(getterMeth, setterMeth);
            }
        }
        catch (Exception e) {
            throw new AnnotatorInitializationException(e);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification rs) throws AnnotatorProcessException {
        System.out.println("CopyAnnotator process(JCas ResultSpecification)");
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator srcObjItr = indexes.getAnnotationIndex(this.iv_srcType).iterator();
        while (srcObjItr.hasNext()) {
            TOP srcObj = (TOP)srcObjItr.next();
            Object[] constrArgVals = new Object[]{jcas};
            try {
                TOP destObj = (TOP)this.iv_destContr.newInstance(constrArgVals);
                for (Method getterMeth : this.iv_getSetMap.keySet()) {
                    Method setterMeth = (Method)this.iv_getSetMap.get(getterMeth);
                    Object val = getterMeth.invoke((Object)srcObj, null);
                    Object[] setterArgs = new Object[]{val};
                    setterMeth.invoke((Object)destObj, setterArgs);
                }
                destObj.addToIndexes();
            }
            catch (Exception e) {
                throw new AnnotatorProcessException(e);
            }
        }
    }
}

