/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.uima.core.resource.MaxentModelResource;
import edu.mayo.bmi.uima.core.sentence.EndOfSentenceScannerImpl;
import edu.mayo.bmi.uima.core.sentence.SentenceSpan;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.util.ParamUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SentenceDetector
extends JTextAnnotator_ImplBase {
    public static final String PARAM_SEGMENTS_TO_SKIP = "SegmentsToSkip";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final String MAXENT_MODEL_RESRC_KEY = "MaxentModel";
    private AnnotatorContext context;
    private Set<?> skipSegmentsSet;
    private SentenceDetectorME sentenceDetector;
    private String NEWLINE = "\n";
    private int sentenceCount = 0;

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        this.context = aContext;
        try {
            this.configInit();
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorConfigurationException(ace);
        }
    }

    private void configInit() throws AnnotatorContextException {
        MaxentModelResource mmResrc = (MaxentModelResource)this.context.getResourceObject("MaxentModel");
        if (mmResrc == null) {
            this.logger.warn("Unable to locate resource with key=MaxentModel.");
        } else {
            EndOfSentenceScannerImpl eoss = new EndOfSentenceScannerImpl();
            char[] eosc = eoss.getEndOfSentenceCharacters();
            DefaultSDContextGenerator cg = new DefaultSDContextGenerator(eosc);
            this.sentenceDetector = new SentenceDetectorME(mmResrc.getModel(), cg, eoss);
        }
        this.skipSegmentsSet = ParamUtil.getStringParameterValuesSet(PARAM_SEGMENTS_TO_SKIP, this.context);
    }

    @Override
    public void process(JCas jcas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        this.logger.info("Starting processing.");
        this.sentenceCount = 0;
        String text = jcas.getDocumentText();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator sectionItr = indexes.getAnnotationIndex(Segment.type).iterator();
        while (sectionItr.hasNext()) {
            Segment sa = (Segment)sectionItr.next();
            String sectionID = sa.getId();
            if (this.skipSegmentsSet.contains(sectionID)) continue;
            this.sentenceCount = this.annotateRange(jcas, text, sa, this.sentenceCount);
        }
    }

    protected int annotateRange(JCas jcas, String text, Segment section, int sentenceCount) throws AnnotatorProcessException {
        String coveredText;
        int b = section.getBegin();
        int e = section.getEnd();
        int[] sentenceBreaks = this.sentenceDetector.sentPosDetect(text.substring(b, e));
        int numSentences = sentenceBreaks.length;
        SentenceSpan[] potentialSentSpans = new SentenceSpan[numSentences + 1];
        int sentStart = b;
        int sentEnd = b;
        int i = 0;
        while (i < numSentences) {
            sentEnd = sentenceBreaks[i] + b;
            String coveredText2 = text.substring(sentStart, sentEnd);
            potentialSentSpans[i] = new SentenceSpan(sentStart, sentEnd, coveredText2);
            sentStart = sentEnd;
            ++i;
        }
        if (sentEnd < e && (coveredText = text.substring(sentEnd, e)).trim() != "") {
            potentialSentSpans[numSentences] = new SentenceSpan(sentEnd, e, coveredText);
            ++numSentences;
        }
        ArrayList<SentenceSpan> sentenceSpans = new ArrayList<SentenceSpan>(0);
        int i2 = 0;
        while (i2 < potentialSentSpans.length) {
            if (potentialSentSpans[i2] != null) {
                sentenceSpans.addAll(potentialSentSpans[i2].splitAtLineBreaksAndTrim(this.NEWLINE));
            }
            ++i2;
        }
        int previousEnd = -1;
        int i3 = 0;
        while (i3 < sentenceSpans.size()) {
            SentenceSpan span = (SentenceSpan)sentenceSpans.get(i3);
            if (span.getStart() != span.getEnd()) {
                Sentence sa = new Sentence(jcas);
                sa.setBegin(span.getStart());
                sa.setEnd(span.getEnd());
                if (previousEnd <= sa.getBegin()) {
                    sa.setSentenceNumber(sentenceCount);
                    sa.addToIndexes();
                    ++sentenceCount;
                    previousEnd = span.getEnd();
                } else {
                    this.logger.error("Skipping sentence from " + span.getStart() + " to " + span.getEnd());
                    this.logger.error("Overlap with previous sentence that ended at " + previousEnd);
                }
            }
            ++i3;
        }
        return sentenceCount;
    }

    public static void main(String[] args) throws IOException {
        Logger logger = Logger.getLogger(String.valueOf(SentenceDetector.class.getName()) + ".main()");
        if (args.length < 2 || args.length > 4) {
            SentenceDetector.usage(logger);
            System.exit(-1);
        }
        File inFile = SentenceDetector.getReadableFile(args[0]);
        File outFile = SentenceDetector.getFileInExistingDir(args[1]);
        int iters = 100;
        if (args.length > 2) {
            iters = SentenceDetector.parseInt(args[2], logger);
        }
        int cut = 5;
        if (args.length > 3) {
            cut = SentenceDetector.parseInt(args[3], logger);
        }
        EndOfSentenceScannerImpl scanner = new EndOfSentenceScannerImpl();
        int numEosc = scanner.getEndOfSentenceCharacters().length;
        logger.info("Training new model from " + inFile.getAbsolutePath());
        logger.info("Using " + numEosc + " end of sentence characters.");
        GISModel mod = SentenceDetectorME.train(inFile, iters, cut, scanner);
        SuffixSensitiveGISModelWriter ssgmw = new SuffixSensitiveGISModelWriter(mod, outFile);
        logger.info("Saving the model as: " + outFile.getAbsolutePath());
        ssgmw.persist();
    }

    public static void usage(Logger log) {
        log.info("Usage: java " + SentenceDetector.class.getName() + " training_data_filename name_of_model_to_create <iters> <cut>");
    }

    public static int parseInt(String s, Logger log) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse '" + s + "' as an integer.");
            throw nfe;
        }
    }

    public static File getReadableFile(String fn) throws IOException {
        File f = new File(fn);
        if (!f.canRead()) {
            throw new IOException("Unable to read from file " + f.getAbsolutePath());
        }
        return f;
    }

    public static File getFileInExistingDir(String fn) throws IOException {
        File f = new File(fn);
        if (!f.getParentFile().isDirectory()) {
            throw new IOException("Directory not found: " + f.getParentFile().getAbsolutePath());
        }
        return f;
    }
}

