/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;

public class SimpleSegmentAnnotator
extends JTextAnnotator_ImplBase {
    private String segmentId;

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        try {
            this.segmentId = (String)aContext.getConfigParameterValue("SegmentID");
            if (this.segmentId == null) {
                this.segmentId = "SIMPLE_SEGMENT";
            }
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorConfigurationException(ace);
        }
    }

    @Override
    public void process(JCas jCas, ResultSpecification resultSpecification) throws AnnotatorProcessException {
        Segment segment = new Segment(jCas);
        segment.setBegin(0);
        String text = jCas.getDocumentText();
        if (text == null) {
            String docId = DocumentIDAnnotationUtil.getDocumentID(jCas);
            throw new AnnotatorProcessException("text is null for docId=" + docId, null);
        }
        segment.setEnd(jCas.getDocumentText().length());
        segment.setId(this.segmentId);
        segment.addToIndexes();
    }
}

