/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.nlp.tokenizer.Token;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.NumToken;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import org.apache.uima.jcas.JCas;

public class TokenConverter {
    public static BaseToken convert(Token t, JCas jcas, int beginPos) {
        BaseToken bta = null;
        int begin = beginPos + t.getStartOffset();
        int end = beginPos + t.getEndOffset();
        switch (t.getType()) {
            case 1: {
                WordToken wta = new WordToken(jcas);
                wta.setBegin(begin);
                wta.setEnd(end);
                int cap = -1;
                switch (t.getCaps()) {
                    case 4: {
                        cap = 3;
                        break;
                    }
                    case 3: {
                        cap = 1;
                        break;
                    }
                    case 2: {
                        cap = 2;
                        break;
                    }
                    case 1: {
                        cap = 0;
                    }
                }
                int numPos = -1;
                switch (t.getNumPosition()) {
                    case 1: {
                        numPos = 1;
                        break;
                    }
                    case 2: {
                        numPos = 2;
                        break;
                    }
                    case 3: {
                        numPos = 3;
                        break;
                    }
                    case 0: {
                        numPos = 0;
                    }
                }
                wta.setCapitalization(cap);
                wta.setNumPosition(numPos);
                bta = wta;
                break;
            }
            case 2: {
                NumToken nta = new NumToken(jcas);
                nta.setBegin(begin);
                nta.setEnd(end);
                if (t.isInteger()) {
                    nta.setNumType(1);
                } else {
                    nta.setNumType(2);
                }
                bta = nta;
                break;
            }
            case 3: {
                PunctuationToken pta = new PunctuationToken(jcas);
                pta.setBegin(begin);
                pta.setEnd(end);
                bta = pta;
                break;
            }
            case 4: {
                NewlineToken nlta = new NewlineToken(jcas);
                nlta.setBegin(begin);
                nlta.setEnd(end);
                bta = nlta;
                break;
            }
            case 5: {
                ContractionToken cta = new ContractionToken(jcas);
                cta.setBegin(begin);
                cta.setEnd(end);
                bta = cta;
                break;
            }
            case 6: {
                SymbolToken sta = new SymbolToken(jcas);
                sta.setBegin(begin);
                sta.setEnd(end);
                bta = sta;
            }
        }
        return bta;
    }

    public static Token convert(BaseToken bta) {
        Token token = new Token(bta.getBegin(), bta.getEnd());
        token.setText(bta.getCoveredText());
        if (bta instanceof WordToken) {
            WordToken wta = (WordToken)bta;
            token.setType((byte)1);
            switch (wta.getCapitalization()) {
                case 3: {
                    token.setCaps((byte)4);
                    break;
                }
                case 1: {
                    token.setCaps((byte)3);
                    break;
                }
                case 2: {
                    token.setCaps((byte)2);
                    break;
                }
                case 0: {
                    token.setCaps((byte)1);
                }
            }
            switch (wta.getNumPosition()) {
                case 1: {
                    token.setNumPosition((byte)1);
                    break;
                }
                case 2: {
                    token.setNumPosition((byte)2);
                    break;
                }
                case 3: {
                    token.setNumPosition((byte)3);
                    break;
                }
                case 0: {
                    token.setNumPosition((byte)0);
                }
            }
        } else if (bta instanceof NumToken) {
            NumToken nta = (NumToken)bta;
            token.setType((byte)2);
            if (nta.getNumType() == 1) {
                token.setIsInteger(true);
            } else {
                token.setIsInteger(false);
            }
        } else if (bta instanceof PunctuationToken) {
            token.setType((byte)3);
        } else if (bta instanceof NewlineToken) {
            token.setType((byte)4);
        } else if (bta instanceof ContractionToken) {
            token.setType((byte)5);
        } else if (bta instanceof SymbolToken) {
            token.setType((byte)6);
        }
        return token;
    }
}

