/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.cc;

import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class CasConsumer
extends CasConsumer_ImplBase {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private String iv_outputDir = null;
    private int iv_procCount = 0;

    @Override
    public void initialize() throws ResourceInitializationException {
        this.iv_outputDir = (String)this.getConfigParameterValue("outputDir");
    }

    private void processView(JCas view) throws Exception {
        String docName = DocumentIDAnnotationUtil.getDocumentID(view);
        docName = docName == null ? "doc" + this.iv_procCount + ".xml" : String.valueOf(docName) + ".xml";
        OutputStream out = null;
        try {
            File outputDir = new File(this.iv_outputDir);
            outputDir.mkdirs();
            File outputFile = new File(String.valueOf(this.iv_outputDir) + File.separatorChar + docName);
            out = new FileOutputStream(outputFile);
            XCASSerializer.serialize(view.getCas(), out, true);
        }
        finally {
            ++this.iv_procCount;
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        this.iv_logger.info("Started");
        try {
            JCas currentView = cas.getCurrentView().getJCas();
            this.processView(currentView);
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }
}

