/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ci;

import edu.mayo.bmi.nlp.tokenizer.Token;
import edu.mayo.bmi.nlp.tokenizer.Tokenizer;
import edu.mayo.bmi.uima.core.ci.TextModification;
import edu.mayo.bmi.uima.core.ci.TextModifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyphenTextModifierImpl
implements TextModifier {
    private Map iv_shouldbeHyphenMap = null;
    private int iv_windowSize = 3;
    private Tokenizer iv_tokenizer = null;

    public HyphenTextModifierImpl(String hyphenfilename, int windowSize) {
        this.iv_windowSize = windowSize;
        this.iv_tokenizer = new Tokenizer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(hyphenfilename)));
            String line = "";
            this.iv_shouldbeHyphenMap = new HashMap();
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("\\|");
                String[] unh = toks[0].split("\\-");
                String shouldbehyphen = "";
                int i = 0;
                while (i < unh.length) {
                    shouldbehyphen = String.valueOf(shouldbehyphen) + " " + unh[i];
                    ++i;
                }
                shouldbehyphen = shouldbehyphen.trim().toLowerCase();
                this.iv_shouldbeHyphenMap.put(shouldbehyphen, new Integer(1));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot find the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOException accessing the hyphenation file:" + hyphenfilename);
            e.printStackTrace();
        }
    }

    private void filterTokens(List tokenList) {
        ArrayList<Token> removalList = new ArrayList<Token>();
        for (Token token : tokenList) {
            if (token.getType() != 4) continue;
            removalList.add(token);
        }
        tokenList.removeAll(removalList);
    }

    @Override
    public TextModification[] modify(String in) throws Exception {
        ArrayList<TextModification> textmods = new ArrayList<TextModification>();
        List<Token> inputtoks = this.iv_tokenizer.tokenizeAndSort(in);
        this.filterTokens(inputtoks);
        int orig_startOffset = 0;
        int orig_endOffset = 0;
        int new_startOffset = 0;
        int new_endOffset = 0;
        int i = 0;
        int j = 0;
        int end_offset_adj = 0;
        int start_offset_adj = 0;
        while (i < inputtoks.size()) {
            j = inputtoks.size() - (i + 1) < this.iv_windowSize ? inputtoks.size() - 1 : i + this.iv_windowSize;
            while (j > i) {
                StringBuffer candSB = new StringBuffer();
                int k = i;
                while (k <= j) {
                    Token currtok = inputtoks.get(k);
                    candSB.append(" ");
                    candSB.append(currtok.getText());
                    ++k;
                }
                String cand = candSB.toString().trim();
                if (this.iv_shouldbeHyphenMap.containsKey(cand.toLowerCase())) {
                    orig_startOffset = inputtoks.get(i).getStartOffset();
                    orig_endOffset = inputtoks.get(j).getEndOffset();
                    new_startOffset = orig_startOffset;
                    new_endOffset = orig_endOffset;
                    String newText = "";
                    int k2 = i;
                    while (k2 <= j) {
                        Token currtok = inputtoks.get(k2);
                        newText = String.valueOf(newText) + currtok.getText() + "-";
                        ++k2;
                    }
                    newText = newText.substring(0, newText.length() - 1);
                    int new_Length = newText.length();
                    int orig_Length = orig_endOffset - orig_startOffset;
                    TextModification tm = new TextModification(orig_startOffset, orig_endOffset, new_startOffset - start_offset_adj, new_endOffset - (end_offset_adj += orig_Length - new_Length), newText);
                    start_offset_adj += orig_Length - new_Length;
                    textmods.add(tm);
                    i = j;
                }
                --j;
            }
            ++i;
        }
        TextModification[] tma = new TextModification[textmods.size()];
        int y = 0;
        while (y < tma.length) {
            tma[y] = (TextModification)textmods.get(y);
            ++y;
        }
        return tma;
    }

    private static boolean applyTextModifier(TextModifier tm, String text, StringBuffer sb) throws Exception {
        boolean unableToModifyText = false;
        TextModification[] textModArr = tm.modify(text);
        int i = 0;
        while (i < textModArr.length) {
            TextModification textMod = textModArr[i];
            if (textMod.getOrigStartOffset() != textMod.getNewStartOffset() || textMod.getOrigEndOffset() != textMod.getNewEndOffset()) {
                System.err.println("UNSUPPORTED: TextModification with offset changes.");
                unableToModifyText = true;
            } else {
                sb.replace(textMod.getOrigStartOffset(), textMod.getOrigEndOffset(), textMod.getNewText());
            }
            ++i;
        }
        return unableToModifyText;
    }

    public static ArrayList<String> test(HyphenTextModifierImpl tm, String text) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            TextModification[] tma = tm.modify(text);
            StringBuffer sb = new StringBuffer(text);
            boolean errorModifyingText = HyphenTextModifierImpl.applyTextModifier(tm, text, sb);
            messages.add("Orig: " + text);
            if (!errorModifyingText) {
                messages.add("New:  " + sb);
            } else {
                System.err.println("New:  (new text not generated, see previous messages)");
            }
            int u = 0;
            while (u < tma.length) {
                TextModification tmo = tma[u];
                messages.add(String.valueOf(tmo.getNewText()) + " Orig: " + tmo.getOrigStartOffset() + "-" + tmo.getOrigEndOffset() + " New: " + tmo.getNewStartOffset() + "-" + tmo.getNewEndOffset());
                ++u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return messages;
    }

    public static void main(String[] args) {
        HyphenTextModifierImpl tm = new HyphenTextModifierImpl(args[0], 7);
        String t = "Non  Hodgkin's the x  ray without any non small  cell complications.";
        ArrayList<String> messages = HyphenTextModifierImpl.test(tm, t);
        for (String s : messages) {
            System.out.println(s);
        }
        t = t.replace("  ", " ");
        messages = HyphenTextModifierImpl.test(tm, t);
        for (String s : messages) {
            System.out.println(s);
        }
    }
}

