/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.cr;

import edu.mayo.bmi.uima.core.type.DocumentID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FilesInDirectoryCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_EXTENSIONS = "Extensions";
    public static final String PARAM_RECURSE = "Recurse";
    protected ArrayList iv_files;
    private String iv_encoding;
    private String iv_language;
    private static String[] iv_extensions;
    protected int iv_currentIndex;
    private boolean iv_recurse = false;
    private String iv_rootPath = "";

    @Override
    public void initialize() throws ResourceInitializationException {
        File directory = new File((String)this.getConfigParameterValue(PARAM_INPUTDIR));
        this.iv_encoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.iv_language = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        iv_extensions = (String[])this.getConfigParameterValue(PARAM_EXTENSIONS);
        this.iv_currentIndex = 0;
        this.iv_recurse = false;
        Boolean recurse = (Boolean)this.getConfigParameterValue(PARAM_RECURSE);
        if (recurse != null) {
            this.iv_recurse = recurse;
        }
        this.iv_rootPath = directory.getPath();
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.iv_files = new ArrayList();
        if (!this.iv_recurse) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory() && this.hasValidExtension(files[i])) {
                    this.iv_files.add(files[i]);
                }
                ++i;
            }
        } else {
            try {
                this.collectFiles(directory, this.iv_files);
                System.out.println("iv_files.size()=" + this.iv_files.size());
            }
            catch (IOException ioe) {
                throw new ResourceInitializationException(ioe);
            }
        }
    }

    private void collectFiles(File directory, List files) throws IOException {
        File[] dirFiles = directory.listFiles();
        int i = 0;
        while (i < dirFiles.length) {
            if (dirFiles[i].isDirectory()) {
                this.collectFiles(dirFiles[i], files);
            } else if (this.hasValidExtension(dirFiles[i])) {
                files.add(dirFiles[i]);
            }
            ++i;
        }
    }

    private boolean hasValidExtension(File file) {
        if (iv_extensions == null) {
            return true;
        }
        int i = 0;
        while (i < iv_extensions.length) {
            if (file.getName().endsWith("." + iv_extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.iv_currentIndex < this.iv_files.size();
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        InputStream fileInputStream = null;
        BufferedReader fileReader = null;
        try {
            try {
                JCas jcas = aCAS.getJCas();
                File file = (File)this.iv_files.get(this.iv_currentIndex);
                fileInputStream = new FileInputStream(file);
                fileReader = new BufferedReader(new InputStreamReader(fileInputStream));
                DocumentID documentIDAnnotation = new DocumentID(jcas);
                String docID = this.createDocID(file);
                documentIDAnnotation.setDocumentID(docID);
                documentIDAnnotation.addToIndexes();
                if (this.getCasInitializer() != null) {
                    this.getCasInitializer().initializeCas(fileReader, aCAS);
                } else {
                    byte[] contents = new byte[(int)file.length()];
                    fileInputStream.read(contents);
                    String text = this.iv_encoding != null ? new String(contents, this.iv_encoding) : new String(contents);
                    if (text == null) {
                        // empty if block
                    }
                    jcas.setDocumentText(text);
                }
            }
            catch (CASException e) {
                throw new CollectionException(e);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            ++this.iv_currentIndex;
        }
    }

    private String createDocID(File file) {
        String docID = file.getPath();
        docID = this.iv_rootPath.endsWith(File.separator) || this.iv_rootPath.equals("") ? docID.substring(this.iv_rootPath.length()) : docID.substring(this.iv_rootPath.length() + 1);
        return docID;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.iv_currentIndex, this.iv_files.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.iv_files.size();
    }
}

