/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.resource;

import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.resource.LuceneIndexReaderResource;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;

public class LuceneIndexReaderResourceImpl
implements LuceneIndexReaderResource,
SharedResourceObject {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private IndexReader iv_indexReader;

    @Override
    public void load(DataResource dr) throws ResourceInitializationException {
        ConfigurationParameterSettings cps = dr.getMetaData().getConfigurationParameterSettings();
        Boolean useMemoryIndex = (Boolean)cps.getParameterValue("UseMemoryIndex");
        String indexDirStr = (String)cps.getParameterValue("IndexDirectory");
        try {
            File indexDir = FileLocator.locateFile(indexDirStr);
            if (!indexDir.exists()) {
                this.iv_logger.info("indexDir=" + indexDirStr + "  does not exist!");
            } else {
                this.iv_logger.info("indexDir=" + indexDirStr + "  exists.");
            }
            if (useMemoryIndex.booleanValue()) {
                this.iv_logger.info("Loading Lucene Index into memory: " + indexDir);
                SimpleFSDirectory fsd = new SimpleFSDirectory(indexDir);
                RAMDirectory d = new RAMDirectory(fsd);
                this.iv_indexReader = IndexReader.open(d);
            } else {
                this.iv_logger.info("Loading Lucene Index: " + indexDir);
                SimpleFSDirectory fsd = new SimpleFSDirectory(indexDir);
                this.iv_indexReader = IndexReader.open(fsd);
            }
            this.iv_logger.info("Loaded Lucene Index, # docs=" + this.iv_indexReader.numDocs());
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public IndexReader getIndexReader() {
        return this.iv_indexReader;
    }
}

