/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.resource;

import edu.mayo.bmi.uima.core.resource.StringMapResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;

public class StringMapResourceImpl
implements StringMapResource,
SharedResourceObject {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private final String DELIMITER = "|";
    Map iv_map = new HashMap();

    @Override
    public void load(DataResource dr) throws ResourceInitializationException {
        this.iv_logger.info("Loading resource: " + dr.getUrl());
        try {
            InputStream inStream = dr.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
            int lineCount = 0;
            String line = br.readLine();
            while (line != null) {
                ++lineCount;
                int delimiterIndex = line.indexOf("|");
                if (delimiterIndex > 0) {
                    String key = line.substring(0, delimiterIndex).trim();
                    String value = line.substring(delimiterIndex + 1).trim();
                    this.iv_map.put(key, value);
                } else {
                    this.iv_logger.warn("Invalid resource line, character index of '|' was " + delimiterIndex + " at line " + lineCount);
                }
                line = br.readLine();
            }
            br.close();
            this.iv_logger.info("Loaded resource, # lines=" + lineCount);
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException(ioe);
        }
    }

    @Override
    public Map getMap() {
        return this.iv_map;
    }
}

