/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.BaseDictionaryImpl;
import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.dictionary.filter.StringPreLookupFilterImpl;
import edu.mayo.bmi.dictionary.jdbc.JdbcDictionaryImpl;
import edu.mayo.bmi.dictionary.lucene.LuceneDictionaryImpl;
import edu.mayo.bmi.dictionary.strtable.StringTable;
import edu.mayo.bmi.dictionary.strtable.StringTableDictionaryImpl;
import edu.mayo.bmi.dictionary.strtable.StringTableFactory;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.resource.JdbcConnectionResource;
import edu.mayo.bmi.uima.core.resource.LuceneIndexReaderResource;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import edu.mayo.bmi.uima.lookup.ae.LookupInitializer;
import edu.mayo.bmi.uima.lookup.ae.LookupSpec;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class LookupParseUtilities {
    public static Set parseDescriptor(File descFile, AnnotatorContext aContext) throws JDOMException, IOException, Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(descFile);
        Map dictMap = LookupParseUtilities.parseDictionaries(aContext, doc.getRootElement().getChild("dictionaries"));
        return LookupParseUtilities.parseLookupBindingXml(aContext, dictMap, doc.getRootElement().getChild("lookupBindings"));
    }

    private static Map parseDictionaries(AnnotatorContext aContext, Element dictetteersEl) throws AnnotatorContextException, Exception {
        HashMap<String, DictionaryEngine> m = new HashMap<String, DictionaryEngine>();
        for (Element dictEl : dictetteersEl.getChildren()) {
            String id = dictEl.getAttributeValue("id");
            DictionaryEngine dictEngine = LookupParseUtilities.parseDictionaryXml(aContext, dictEl);
            m.put(id, dictEngine);
        }
        return m;
    }

    private static DictionaryEngine parseDictionaryXml(AnnotatorContext annotCtx, Element rootDictEl) throws AnnotatorContextException, Exception {
        BaseDictionaryImpl dict;
        String extResrcKey = rootDictEl.getAttributeValue("externalResourceKey");
        Boolean keepCase = new Boolean(rootDictEl.getAttributeValue("caseSensitive"));
        Object extResrc = annotCtx.getResourceObject(extResrcKey);
        if (extResrc == null) {
            throw new Exception("Unable to find external resource with key:" + extResrcKey);
        }
        Element lookupFieldEl = rootDictEl.getChild("lookupField");
        String lookupFieldName = lookupFieldEl.getAttributeValue("fieldName");
        Element implEl = (Element)rootDictEl.getChild("implementation").getChildren().get(0);
        String implType = implEl.getName();
        if (implType.equals("luceneImpl")) {
            if (!(extResrc instanceof LuceneIndexReaderResource)) {
                throw new Exception("Expected external resource to be:" + LuceneIndexReaderResource.class);
            }
            IndexReader indexReader = ((LuceneIndexReaderResource)extResrc).getIndexReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            dict = new LuceneDictionaryImpl(indexSearcher, lookupFieldName);
        } else if (implType.equals("jdbcImpl")) {
            String tableName = implEl.getAttributeValue("tableName");
            if (!(extResrc instanceof JdbcConnectionResource)) {
                throw new Exception("Expected external resource to be:" + JdbcConnectionResource.class);
            }
            Connection conn = ((JdbcConnectionResource)extResrc).getConnection();
            dict = new JdbcDictionaryImpl(conn, tableName, lookupFieldName);
        } else if (implType.equals("csvImpl")) {
            String fieldDelimiter = implEl.getAttributeValue("delimiter");
            if (!(extResrc instanceof FileResource)) {
                throw new Exception("Expected external resource to be:" + FileResource.class);
            }
            String idxFieldNameStr = implEl.getAttributeValue("indexedFieldNames");
            StringTokenizer st = new StringTokenizer(idxFieldNameStr, ",");
            int arrIdx = 0;
            String[] idxFieldNameArr = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                idxFieldNameArr[arrIdx++] = st.nextToken().trim();
            }
            File csvFile = ((FileResource)extResrc).getFile();
            StringTable strTable = StringTableFactory.build((Reader)new FileReader(csvFile), fieldDelimiter, idxFieldNameArr, true);
            dict = new StringTableDictionaryImpl(strTable, lookupFieldName);
        } else {
            throw new Exception("Unsupported impl type:" + implType);
        }
        for (Element metaFieldEl : rootDictEl.getChild("metaFields").getChildren()) {
            String metaFieldName = metaFieldEl.getAttributeValue("fieldName");
            dict.retainMetaData(metaFieldName);
        }
        DictionaryEngine dictEngine = new DictionaryEngine(dict, keepCase);
        Element excludeList = rootDictEl.getChild("excludeList");
        if (excludeList != null && excludeList.getChildren() != null && excludeList.getChildren().size() > 0) {
            LookupParseUtilities.addExcludeList(dictEngine, excludeList.getChildren().iterator());
        }
        return dictEngine;
    }

    private static void addExcludeList(DictionaryEngine ge, Iterator itr) {
        HashSet<String> hs = new HashSet<String>();
        while (itr.hasNext()) {
            Element item = (Element)itr.next();
            String s = item.getAttributeValue("value");
            hs.add(s);
        }
        StringPreLookupFilterImpl plf = new StringPreLookupFilterImpl(hs);
        ge.addPreLookupFilter(plf);
    }

    private static Set parseLookupBindingXml(AnnotatorContext annotCtx, Map dictMap, Element lookupBindingsEl) throws Exception {
        HashSet<LookupSpec> lsSet = new HashSet<LookupSpec>();
        for (Element bindingEl : lookupBindingsEl.getChildren()) {
            Element dictEl = bindingEl.getChild("dictionaryRef");
            String dictID = dictEl.getAttributeValue("idRef");
            DictionaryEngine dictEngine = (DictionaryEngine)dictMap.get(dictID);
            if (dictEngine == null) {
                throw new Exception("Dictionary undefined: " + dictID);
            }
            Class[] constrArgs = new Class[]{AnnotatorContext.class, Properties.class};
            Element lookupInitEl = bindingEl.getChild("lookupInitializer");
            String liClassName = lookupInitEl.getAttributeValue("className");
            Element liPropertiesEl = lookupInitEl.getChild("properties");
            Properties liProps = LookupParseUtilities.parsePropertiesXml(liPropertiesEl);
            Class<?> liClass = Class.forName(liClassName);
            Constructor<?> liConstr = liClass.getConstructor(constrArgs);
            Object[] liArgs = new Object[]{annotCtx, liProps};
            LookupInitializer li = (LookupInitializer)liConstr.newInstance(liArgs);
            Element lookupConsumerEl = bindingEl.getChild("lookupConsumer");
            String lcClassName = lookupConsumerEl.getAttributeValue("className");
            Element lcPropertiesEl = lookupConsumerEl.getChild("properties");
            Properties lcProps = LookupParseUtilities.parsePropertiesXml(lcPropertiesEl);
            Class<?> lcClass = Class.forName(lcClassName);
            Constructor<?> lcConstr = lcClass.getConstructor(constrArgs);
            Object[] lcArgs = new Object[]{annotCtx, lcProps};
            LookupConsumer lc = (LookupConsumer)lcConstr.newInstance(lcArgs);
            LookupAlgorithm la = li.getLookupAlgorithm(dictEngine);
            LookupSpec ls = new LookupSpec(la, li, lc);
            lsSet.add(ls);
        }
        return lsSet;
    }

    private static Properties parsePropertiesXml(Element propsEl) {
        Properties props = new Properties();
        for (Element propEl : propsEl.getChildren()) {
            String key = propEl.getAttributeValue("key");
            String value = propEl.getAttributeValue("value");
            props.put(key, value);
        }
        return props;
    }
}

