/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.OntologyConcept;
import edu.mayo.bmi.uima.lookup.ae.BaseLookupConsumerImpl;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class NamedEntityLookupConsumerImpl
extends BaseLookupConsumerImpl
implements LookupConsumer {
    private final String CODE_MF_PRP_KEY = "codeMetaField";
    private final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private final String TYPE_ID_FIELD = "typeIdField";
    private Properties iv_props;
    private static int iv_maxSize;

    public NamedEntityLookupConsumerImpl(AnnotatorContext aCtx, Properties props, int maxListSize) {
        this.iv_props = props;
        iv_maxSize = maxListSize;
    }

    public NamedEntityLookupConsumerImpl(AnnotatorContext aCtx, Properties props) {
        this.iv_props = props;
    }

    @Override
    public void consumeHits(JCas jcas, Iterator lhItr) throws AnnotatorProcessException {
        String typeId = null;
        Iterator hitsByOffsetItr = this.organizeByOffset(lhItr);
        while (hitsByOffsetItr.hasNext()) {
            Collection hitsAtOffsetCol = (Collection)hitsByOffsetItr.next();
            FSArray ocArr = new FSArray(jcas, hitsAtOffsetCol.size());
            int ocArrIdx = 0;
            Iterator lhAtOffsetItr = hitsAtOffsetCol.iterator();
            int neBegin = -1;
            int neEnd = -1;
            while (lhAtOffsetItr.hasNext()) {
                LookupHit lh = (LookupHit)lhAtOffsetItr.next();
                neBegin = lh.getStartOffset();
                neEnd = lh.getEndOffset();
                MetaDataHit mdh = lh.getDictMetaDataHit();
                OntologyConcept oc = new OntologyConcept(jcas);
                oc.setCode(mdh.getMetaFieldValue(this.iv_props.getProperty("codeMetaField")));
                oc.setCodingScheme(this.iv_props.getProperty("codingScheme"));
                if (this.iv_props.getProperty("typeIdField") != null) {
                    typeId = mdh.getMetaFieldValue(this.iv_props.getProperty("typeIdField"));
                }
                ocArr.set(ocArrIdx, oc);
                ++ocArrIdx;
            }
            NamedEntity neAnnot = new NamedEntity(jcas);
            neAnnot.setBegin(neBegin);
            neAnnot.setEnd(neEnd);
            neAnnot.setDiscoveryTechnique(1);
            neAnnot.setOntologyConceptArr(ocArr);
            if (typeId != null) {
                int tid = -1;
                try {
                    tid = Integer.parseInt(typeId);
                }
                catch (NumberFormatException nfe) {
                    tid = -1;
                }
                neAnnot.setTypeID(tid);
            }
            neAnnot.addToIndexes();
        }
    }
}

