/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.UmlsConcept;
import edu.mayo.bmi.uima.lookup.ae.BaseLookupConsumerImpl;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public abstract class UmlsToSnomedConsumerImpl
extends BaseLookupConsumerImpl
implements LookupConsumer {
    private final String CUI_MF_PRP_KEY = "cuiMetaField";
    private final String TUI_MF_PRP_KEY = "tuiMetaField";
    private final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private final String ANT_SITE_TUIS_PRP_KEY = "anatomicalSiteTuis";
    private final String PROCEDURE_TUIS_PRP_KEY = "procedureTuis";
    private final String DISORDER_TUIS_PRP_KEY = "disorderTuis";
    private final String FINDING_TUIS_PRP_KEY = "findingTuis";
    private Set antSiteTuiSet = new HashSet();
    private Set procedureTuiSet = new HashSet();
    private Set disorderTuiSet = new HashSet();
    private Set findingTuiSet = new HashSet();
    private Set validTuiSet = new HashSet();
    protected Properties props;

    public UmlsToSnomedConsumerImpl(AnnotatorContext aCtx, Properties properties) throws Exception {
        this.props = properties;
        this.antSiteTuiSet = this.loadList(this.props.getProperty("anatomicalSiteTuis"));
        this.procedureTuiSet = this.loadList(this.props.getProperty("procedureTuis"));
        this.disorderTuiSet = this.loadList(this.props.getProperty("disorderTuis"));
        this.findingTuiSet = this.loadList(this.props.getProperty("findingTuis"));
        this.validTuiSet.addAll(this.antSiteTuiSet);
        this.validTuiSet.addAll(this.procedureTuiSet);
        this.validTuiSet.addAll(this.disorderTuiSet);
        this.validTuiSet.addAll(this.findingTuiSet);
    }

    protected abstract Set getSnomedCodes(String var1) throws SQLException, DictionaryException;

    @Override
    public void consumeHits(JCas jcas, Iterator lhItr) throws AnnotatorProcessException {
        try {
            Iterator hitsByOffsetItr = this.organizeByOffset(lhItr);
            while (hitsByOffsetItr.hasNext()) {
                Collection hitsAtOffsetCol = (Collection)hitsByOffsetItr.next();
                HashSet<String> cuiTuiSet = new HashSet<String>();
                HashMap conceptMap = new HashMap();
                Iterator lhAtOffsetItr = hitsAtOffsetCol.iterator();
                int neBegin = -1;
                int neEnd = -1;
                while (lhAtOffsetItr.hasNext()) {
                    String cuiTuiKey;
                    LookupHit lh = (LookupHit)lhAtOffsetItr.next();
                    neBegin = lh.getStartOffset();
                    neEnd = lh.getEndOffset();
                    MetaDataHit mdh = lh.getDictMetaDataHit();
                    String cui = mdh.getMetaFieldValue(this.props.getProperty("cuiMetaField"));
                    String tui = mdh.getMetaFieldValue(this.props.getProperty("tuiMetaField"));
                    if (!this.validTuiSet.contains(tui) || cuiTuiSet.contains(cuiTuiKey = this.getUniqueKey(cui, tui))) continue;
                    cuiTuiSet.add(cuiTuiKey);
                    Set snomedCodeSet = this.getSnomedCodes(cui);
                    if (snomedCodeSet.size() <= 0) continue;
                    Integer neType = new Integer(this.getNamedEntityType(tui));
                    Set conceptSet = conceptMap.containsKey(neType) ? (Set)conceptMap.get(neType) : new HashSet();
                    Collection conceptCol = this.createConceptCol(jcas, cui, tui, snomedCodeSet);
                    conceptSet.addAll(conceptCol);
                    conceptMap.put(neType, conceptSet);
                }
                for (Integer neType : conceptMap.keySet()) {
                    Set conceptSet = (Set)conceptMap.get(neType);
                    if (conceptSet.size() <= 0) continue;
                    FSArray conceptArr = new FSArray(jcas, conceptSet.size());
                    int arrIdx = 0;
                    for (UmlsConcept uc : conceptSet) {
                        conceptArr.set(arrIdx, uc);
                        ++arrIdx;
                    }
                    NamedEntity neAnnot = new NamedEntity(jcas);
                    neAnnot.setTypeID(neType);
                    neAnnot.setBegin(neBegin);
                    neAnnot.setEnd(neEnd);
                    neAnnot.setDiscoveryTechnique(1);
                    neAnnot.setOntologyConceptArr(conceptArr);
                    neAnnot.addToIndexes();
                }
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private int getNamedEntityType(String tui) throws Exception {
        if (this.disorderTuiSet.contains(tui)) {
            return 2;
        }
        if (this.findingTuiSet.contains(tui)) {
            return 3;
        }
        if (this.antSiteTuiSet.contains(tui)) {
            return 6;
        }
        if (this.procedureTuiSet.contains(tui)) {
            return 5;
        }
        throw new Exception("TUI is not part of valid named entity types: " + tui);
    }

    private Collection createConceptCol(JCas jcas, String cui, String tui, Collection snomedCodesCol) {
        ArrayList<UmlsConcept> conceptList = new ArrayList<UmlsConcept>();
        for (String snomedCode : snomedCodesCol) {
            UmlsConcept uc = new UmlsConcept(jcas);
            uc.setCode(snomedCode);
            uc.setCodingScheme(this.props.getProperty("codingScheme"));
            uc.setCui(cui);
            uc.setTui(tui);
            conceptList.add(uc);
        }
        return conceptList;
    }

    private String getUniqueKey(String cui, String tui) {
        StringBuffer sb = new StringBuffer();
        sb.append(cui);
        sb.append(':');
        sb.append(tui);
        return sb.toString();
    }

    private Set loadList(String delimitedString) {
        String[] stringArr = delimitedString.split(",");
        HashSet<String> stringSet = new HashSet<String>();
        int i = 0;
        while (i < stringArr.length) {
            String s = stringArr[i].trim();
            if (s.length() > 0) {
                stringSet.add(s);
            }
            ++i;
        }
        return stringSet;
    }
}

