/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lvg.resource;

import edu.mayo.bmi.uima.lvg.resource.LvgCmdApiResource;
import gov.nih.nlm.nls.lvg.Api.LvgCmdApi;
import gov.nih.nlm.nls.lvg.Api.LvgLexItemApi;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;

public class LvgCmdApiResourceImpl
implements LvgCmdApiResource,
SharedResourceObject {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private LvgCmdApi lvg;
    private LvgLexItemApi lvgLexItem;
    private static String CWD_PROPERTY = "user.dir";

    @Override
    public void load(DataResource dr) throws ResourceInitializationException {
        block9: {
            String configFileName = null;
            String cwd = null;
            try {
                try {
                    File configFile = new File(dr.getUri());
                    configFileName = configFile.getPath();
                    this.logger.info("Loading NLM Norm and Lvg with config file = " + configFileName);
                    this.logger.info("  config file absolute path = " + configFile.getAbsolutePath());
                    String lvgDir = this.getLvgDir(configFile);
                    cwd = this.getCurrentWorkingDirectory();
                    if (cwd != null) {
                        this.logger.info("cwd = " + cwd);
                        this.changeCurrentWorkingDirectory(lvgDir);
                    }
                    this.lvg = new LvgCmdApi("-f:l:b", configFileName);
                    this.lvgLexItem = new LvgLexItemApi("-f:i -SC", configFileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cwd != null) {
                        this.changeCurrentWorkingDirectory(cwd);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (cwd != null) {
                    this.changeCurrentWorkingDirectory(cwd);
                }
                throw throwable;
            }
            if (cwd != null) {
                this.changeCurrentWorkingDirectory(cwd);
            }
        }
    }

    private String getCurrentWorkingDirectory() {
        String cwd = null;
        try {
            cwd = System.getProperty(CWD_PROPERTY);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            return cwd;
        }
        return cwd;
    }

    private boolean changeCurrentWorkingDirectory(String s) {
        try {
            System.setProperty(CWD_PROPERTY, s);
            this.logger.info("cd " + s);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            return false;
        }
        return true;
    }

    private String getLvgDir(File configFile) {
        String dataConfigPath;
        String pathToLvgRoot = null;
        File configDir = configFile.getParentFile();
        String configDirAbsPath = configDir.getPath();
        if (!configDirAbsPath.endsWith(dataConfigPath = "data" + File.separator + "config")) {
            pathToLvgRoot = this.getCurrentWorkingDirectory();
        } else {
            int configDirAbsPathLen = configDirAbsPath.length();
            int pathLen = dataConfigPath.length();
            pathToLvgRoot = configDirAbsPath.substring(0, configDirAbsPathLen - pathLen);
        }
        return pathToLvgRoot;
    }

    @Override
    public LvgCmdApi getLvg() {
        return this.lvg;
    }

    @Override
    public LvgLexItemApi getLvgLex() {
        return this.lvgLexItem;
    }
}

