/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.ae;

import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.sideeffect.type.PSESentence;
import edu.mayo.bmi.uima.sideeffect.util.SEUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class PSESentenceAnnotator
extends JTextAnnotator_ImplBase {
    public static final String PARAM_IGNORE_SECTIONS = "SectionsToIgnore";
    private Set setionsToIgnore;

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(aContext);
        try {
            String[] sections = (String[])this.getContext().getConfigParameterValue(PARAM_IGNORE_SECTIONS);
            this.setionsToIgnore = new HashSet();
            int i = 0;
            while (i < sections.length) {
                this.setionsToIgnore.add(sections[i]);
                ++i;
            }
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification arg1) throws AnnotatorProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator senIter = indexes.getAnnotationIndex(Sentence.type).iterator();
        block0: while (senIter.hasNext()) {
            int num;
            int[] previousSenSpan;
            Sentence sen = (Sentence)senIter.next();
            boolean foundDrug = false;
            boolean foundPSE = false;
            if (this.setionsToIgnore.contains(sen.getSegmentId())) continue;
            FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, sen.getBegin(), sen.getEnd() + 1);
            while (neIter.hasNext()) {
                NamedEntity n = (NamedEntity)neIter.next();
                if (n.getTypeID() == 2 || n.getTypeID() == 3) {
                    foundPSE = true;
                }
                if (n.getTypeID() != 1) continue;
                foundDrug = true;
            }
            if (!foundPSE) continue;
            if (foundPSE && foundDrug) {
                PSESentence ps = new PSESentence(jcas);
                ps.setBegin(sen.getBegin());
                ps.setEnd(sen.getEnd());
                ps.addToIndexes();
                continue;
            }
            if (!foundPSE || foundDrug || !SEUtil.isSpanInSameLine(jcas, (previousSenSpan = SEUtil.getSentenceSpanOfGivenSentenceNum(jcas, num = (num = sen.getSentenceNumber()) > 0 ? num - 1 : num))[0], sen.getEnd())) continue;
            neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, previousSenSpan[0], previousSenSpan[1] + 1);
            while (neIter.hasNext()) {
                NamedEntity n = (NamedEntity)neIter.next();
                if (n.getTypeID() != 1) continue;
                PSESentence ps = new PSESentence(jcas);
                ps.setBegin(previousSenSpan[0]);
                ps.setEnd(sen.getEnd());
                ps.addToIndexes();
                continue block0;
            }
        }
    }
}

