/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.util;

import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.FSUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SEUtil {
    public static int[] getSentenceSpanContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[]{-1, -1};
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            span[0] = sa.getBegin();
            span[1] = sa.getEnd();
            break;
        }
        return span;
    }

    public static String getSentenceTextContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        String str = "";
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            str = sa.getCoveredText().trim();
            break;
        }
        return str;
    }

    public static int[] getSentenceSpanOfGivenSentenceNum(JCas jcas, int senNum) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[]{-1, -1};
        int num = 0;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (senNum == num) {
                span[0] = sa.getBegin();
                span[1] = sa.getEnd();
                break;
            }
            ++num;
        }
        return span;
    }

    public static String getSegmentIDOfSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        String segID = null;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            segID = sa.getSegmentId();
            break;
        }
        return segID;
    }

    public static String getSegmentID(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Segment.type).iterator();
        String segID = null;
        while (iter.hasNext()) {
            Segment seg = (Segment)iter.next();
            if (seg.getBegin() > begin || seg.getEnd() < end) continue;
            segID = seg.getId();
            break;
        }
        return segID;
    }

    public static int contains(int b1, int e1, int b2, int e2) {
        if (b1 <= b2 && e1 >= e2) {
            return 1;
        }
        if (b2 <= b1 && e2 >= e1) {
            return 2;
        }
        return 0;
    }

    public static boolean intersects(int b1, int e1, int b2, int e2) {
        if (SEUtil.contains(b1, e1, b2, e2) != 0) {
            return true;
        }
        return b1 <= b2 && b2 < e1 || b2 <= b1 && b1 < e2;
    }

    public static List getDrugsInSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(NamedEntity.type).iterator();
        ArrayList<NamedEntity> l = new ArrayList<NamedEntity>();
        while (neItr.hasNext()) {
            NamedEntity nea = (NamedEntity)neItr.next();
            if (nea.getTypeID() != 1 || nea.getBegin() < begin || nea.getEnd() > end) continue;
            l.add(nea);
        }
        return l;
    }

    public static int getSentenceNumContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int senNum = -1;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            senNum = sa.getSentenceNumber();
            break;
        }
        return senNum;
    }

    public static int getNumOfWordTokensInSpan(JCas jcas, int begin, int end) {
        HashSet<String> ignoreWords = new HashSet<String>();
        ignoreWords.add("and");
        ignoreWords.add("or");
        FSIterator wtIter = FSUtil.getAnnotationsInSpanIterator(jcas, WordToken.type, begin, end);
        int cnt = 0;
        while (wtIter.hasNext()) {
            WordToken wt = (WordToken)wtIter.next();
            if (ignoreWords.contains(wt.getCoveredText().toLowerCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int getNumOfWordTokensInSpanExceptGivenNE(JCas jcas, int begin, int end, int neType) {
        HashSet<String> ignoreWords = new HashSet<String>();
        ignoreWords.add("and");
        ignoreWords.add("or");
        ArrayList<NamedEntity> neLst = new ArrayList<NamedEntity>();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, begin, end + 1);
        while (neIter.hasNext()) {
            NamedEntity ne = (NamedEntity)neIter.next();
            if (ne.getTypeID() != neType) continue;
            neLst.add(ne);
        }
        FSIterator wtIter = FSUtil.getAnnotationsInSpanIterator(jcas, WordToken.type, begin, end);
        int cnt = 0;
        while (wtIter.hasNext()) {
            WordToken wt = (WordToken)wtIter.next();
            if (ignoreWords.contains(wt.getCoveredText().toLowerCase())) continue;
            boolean isNE = false;
            for (NamedEntity n : neLst) {
                if (n.getBegin() > wt.getBegin() || n.getEnd() < wt.getEnd()) continue;
                isNE = true;
                break;
            }
            if (isNE) continue;
            ++cnt;
        }
        return cnt;
    }

    public static boolean isUpperCaseString(String str) {
        int i = str.length() - 1;
        while (i > 0) {
            if (Character.isLowerCase(str.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isInUpperCaseStringLine(JCas jcas, NamedEntity nea) {
        boolean flag = false;
        int[] senSpan = SEUtil.getSentenceSpanContainingGivenSpan(jcas, nea.getBegin(), nea.getEnd());
        String senText = SEUtil.getSentenceTextContainingGivenSpan(jcas, nea.getBegin(), nea.getEnd());
        if (senText.indexOf(" - ") != -1) {
            return false;
        }
        FSIterator ntIter = FSUtil.getAnnotationsInSpanIterator(jcas, NewlineToken.type, senSpan[0], senSpan[1] + 2);
        while (ntIter.hasNext()) {
            NewlineToken nt = (NewlineToken)ntIter.next();
            if (senSpan[1] != nt.getBegin() || !SEUtil.isUpperCaseString(senText)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isSpanInSameLine(JCas jcas, int begin, int end) {
        FSIterator ntIter = FSUtil.getAnnotationsInSpanIterator(jcas, NewlineToken.type, begin, end - 1);
        return !ntIter.hasNext();
    }

    public static boolean isDrugBetween(JCas jcas, int begin, int end) {
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, begin, end + 1);
        while (neIter.hasNext()) {
            NamedEntity ne = (NamedEntity)neIter.next();
            if (ne.getTypeID() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isPSEBetween(JCas jcas, int begin, int end) {
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, begin, end + 1);
        while (neIter.hasNext()) {
            NamedEntity ne = (NamedEntity)neIter.next();
            if (ne.getTypeID() != 2 && ne.getTypeID() != 3) continue;
            return true;
        }
        return false;
    }

    public static JCas getJCasViewWithDefault(CAS cas, String name) throws CASException {
        JCas returnCas = null;
        Iterator viewItr = cas.getJCas().getViewIterator();
        while (viewItr.hasNext()) {
            JCas newJcas = (JCas)viewItr.next();
            if (!newJcas.getViewName().equals(name)) continue;
            returnCas = newJcas;
        }
        if (returnCas == null) {
            returnCas = cas.getJCas();
        }
        return returnCas;
    }
}

