/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.termspotter.ae;

import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.pad.type.PADHit;
import edu.mayo.bmi.uima.pad.type.PADLocation;
import edu.mayo.bmi.uima.pad.type.PADTerm;
import edu.mayo.bmi.uima.pad.util.JCasUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class PADHitAnnotator
extends JTextAnnotator_ImplBase {
    public static Logger iv_logger = Logger.getLogger(PADHitAnnotator.class);
    public static String ANNOTATION_PART_ONE_OF_PAIR = "ANNOTATION_PART_ONE_OF_PAIR";
    public static String ANNOTATION_PART_TWO_OF_PAIR = "ANNOTATION_PART_TWO_OF_PAIR";
    public static String DISTANCE = "DISTANCE";
    public static String DISTANCE_ANN_TYPE = "DISTANCE_ANN_TYPE";
    public static String BOUNDARY_ANN_TYPE = "BOUNDARY_ANN_TYPE";
    public static String BACKUP_BOUNDARY_ANN_TYPE = "BACKUP_BOUNDARY_ANN_TYPE";
    public static String ANNOTATION_PART_ONE_FILTEROUT_NEGATED = "ANNOTATION_PART_ONE_FILTEROUT_NEGATED";
    public static String ANNOTATION_PART_TWO_FILTEROUT_NEGATED = "ANNOTATION_PART_TWO_FILTEROUT_NEGATED";
    public static String ANN_PART_ONE_TYPES_TO_IGNORE = "ANN_PART_ONE_TYPES_TO_IGNORE";
    public static String ANN_PART_TWO_TYPES_TO_IGNORE = "ANN_PART_TWO_TYPES_TO_IGNORE";
    public static int NO_WINDOW_SIZE_SPECIFIED = -1;
    public static int NO_ANNOTATION_TYPE_SPECIFIED = -1;
    private List<Object> term;
    private List<Object> location;
    private List<Object> termAndLocation;
    private List<String> stopWords;
    private List<Object> boundaryAnns;
    private List<Integer> ignoreP1Types;
    private List<Integer> ignoreP2Types;
    private final String STOP_WORDS_FILE = "StopWordsFile";
    private boolean partOneFilterOutNegated = true;
    private boolean partTwoFilterOutNegated = true;
    private int iWindowSize = NO_WINDOW_SIZE_SPECIFIED;
    private int iAnnotationType = NO_ANNOTATION_TYPE_SPECIFIED;
    private int iBoundaryAnnType = NO_ANNOTATION_TYPE_SPECIFIED;
    private int iBackupBoundaryAnnType = NO_ANNOTATION_TYPE_SPECIFIED;
    private int iAnnTypePartOneOfPair;
    private int iAnnTypePartTwoOfPair;
    private String annotationPartOneOfPair = "";
    private String annotationPartTwoOfPair = "";

    @Override
    public void initialize(AnnotatorContext aCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        try {
            super.initialize(aCtx);
            this.termAndLocation = new ArrayList<Object>();
            this.term = new ArrayList<Object>();
            this.location = new ArrayList<Object>();
            this.boundaryAnns = new ArrayList<Object>();
            this.ignoreP1Types = new ArrayList<Integer>();
            this.ignoreP2Types = new ArrayList<Integer>();
            FileResource resrcStopWords = (FileResource)aCtx.getResourceObject("StopWordsFile");
            File stopWordsFile = resrcStopWords.getFile();
            this.annotationPartOneOfPair = (String)aCtx.getConfigParameterValue(ANNOTATION_PART_ONE_OF_PAIR);
            this.annotationPartTwoOfPair = (String)aCtx.getConfigParameterValue(ANNOTATION_PART_TWO_OF_PAIR);
            Integer[] ignorep1 = (Integer[])aCtx.getConfigParameterValue(ANN_PART_ONE_TYPES_TO_IGNORE);
            Integer[] ignorep2 = (Integer[])aCtx.getConfigParameterValue(ANN_PART_TWO_TYPES_TO_IGNORE);
            int i = 0;
            while (ignorep1 != null && i < ignorep1.length) {
                this.ignoreP1Types.add(ignorep1[i]);
                ++i;
            }
            i = 0;
            while (ignorep2 != null && i < ignorep2.length) {
                this.ignoreP2Types.add(ignorep2[i]);
                ++i;
            }
            Boolean partFilterOutNegatedStr = (Boolean)aCtx.getConfigParameterValue(ANNOTATION_PART_ONE_FILTEROUT_NEGATED);
            if (!partFilterOutNegatedStr.booleanValue()) {
                this.partOneFilterOutNegated = false;
            }
            if (!(partFilterOutNegatedStr = (Boolean)aCtx.getConfigParameterValue(ANNOTATION_PART_TWO_FILTEROUT_NEGATED)).booleanValue()) {
                this.partTwoFilterOutNegated = false;
            }
            String windowSize = (String)aCtx.getConfigParameterValue(DISTANCE);
            String annotationTypeName = (String)aCtx.getConfigParameterValue(DISTANCE_ANN_TYPE);
            String boundaryAnnTypeName = (String)aCtx.getConfigParameterValue(BOUNDARY_ANN_TYPE);
            String backupBoundaryAnnTypeName = (String)aCtx.getConfigParameterValue(BACKUP_BOUNDARY_ANN_TYPE);
            if (windowSize != null) {
                this.iWindowSize = Integer.parseInt(windowSize);
            }
            if (annotationTypeName != null) {
                this.iAnnotationType = JCasUtil.getType(annotationTypeName);
            }
            if (boundaryAnnTypeName != null) {
                this.iBoundaryAnnType = JCasUtil.getType(boundaryAnnTypeName);
            }
            if (backupBoundaryAnnTypeName != null) {
                this.iBackupBoundaryAnnType = JCasUtil.getType(backupBoundaryAnnTypeName);
            }
            if (this.annotationPartOneOfPair != null) {
                this.iAnnTypePartOneOfPair = JCasUtil.getType(this.annotationPartOneOfPair);
            }
            if (this.annotationPartTwoOfPair != null) {
                this.iAnnTypePartTwoOfPair = JCasUtil.getType(this.annotationPartTwoOfPair);
            }
            if (iv_logger.getLevel() == Level.DEBUG) {
                iv_logger.debug("Read parameters : WINDOW_SIZE[" + windowSize + "] ANNOTATION_TYPE[" + annotationTypeName + "]");
            }
            this.loadStopWords(stopWordsFile);
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorInitializationException(ace);
        }
        catch (IOException ioe) {
            throw new AnnotatorInitializationException(ioe);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification arg1) throws AnnotatorProcessException {
        try {
            this.init();
            this.gatherBoundaries(jcas);
            this.gatherPairPartOne(jcas, this.partOneFilterOutNegated);
            this.gatherPairPartTwo(jcas, this.partTwoFilterOutNegated);
            this.sortHits();
            this.createUAHit(jcas);
        }
        catch (CASException ce) {
            throw new AnnotatorProcessException(ce);
        }
        catch (IllegalAccessException iae) {
            throw new AnnotatorProcessException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new AnnotatorProcessException(nsfe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AnnotatorProcessException(cnfe);
        }
    }

    private void createUAHit(JCas cas) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Annotation currAnn = null;
        Annotation prevAnn = null;
        int i = 0;
        while (i < this.termAndLocation.size()) {
            Annotation ann = (Annotation)this.termAndLocation.get(i);
            if (iv_logger.getLevel() == Level.DEBUG) {
                iv_logger.debug("Processing annotation [" + ann.getCoveredText() + "] [" + ann.getClass().getName() + "]");
            }
            if (ann != null && !this.checkStandAlone(cas, ann)) {
                if (currAnn == null) {
                    currAnn = ann;
                } else {
                    currAnn = ann;
                    prevAnn = currAnn;
                    if (this.isInBoundaryWindow(currAnn, prevAnn)) {
                        if (!this.areSameUAType(currAnn, prevAnn)) {
                            if (iv_logger.getLevel() == Level.DEBUG) {
                                iv_logger.debug("NOT Same type - Processing prevAnn[" + prevAnn.getCoveredText() + "] currAnn[" + currAnn.getCoveredText() + "]");
                            }
                            this.processTermAndLocation(cas, prevAnn, currAnn);
                        } else if (this.areSameUAType(currAnn, prevAnn)) {
                            if (iv_logger.getLevel() == Level.DEBUG) {
                                iv_logger.debug("NOT Same type - Processing prevAnn[" + prevAnn.getCoveredText() + "] currAnn[" + currAnn.getCoveredText() + "]");
                            }
                            this.processTermAndLocation(cas, prevAnn, currAnn);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private boolean checkStandAlone(JCas cas, Annotation ann) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        if (JCasUtil.isInstanceOf(this.annotationPartOneOfPair, ann) && ((PADTerm)ann).getIsStandAlone() == 1) {
            PADHit uah = new PADHit(cas);
            uah.setUaTerm((PADTerm)ann);
            uah.addToIndexes();
            return true;
        }
        if (JCasUtil.isInstanceOf(this.annotationPartTwoOfPair, ann) && ((PADLocation)ann).getIsStandAlone() == 1) {
            PADHit uah = new PADHit(cas);
            uah.setUaLocation((PADLocation)ann);
            uah.addToIndexes();
            return true;
        }
        return false;
    }

    private boolean isInBoundaryWindow(Annotation currAnn, Annotation prevAnn) {
        int i = 0;
        while (i < this.boundaryAnns.size()) {
            Annotation window = (Annotation)this.boundaryAnns.get(i);
            if (window.getBegin() <= currAnn.getBegin() && window.getBegin() <= prevAnn.getBegin() && window.getEnd() > currAnn.getEnd() && window.getEnd() > prevAnn.getEnd()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean areSameUAType(Annotation currAnn, Annotation ann) {
        return currAnn.getClass().getName().equalsIgnoreCase(ann.getClass().getName());
    }

    private void init() {
        this.term.clear();
        this.location.clear();
        this.termAndLocation.clear();
        this.boundaryAnns.clear();
    }

    private void processTermAndLocation(JCas jcas, Annotation prevAnn, Annotation currAnn) {
        if (iv_logger.getLevel() == Level.DEBUG) {
            iv_logger.debug("Processing term and loc[" + prevAnn.getCoveredText() + "] currAnn[" + currAnn.getCoveredText() + "]");
        }
        if (this.isAdjacentWithWindowSize(jcas, prevAnn, currAnn, this.iAnnotationType, this.iWindowSize)) {
            boolean isHit = false;
            PADLocation ual = null;
            PADTerm uat = null;
            if (prevAnn != null && prevAnn instanceof PADLocation && currAnn != null && currAnn instanceof PADTerm) {
                ual = (PADLocation)prevAnn;
                uat = (PADTerm)currAnn;
                isHit = true;
            } else if (prevAnn != null && prevAnn instanceof PADTerm && currAnn != null && currAnn instanceof PADLocation) {
                uat = (PADTerm)prevAnn;
                ual = (PADLocation)currAnn;
                isHit = true;
            } else if (prevAnn != null) {
                if (prevAnn instanceof PADTerm && ((PADTerm)prevAnn).getIsStandAlone() == 1) {
                    uat = (PADTerm)prevAnn;
                    ual = null;
                    isHit = true;
                } else if (prevAnn instanceof PADLocation && ((PADLocation)prevAnn).getIsStandAlone() == 1) {
                    ual = (PADLocation)prevAnn;
                    uat = null;
                    isHit = true;
                }
            }
            if (isHit) {
                PADHit uah = new PADHit(jcas);
                uah.setUaLocation(ual);
                uah.setUaTerm(uat);
                uah.addToIndexes();
            }
        }
    }

    private boolean isAdjacentWithStopWords(JCas jcas, Annotation prevAnn, Annotation currAnn) {
        WordToken prevWta = this.getLastToken(prevAnn);
        WordToken currWta = this.getFirstToken(currAnn);
        if (prevWta == null || currWta == null) {
            return false;
        }
        if (prevWta.getTokenNumber() == currWta.getTokenNumber() - 1) {
            return true;
        }
        List<WordToken> containedWTAs = this.getContainedWordTokens(jcas, prevWta, currWta);
        int i = 0;
        while (i < containedWTAs.size()) {
            WordToken tempWta = containedWTAs.get(i);
            if (!this.stopWords.contains(tempWta.getCoveredText())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isAdjacentWithWindowSize(JCas jcas, Annotation prevAnn, Annotation currAnn, int annType, int windowSize) {
        if (windowSize == NO_WINDOW_SIZE_SPECIFIED && annType == NO_ANNOTATION_TYPE_SPECIFIED) {
            return this.isAdjacentWithStopWords(jcas, prevAnn, currAnn);
        }
        int numAnns = this.countAnnotationsOfTypeInSpan(jcas, prevAnn, currAnn, annType);
        return numAnns <= windowSize;
    }

    private int countAnnotationsOfTypeInSpan(JCas jcas, Annotation prevAnn, Annotation currAnn, int annType) {
        int count = 1;
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(annType).iterator();
        while (annotItr.hasNext()) {
            Annotation tempAnn = (Annotation)annotItr.next();
            if (tempAnn.getBegin() < prevAnn.getEnd() || tempAnn.getEnd() > currAnn.getBegin()) continue;
            ++count;
        }
        return count > 0 ? count : -1;
    }

    private List<WordToken> getContainedWordTokens(JCas jcas, WordToken prevWta, WordToken currWta) {
        ArrayList<WordToken> list = new ArrayList<WordToken>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(WordToken.type).iterator();
        while (annotItr.hasNext()) {
            WordToken wta = (WordToken)annotItr.next();
            if (wta.getBegin() < prevWta.getEnd() || wta.getEnd() > currWta.getBegin()) continue;
            list.add(wta);
        }
        return list;
    }

    private List<FeatureStructure> getTokens(Annotation ann) {
        int i;
        FSArray fsa;
        ArrayList<FeatureStructure> l = new ArrayList<FeatureStructure>();
        if (ann instanceof PADLocation) {
            fsa = ((PADLocation)ann).getRelatedTokens();
            i = 0;
            while (fsa != null && i < fsa.size()) {
                if (fsa.get(i) != null) {
                    l.add(fsa.get(i));
                }
                ++i;
            }
        }
        if (ann instanceof PADTerm) {
            fsa = ((PADTerm)ann).getRelatedTokens();
            i = 0;
            while (fsa != null && i < fsa.size()) {
                if (fsa.get(i) != null) {
                    l.add(fsa.get(i));
                }
                ++i;
            }
        }
        return l;
    }

    private WordToken getFirstToken(Annotation ann) {
        FSArray fsa;
        WordToken wta = null;
        if (ann instanceof PADLocation && (fsa = ((PADLocation)ann).getRelatedTokens()) != null && fsa.size() > 0) {
            wta = (WordToken)fsa.get(0);
        }
        if (ann instanceof PADTerm && (fsa = ((PADTerm)ann).getRelatedTokens()) != null && fsa.size() > 0) {
            wta = (WordToken)fsa.get(0);
        }
        if (wta == null) {
            System.err.println("Error:");
            System.err.println("[" + (ann != null ? ann.getCoveredText() : "") + "] does not have Word Token - " + this.getClass().getName());
        }
        return wta;
    }

    private WordToken getLastToken(Annotation ann) {
        int i;
        FSArray fsa;
        WordToken wta = null;
        if (ann instanceof PADLocation) {
            fsa = ((PADLocation)ann).getRelatedTokens();
            i = 0;
            while (fsa != null && i < fsa.size() && fsa.get(i) != null) {
                wta = (WordToken)fsa.get(i);
                ++i;
            }
        }
        if (ann instanceof PADTerm) {
            fsa = ((PADTerm)ann).getRelatedTokens();
            i = 0;
            while (fsa != null && i < fsa.size() && fsa.get(i) != null) {
                wta = (WordToken)fsa.get(i);
                ++i;
            }
        }
        if (wta == null) {
            System.err.println("Error: [" + ann.getCoveredText() + "] does not have Word Token - " + this.getClass().getName());
        }
        return wta;
    }

    private void storePartOneHit(Object termOrLoc) {
        this.term.add(termOrLoc);
        this.termAndLocation.add(termOrLoc);
    }

    private void storePartTwoHit(Object termOrLoc) {
        this.location.add(termOrLoc);
        this.termAndLocation.add(termOrLoc);
    }

    private void gatherBoundaries(JCas jcas) throws CASException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(this.iBoundaryAnnType).iterator();
        if (!annotItr.hasNext()) {
            annotItr = indexes.getAnnotationIndex(this.iBackupBoundaryAnnType).iterator();
        }
        while (annotItr.hasNext()) {
            this.boundaryAnns.add(annotItr.next());
        }
    }

    private void gatherPairPartOne(JCas jcas, boolean filterOutNegated) throws CASException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(this.iAnnTypePartOneOfPair).iterator();
        while (annotItr.hasNext()) {
            PADTerm uaTerm = (PADTerm)annotItr.next();
            if (uaTerm.getCertainty() < 0 && filterOutNegated || this.isInIgnoreTypesPartOne(uaTerm)) {
                iv_logger.info(String.valueOf(uaTerm.getHitDictionaryValue()) + " ignoring because negated");
                continue;
            }
            this.storePartOneHit(uaTerm);
        }
    }

    private void gatherPairPartTwo(JCas jcas, boolean filterOutNegated) throws CASException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(this.iAnnTypePartTwoOfPair).iterator();
        while (annotItr.hasNext()) {
            PADLocation uaLoc = (PADLocation)annotItr.next();
            if (uaLoc.getCertainty() < 0 && filterOutNegated || this.isInIgnoreTypesPartTwo(uaLoc)) {
                iv_logger.info(String.valueOf(uaLoc.getHitDictionaryValue()) + " ignoring because negated");
                continue;
            }
            this.storePartTwoHit(uaLoc);
        }
    }

    private boolean isInIgnoreTypesPartOne(PADTerm uaTerm) {
        int i = 0;
        while (i < this.ignoreP1Types.size()) {
            if (this.ignoreP1Types.get(i).intValue() == uaTerm.getTypeID()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInIgnoreTypesPartTwo(PADLocation uaLoc) {
        int i = 0;
        while (i < this.ignoreP2Types.size()) {
            if (this.ignoreP2Types.get(i).intValue() == uaLoc.getTypeID()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void loadStopWords(File stopWordsFile) throws FileNotFoundException, IOException {
        String line;
        if (this.stopWords == null) {
            this.stopWords = new ArrayList<String>();
        }
        FileReader fr = new FileReader(stopWordsFile);
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            String stopWord = line.trim();
            this.stopWords.add(stopWord);
        }
    }

    private void sortHits() {
        HitComparator hc = new HitComparator();
        Collections.sort(this.term, hc);
        Collections.sort(this.location, hc);
        Collections.sort(this.termAndLocation, hc);
        Collections.sort(this.boundaryAnns, hc);
    }

    class HitComparator
    implements Comparator {
        HitComparator() {
        }

        public int compare(Object o1, Object o2) {
            Annotation a1 = (Annotation)o1;
            Annotation a2 = (Annotation)o2;
            return a1.getEnd() - a2.getBegin();
        }
    }
}

