/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.termspotter.cc;

import edu.mayo.bmi.uima.core.cc.NonTerminalConsumer;
import edu.mayo.bmi.uima.core.type.DocumentID;
import edu.mayo.bmi.uima.core.type.Properties;
import edu.mayo.bmi.uima.core.type.Property;
import edu.mayo.bmi.uima.pad.type.PADHit;
import edu.mayo.bmi.uima.pad.type.PADLocation;
import edu.mayo.bmi.uima.pad.type.PADTerm;
import edu.mayo.bmi.uima.pad.type.SubSection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class PADOffSetsRecord
extends CasConsumer_ImplBase
implements NonTerminalConsumer {
    public static final String ultrasound = "US_EXAM";
    public static final String lower_extremity = "LOWER_EXT";
    public static final String ultrasound_lower_extremity = "US_LOWER_EXT";
    public static final String ultrasound_lower_extremity_one_side_only = "US_LOWER_SOLO";
    public static final String CAT_Scan = "CT_EXAM";
    public static final String CAT_Scan_one_side_only = "CT_EXAM_SOLO";
    public static Logger iv_logger = Logger.getLogger(PADOffSetsRecord.class);
    public static final String PARAM_ALTERNATE_ALGOR = "usingAlternateAlgorithm";
    public static final String PARAM_OUTPUTFILE = "outputFileName";
    public static final String COLLECTION_SEPARATOR = "|";
    public static final String FIELD_SEPARATOR = ":";
    public static final String OS_NAME = "os.name";
    public static final String OS_WINDOWS = "Windows";
    public static final String COUNT_PLACE_HOLDER = "@@COUNT@@";
    public Boolean alternateAlgorithm = false;
    private File iv_outputFile;
    private StringBuffer casConsumerOffSetData;
    private StringBuffer casConsumerOutData;
    private FileOutputStream fos;
    private File holdResults;
    private String drugHeaders = "clinic,case_type";
    private int anatomicalSiteExclusion = 9;
    private int disorderPatent = 7;
    private int disorderStenosis = 8;
    private static int noPadMentionThreshold = 2;

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            super.initialize();
            this.casConsumerOffSetData = new StringBuffer();
            this.casConsumerOutData = new StringBuffer();
            String outputFileName = (String)this.getConfigParameterValue(PARAM_OUTPUTFILE);
            this.alternateAlgorithm = (Boolean)this.getConfigParameterValue(PARAM_ALTERNATE_ALGOR);
            this.iv_outputFile = new File(outputFileName);
            this.fos = new FileOutputStream(this.iv_outputFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceInitializationException(fnfe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            this.casConsumerOffSetData.replace(0, this.casConsumerOffSetData.length(), "");
            this.casConsumerOutData.replace(0, this.casConsumerOutData.length(), "");
            this.processHits(cas);
        }
        catch (CASException ce) {
            throw new ResourceProcessException(ce);
        }
    }

    @Override
    public String getOutputXml() {
        return this.casConsumerOffSetData.toString();
    }

    private boolean isWindows() {
        return System.getProperty(OS_NAME).startsWith(OS_WINDOWS);
    }

    private void addPatientMetaData(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(Properties.type).iterator();
        if (annotItr.hasNext()) {
            Properties props = (Properties)annotItr.next();
            FSArray fsArr = props.getPropArr();
            int i = 0;
            while (i < fsArr.size()) {
                Property prop = (Property)fsArr.get(i);
                if (prop != null) {
                    String key = prop.getKey();
                    if (key != null && key.equalsIgnoreCase("CLINICAL_NUMBER")) {
                        this.casConsumerOffSetData.append(FIELD_SEPARATOR + prop.getValue());
                    }
                    if (key == null || key.equalsIgnoreCase("NOTE_DATE")) {
                        // empty if block
                    }
                    this.casConsumerOffSetData.append(FIELD_SEPARATOR + prop.getValue());
                }
                ++i;
            }
        }
    }

    private void processHits(CAS cas) throws CASException, ResourceProcessException {
        int count = 0;
        try {
            PADHit uaHit;
            FSIterator annotHitItr;
            JCas jcas = cas.getJCas();
            boolean haveUSSoloExamType = false;
            boolean haveUSExamType = false;
            boolean haveLowerExtExamType = false;
            boolean haveCombinedExamType = false;
            boolean haveLowerSoloExamType = false;
            boolean haveVRADExamType = false;
            boolean locTermsOnly = false;
            boolean noStenosis = true;
            boolean noVein = true;
            boolean noStent = true;
            boolean CTTypeExam = false;
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            boolean negatedCase = true;
            int locOnlyCount = 0;
            int termOnlyCount = 0;
            int probableCount = 0;
            int veinCount = 0;
            FSIterator annotItr = indexes.getAnnotationIndex(DocumentID.type).iterator();
            if (annotItr.hasNext()) {
                DocumentID did = (DocumentID)annotItr.next();
                this.casConsumerOffSetData.append(did.getDocumentID());
            }
            this.addPatientMetaData(jcas);
            annotItr = indexes.getAnnotationIndex(PADHit.type).iterator();
            this.casConsumerOffSetData.append("|@@COUNT@@|");
            FSIterator checkExamItr = indexes.getAnnotationIndex(SubSection.type).iterator();
            while (checkExamItr.hasNext()) {
                SubSection ssId = (SubSection)checkExamItr.next();
                if (ssId.getParentSectionId().compareTo(ultrasound_lower_extremity_one_side_only) == 0 || ssId.getParentSectionId().compareTo("CAT_Scan_one_side_only") == 0) {
                    haveLowerSoloExamType = true;
                }
                if (ssId.getParentSectionId().indexOf("V_IRAD") >= 0 || ssId.getParentSectionId().compareTo("V&IRAD") == 0) {
                    haveVRADExamType = true;
                }
                if (ssId.getParentSectionId().compareTo(ultrasound) == 0) {
                    haveUSExamType = true;
                }
                if (ssId.getParentSectionId().compareTo(lower_extremity) == 0) {
                    haveLowerExtExamType = true;
                }
                if (ssId.getParentSectionId().compareTo(ultrasound_lower_extremity) == 0) {
                    haveCombinedExamType = true;
                }
                if (ssId.getParentSectionId().compareTo(ultrasound_lower_extremity_one_side_only) == 0) {
                    haveUSSoloExamType = true;
                }
                if (ssId.getParentSectionId().indexOf(CAT_Scan) <= 0 && ssId.getParentSectionId().compareTo(CAT_Scan) != 0) continue;
                CTTypeExam = true;
            }
            boolean negCount = false;
            boolean probableCase = false;
            boolean globalProbable = false;
            int balanceCount = 0;
            while (annotItr.hasNext()) {
                PADHit uaHit2;
                negatedCase = false;
                if (++count >= 1) {
                    this.casConsumerOffSetData.append("(");
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR);
                }
                if ((uaHit2 = (PADHit)annotItr.next()).getUaTerm() != null) {
                    this.casConsumerOutData.append(uaHit2.getUaTerm().getSegmentID());
                } else if (uaHit2.getUaLocation() != null) {
                    this.casConsumerOutData.append(uaHit2.getUaLocation().getSegmentID());
                }
                PADLocation ual = uaHit2.getUaLocation();
                PADTerm uat = uaHit2.getUaTerm();
                if (ual != null) {
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR + ual.getCoveredText());
                    this.casConsumerOffSetData.append(String.valueOf(ual.getBegin()) + "-" + ual.getEnd() + FIELD_SEPARATOR);
                    if (ual.getCertainty() == -1 && uat == null || ual.getCertainty() == -1 && uat != null && uat.getTypeID() != this.disorderStenosis && ual.getCertainty() == -1) {
                        negatedCase = true;
                    } else if (ual.getIsStandAlone() != 1 && ual.getCertainty() != -1 && ual.getStatus() == this.disorderPatent) {
                        probableCase = true;
                        ++probableCount;
                    } else {
                        probableCase = false;
                    }
                } else {
                    this.casConsumerOutData.append("| ");
                    this.casConsumerOffSetData.append("-1:");
                    if (uat.getTypeID() == this.disorderStenosis && uat.getCertainty() != -1) {
                        noStenosis = false;
                    }
                    if (uat != null && uat.getCertainty() == -1 && uat.getTypeID() != this.disorderStenosis && uat.getTypeID() != this.anatomicalSiteExclusion) {
                        negatedCase = true;
                    } else if (uat != null && (uat.getIsStandAlone() != 1 || uat.getTypeID() == this.disorderPatent) && uat.getCertainty() != -1) {
                        probableCase = true;
                        ++probableCount;
                    } else {
                        probableCase = false;
                    }
                }
                if (uat != null) {
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR + uat.getCoveredText());
                    this.casConsumerOffSetData.append(String.valueOf(uat.getBegin()) + "-" + uat.getEnd() + ")");
                    if (uat.getTypeID() == this.disorderStenosis && uat.getCertainty() != -1) {
                        noStenosis = false;
                    }
                    if (uat.getCertainty() == -1 && uat.getTypeID() != this.disorderStenosis && uat.getStatus() != this.disorderPatent && uat.getTypeID() != this.anatomicalSiteExclusion && uat.getIsStandAlone() != 1) {
                        negatedCase = true;
                    } else if (uat.getStatus() == this.disorderPatent && uat.getIsStandAlone() != 1) {
                        probableCase = true;
                        ++probableCount;
                    } else if (!negatedCase) {
                        probableCase = false;
                    }
                } else {
                    this.casConsumerOutData.append("| ");
                    this.casConsumerOffSetData.append("-1)");
                    if (ual != null && ual.getCertainty() == -1 && ual.getStatus() != this.disorderPatent) {
                        negatedCase = true;
                    } else if (ual.getIsStandAlone() != 1 && ual.getCertainty() != -1 && ual.getStatus() == this.disorderPatent) {
                        probableCase = true;
                        ++probableCount;
                    } else {
                        probableCase = false;
                    }
                }
                if (probableCase) {
                    globalProbable = true;
                }
                if (negatedCase || probableCase) {
                    --count;
                    negCount = true;
                    if (uat == null || probableCase || uat.getTypeID() == this.disorderStenosis || uat.getTypeID() == this.disorderPatent || ual != null && (ual == null || ual.getTypeID() == this.disorderPatent || ual.getCertainty() != -1)) continue;
                    --balanceCount;
                    continue;
                }
                ++balanceCount;
            }
            annotItr = indexes.getAnnotationIndex(PADLocation.type).iterator();
            while (annotItr.hasNext()) {
                PADLocation location = (PADLocation)annotItr.next();
                annotHitItr = indexes.getAnnotationIndex(PADHit.type).iterator();
                boolean skip = false;
                if (location.getCoveredText().indexOf("vein") != -1) {
                    noVein = false;
                    ++veinCount;
                }
                while (annotHitItr.hasNext() && !skip) {
                    uaHit = (PADHit)annotHitItr.next();
                    if (uaHit.getUaLocation() == null || location.getBegin() != uaHit.getUaLocation().getBegin()) continue;
                    skip = true;
                }
                if (skip) continue;
                if (location.getCertainty() == -1) {
                    locTermsOnly = true;
                }
                if (location.getCertainty() != -1) {
                    ++locOnlyCount;
                    this.casConsumerOffSetData.append("(");
                    this.casConsumerOffSetData.append("-1:");
                    this.casConsumerOffSetData.append(String.valueOf(location.getBegin()) + "-" + location.getEnd() + ")");
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR);
                    this.casConsumerOutData.append(location.getSegmentID());
                    this.casConsumerOutData.append("|**NO TERM**");
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR + location.getCoveredText());
                    continue;
                }
                if (location.getCertainty() == -1 || location.getTypeID() == this.disorderStenosis || location.getTypeID() == this.anatomicalSiteExclusion || location.getStatus() != this.disorderPatent) continue;
                --locOnlyCount;
            }
            annotItr = indexes.getAnnotationIndex(PADTerm.type).iterator();
            while (annotItr.hasNext()) {
                PADTerm term = (PADTerm)annotItr.next();
                annotHitItr = indexes.getAnnotationIndex(PADHit.type).iterator();
                boolean skip = false;
                while (annotHitItr.hasNext() && !skip) {
                    uaHit = (PADHit)annotHitItr.next();
                    if (uaHit.getUaTerm() == null || term.getBegin() != uaHit.getUaTerm().getBegin()) continue;
                    skip = true;
                }
                if (skip) continue;
                locTermsOnly = false;
                if (term.getTypeID() == this.disorderStenosis && term.getCertainty() != -1) {
                    noStenosis = false;
                }
                if (term.getStatus() == this.disorderPatent && (term.getCertainty() != -1 || term.getTypeID() == this.disorderStenosis && term.getTypeID() != this.anatomicalSiteExclusion)) {
                    if (term.getStatus() == this.disorderPatent && count == 0) {
                        globalProbable = true;
                        if (term.getCoveredText().compareToIgnoreCase("stent") == 0 || term.getCoveredText().compareToIgnoreCase("stents") == 0 || term.getCoveredText().compareToIgnoreCase("stented") == 0) {
                            noStent = false;
                        }
                    }
                    ++termOnlyCount;
                    this.casConsumerOffSetData.append("(");
                    this.casConsumerOffSetData.append(String.valueOf(term.getBegin()) + "-" + term.getEnd() + ":-1)");
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR);
                    this.casConsumerOutData.append(term.getSegmentID());
                    this.casConsumerOutData.append(COLLECTION_SEPARATOR + term.getCoveredText());
                    this.casConsumerOutData.append("|**NO LOC**");
                    continue;
                }
                if (term.getCertainty() == -1 || term.getTypeID() == this.disorderStenosis || term.getTypeID() == this.anatomicalSiteExclusion || term.getTypeID() != this.disorderPatent) continue;
                --termOnlyCount;
            }
            int loc = this.casConsumerOffSetData.indexOf(COUNT_PLACE_HOLDER);
            this.casConsumerOffSetData.append(this.casConsumerOutData.toString());
            boolean noRelatedExam = !haveUSSoloExamType && !haveUSExamType && !haveLowerExtExamType && !haveCombinedExamType && !haveLowerSoloExamType && !haveVRADExamType;
            String classification = null;
            classification = !this.alternateAlgorithm.booleanValue() ? (!((haveUSSoloExamType || haveUSExamType || haveLowerExtExamType || haveCombinedExamType || haveLowerSoloExamType || CTTypeExam || negCount || negatedCase || globalProbable || count >= 1) && (!noRelatedExam || CTTypeExam)) ? String.valueOf(-1) : ((balanceCount > 0 || count > 0) && (haveVRADExamType || haveUSSoloExamType || haveUSExamType || haveLowerExtExamType || haveCombinedExamType || haveLowerSoloExamType || CTTypeExam) ? String.valueOf(count) : ((negatedCase || negCount) && (balanceCount < 0 && locOnlyCount + balanceCount < 1 || noStenosis && noStent && noVein && !globalProbable && haveCombinedExamType && (!locTermsOnly || negatedCase)) || count < 0 || haveLowerSoloExamType && haveUSExamType && locOnlyCount > 0 ? String.valueOf(0) : ((haveUSSoloExamType || haveUSExamType || haveCombinedExamType || haveLowerExtExamType || haveLowerSoloExamType || haveVRADExamType || CTTypeExam) && (!probableCase && probableCount < 1 && (negatedCase || negCount) || veinCount > 0) ? String.valueOf(-1) : "prob")))) : this.calculateRecordLevelClassification(count, termOnlyCount, locOnlyCount, balanceCount, probableCount, veinCount, noStent, locTermsOnly, noVein, noStenosis, CTTypeExam, haveLowerExtExamType, haveCombinedExamType, haveUSSoloExamType, haveLowerSoloExamType, haveUSExamType, negCount, negatedCase, globalProbable);
            this.casConsumerOffSetData.replace(loc, loc + COUNT_PLACE_HOLDER.length(), classification);
            this.casConsumerOffSetData.append("\n");
            this.fos.write(this.casConsumerOffSetData.toString().getBytes());
        }
        catch (IOException ioe) {
            throw new ResourceProcessException(ioe);
        }
    }

    @Override
    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        super.collectionProcessComplete(arg0);
        File file = new File(new File(this.iv_outputFile.getAbsolutePath()).getParent());
        this.holdResults = new File(file + System.getProperty("file.separator") + "Summary_PADRadiology.csv");
        if (file.isDirectory()) {
            String[] processFiles = file.list();
            if (!this.holdResults.exists()) {
                this.store(this.holdResults.getAbsolutePath(), this.drugHeaders);
            }
            int i = 0;
            while (i < processFiles.length) {
                System.out.println("Process Each File in '" + file + System.getProperty("file.separator") + processFiles[i] + "'");
                File nextFile = new File(file + System.getProperty("file.separator") + processFiles[i]);
                boolean hasNext = true;
                if (!nextFile.isDirectory()) {
                    int numPADConfirmed = 0;
                    int numPADConfirmedWeight = 0;
                    int numPADNegative = 0;
                    int numPADProbable = 0;
                    int countPatientRecords = 0;
                    String fileName = nextFile.getAbsolutePath();
                    List<String[][]> findPatientPADClassification = PADOffSetsRecord.loadFieldContents(fileName);
                    List<String[][]> nextPatientPADClassification = PADOffSetsRecord.loadFieldContents(fileName);
                    Iterator<String[][]> searchNextPatient = nextPatientPADClassification.iterator();
                    searchNextPatient.next();
                    Iterator<String[][]> searchPatientClassification = findPatientPADClassification.iterator();
                    String[][] nextPatientClassInstance = null;
                    String nextPatientID = "";
                    while (searchPatientClassification.hasNext()) {
                        ++countPatientRecords;
                        hasNext = searchNextPatient.hasNext();
                        if (hasNext) {
                            nextPatientClassInstance = searchNextPatient.next();
                            nextPatientID = nextPatientClassInstance[0][0];
                        }
                        String[][] patientClassInstance = searchPatientClassification.next();
                        String patientID = patientClassInstance[0][0];
                        String classificationPAD = patientClassInstance[1][0];
                        if (classificationPAD.indexOf("-1") == -1) {
                            if (classificationPAD.indexOf("prob") == 0) {
                                ++numPADProbable;
                            } else if (classificationPAD.indexOf("0") == 0) {
                                ++numPADNegative;
                            } else {
                                ++numPADConfirmed;
                                numPADConfirmedWeight += new Integer(classificationPAD).intValue();
                            }
                        }
                        if (nextPatientID.compareTo(patientID) == 0 && (hasNext || nextPatientID.compareTo(patientID) != 0)) continue;
                        if (numPADNegative > numPADProbable && numPADNegative > numPADConfirmed && numPADNegative > numPADConfirmedWeight) {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",no");
                        } else if (numPADProbable > numPADNegative && numPADProbable > numPADConfirmed || numPADConfirmed > 0 && numPADNegative == numPADConfirmed && numPADConfirmedWeight == numPADNegative) {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",probable");
                        } else if (!(numPADConfirmed <= numPADNegative && numPADConfirmedWeight <= numPADNegative || numPADConfirmed <= numPADProbable && numPADConfirmedWeight <= numPADProbable)) {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",yes");
                        } else if (!(numPADConfirmed <= numPADNegative && numPADConfirmedWeight <= numPADNegative || numPADConfirmed != numPADProbable && numPADConfirmedWeight <= numPADProbable)) {
                            if (numPADConfirmedWeight / numPADProbable > 1) {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",yes");
                            } else {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",probable");
                            }
                        } else if (!(numPADConfirmed <= numPADProbable && numPADConfirmedWeight <= numPADProbable || numPADConfirmed != numPADNegative && numPADConfirmedWeight <= numPADNegative)) {
                            if (numPADConfirmedWeight / numPADNegative > 1) {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",yes");
                            } else {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",unknown");
                            }
                        } else if (numPADNegative > numPADConfirmed && numPADNegative == numPADProbable) {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",probable");
                        } else if (numPADNegative > numPADProbable && numPADNegative == numPADConfirmed) {
                            if (numPADConfirmed > 0 && numPADConfirmedWeight / numPADNegative > 1) {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",yes");
                            } else {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",unknown");
                            }
                        } else if (numPADProbable > numPADConfirmed && numPADProbable == numPADNegative) {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",unknown");
                        } else if (numPADProbable > numPADNegative && numPADProbable == numPADConfirmed) {
                            if (numPADConfirmed > 0 && numPADConfirmedWeight / numPADProbable > 1) {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",yes");
                            } else {
                                this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",probable");
                            }
                        } else {
                            this.store(this.holdResults.getAbsolutePath(), String.valueOf(patientID) + ",unknown");
                        }
                        numPADConfirmed = 0;
                        numPADConfirmedWeight = 0;
                        numPADNegative = 0;
                        numPADProbable = 0;
                        countPatientRecords = 0;
                    }
                }
                ++i;
            }
        }
        this.fos.close();
    }

    private String calculateRecordLevelClassification(int numberOfHits, int numberOfTermOnly, int numberOfLocationOnly, int differentialHitCount, int numberOfProbable, int numberVeinMentions, boolean noMentionOfStents, boolean locationTermsOnly, boolean noMentionOfVeins, boolean noMentionOfStenosis, boolean haveCT_EXAM, boolean haveLOWER_EXT, boolean haveUS_LOWER_EXT, boolean haveUS_EXAM_SOLO, boolean haveUS_LOWER_SOLOorCT_EXAM_SOLO, boolean haveUS_EXAM, boolean haveNegativeCases, boolean possibleNegativeCases, boolean foundEvidenceOfProbable) {
        if (numberOfHits == 0 && numberOfTermOnly + numberOfLocationOnly >= 0) {
            differentialHitCount = 0;
        }
        if (!((differentialHitCount >= 0 && haveCT_EXAM || numberOfHits != 0 || haveNegativeCases || foundEvidenceOfProbable || haveLOWER_EXT || haveUS_LOWER_EXT) && (haveUS_EXAM || haveUS_LOWER_EXT || haveCT_EXAM || haveUS_LOWER_SOLOorCT_EXAM_SOLO || haveLOWER_EXT || numberOfHits != 0 || haveNegativeCases || !locationTermsOnly || numberOfLocationOnly <= noPadMentionThreshold) && (!haveUS_EXAM && !haveUS_LOWER_EXT || numberOfHits != 0 || noMentionOfStenosis || foundEvidenceOfProbable || locationTermsOnly && noMentionOfVeins && !haveNegativeCases) && (numberOfLocationOnly > noPadMentionThreshold || numberOfHits != 0 || haveNegativeCases && noMentionOfVeins || noMentionOfStenosis || foundEvidenceOfProbable || numberOfTermOnly > 0 && differentialHitCount >= 0) && (!noMentionOfStenosis || haveUS_LOWER_EXT || haveLOWER_EXT || numberOfHits != 0 || foundEvidenceOfProbable))) {
            return String.valueOf(-1);
        }
        if (!(numberOfHits <= 0 || (noMentionOfStenosis || !haveCT_EXAM && !haveLOWER_EXT && !haveUS_LOWER_EXT || foundEvidenceOfProbable && possibleNegativeCases && numberOfHits < noPadMentionThreshold) && (numberOfHits <= 0 || differentialHitCount < 0 || foundEvidenceOfProbable || haveUS_LOWER_SOLOorCT_EXAM_SOLO || haveUS_EXAM_SOLO) && numberOfHits + numberOfLocationOnly + numberOfTermOnly < noPadMentionThreshold)) {
            return String.valueOf(numberOfHits);
        }
        if ((haveNegativeCases || numberOfLocationOnly >= noPadMentionThreshold && numberOfTermOnly <= 0 && (haveLOWER_EXT || haveUS_EXAM || haveUS_LOWER_EXT)) && !foundEvidenceOfProbable && !haveUS_LOWER_SOLOorCT_EXAM_SOLO || noMentionOfStenosis && (numberOfHits != 0 && numberOfTermOnly != 0 && differentialHitCount != 0 || haveLOWER_EXT) && !foundEvidenceOfProbable && noMentionOfVeins && (haveCT_EXAM || haveLOWER_EXT)) {
            return String.valueOf(0);
        }
        if (foundEvidenceOfProbable && (haveLOWER_EXT || haveUS_EXAM || haveUS_LOWER_SOLOorCT_EXAM_SOLO || haveUS_EXAM_SOLO || haveUS_LOWER_EXT || (haveCT_EXAM || numberOfProbable >= noPadMentionThreshold) && noMentionOfStents && (noMentionOfVeins || !noMentionOfVeins && numberVeinMentions < numberOfProbable + numberOfLocationOnly) && !haveUS_EXAM_SOLO && !haveUS_LOWER_SOLOorCT_EXAM_SOLO)) {
            return "prob";
        }
        return String.valueOf(-1);
    }

    private void store(String filename, String lineToStore) throws FileNotFoundException, IOException {
        int howMany = 132;
        boolean skipDate = false;
        File f = new File(filename);
        if (!f.exists()) {
            f.createNewFile();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(howMany * 4);
        DataOutputStream dout = new DataOutputStream(bout);
        FileOutputStream fos = new FileOutputStream(filename, true);
        if (!skipDate) {
            dout.writeBytes(String.valueOf(lineToStore) + '\n');
        }
        try {
            if (!skipDate) {
                bout.writeTo(fos);
                fos.flush();
            }
        }
        finally {
            fos.close();
            bout.close();
            dout.close();
        }
    }

    private static List<String[][]> loadFieldContents(String filename) throws FileNotFoundException, IOException {
        String[][] padClass = null;
        ArrayList<String[][]> listIdandClassification = new ArrayList<String[][]>();
        File f = new File(filename);
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        int index = 0;
        while (line != null && line != "" && line.length() > 0) {
            String patientID = line.substring(0, line.indexOf(124));
            String temp = line.substring(line.indexOf(124) + 1);
            String padClassification = temp.substring(0, temp.indexOf(124));
            padClass = new String[][]{{patientID}, {padClassification}};
            listIdandClassification.add(index, padClass);
            ++index;
            line = br.readLine();
        }
        br.close();
        return listIdandClassification;
    }
}

