/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.termspotter.cr;

import edu.mayo.bmi.uima.core.type.DocumentID;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class RadiologyRecordsCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUT_FILE_NAME = "InputFileName";
    public static final String PARAM_COMMENT_STRING = "CommentString";
    public static final String PARAM_IGNORE_BLANK_LINES = "IgnoreBlankLines";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_ID_DELIMETER = "IdDelimeter";
    public static final String PARAM_TOTAL_COLUMNS = "ColumnCount";
    public static final String PARAM_FILTER_EXAMS = "FilterExamTypes";
    public static final String PARAM_EXAM_COLUMN = "FilterExamColumnNumber";
    List iv_linesFromFile;
    int iv_currentIndex = 0;
    String iv_language;
    String iv_delimeter;
    Integer numberOfColumns;
    String filterExamTypes;
    Integer filterColunmNumber;
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void initialize() throws ResourceInitializationException {
        BufferedReader fileReader = null;
        try {
            try {
                String line;
                this.numberOfColumns = (Integer)this.getConfigParameterValue(PARAM_TOTAL_COLUMNS);
                String fileLocation = (String)this.getConfigParameterValue(PARAM_INPUT_FILE_NAME);
                String commentSeq = (String)this.getConfigParameterValue(PARAM_COMMENT_STRING);
                this.iv_language = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
                Boolean paramValue = (Boolean)this.getConfigParameterValue(PARAM_IGNORE_BLANK_LINES);
                this.filterExamTypes = (String)this.getConfigParameterValue(PARAM_FILTER_EXAMS);
                this.filterColunmNumber = (Integer)this.getConfigParameterValue(PARAM_EXAM_COLUMN);
                boolean ignoreBlankLines = true;
                if (paramValue != null) {
                    ignoreBlankLines = paramValue;
                }
                this.iv_delimeter = (String)this.getConfigParameterValue(PARAM_ID_DELIMETER);
                this.iv_linesFromFile = new ArrayList();
                fileReader = new BufferedReader(new FileReader(fileLocation));
                while ((line = fileReader.readLine()) != null) {
                    if (commentSeq != null && line.startsWith(commentSeq) || ignoreBlankLines && line.trim().length() == 0) continue;
                    this.iv_linesFromFile.add(line);
                }
            }
            catch (IOException fnfe) {
                throw new ResourceInitializationException(fnfe);
            }
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void getNext(CAS cas) throws IOException, CollectionException {
        try {
            try {
                String text;
                String id;
                JCas jcas = cas.getJCas();
                boolean foundLine = false;
                String line = (String)this.iv_linesFromFile.get(this.iv_currentIndex);
                int lineNumber = this.iv_currentIndex + 1;
                BufferedReader filterExamTypesFile = null;
                if (this.filterExamTypes != null && this.filterExamTypes != "") {
                    filterExamTypesFile = new BufferedReader(new FileReader(this.filterExamTypes));
                }
                if (this.iv_delimeter != null) {
                    int delimeterLoc;
                    String[] delimitedColumns = line.split(this.iv_delimeter);
                    if (filterExamTypesFile != null) {
                        String filterLine;
                        filterExamTypesFile.readLine();
                        while ((filterLine = filterExamTypesFile.readLine()) != null && !foundLine) {
                            String examToCheck = filterLine.substring(0, filterLine.indexOf(44));
                            if (!delimitedColumns[this.filterColunmNumber].equals(examToCheck)) continue;
                            foundLine = true;
                        }
                    }
                    if ((delimeterLoc = line.indexOf(this.iv_delimeter)) <= 0) {
                        throw new CollectionException(new Exception("Line in file number " + lineNumber + " is not well formatted.  " + "\nIt should have the format:" + "\n<doc_id>" + this.iv_delimeter + "<doc_text>"));
                    }
                    id = line.substring(0, delimeterLoc);
                    if (foundLine) {
                        text = this.numberOfColumns > 0 && this.iv_delimeter != null && this.iv_delimeter != "" ? delimitedColumns[this.numberOfColumns - 1] : line.substring(delimeterLoc + this.iv_delimeter.length());
                    } else {
                        id = line.substring(0, delimeterLoc);
                        text = "";
                    }
                } else {
                    id = Integer.toString(lineNumber);
                    text = line;
                }
                this.iv_logger.debug("id=" + id);
                this.iv_logger.debug("text=" + text);
                if (this.getCasInitializer() != null) {
                    StringReader reader = new StringReader(text);
                    this.getCasInitializer().initializeCas(reader, cas);
                    ((Reader)reader).close();
                } else {
                    jcas.setDocumentText(text);
                }
                if (this.iv_language != null) {
                    ((DocumentAnnotation)jcas.getDocumentAnnotationFs()).setLanguage(this.iv_language);
                }
                DocumentID documentIDAnnotation = new DocumentID(jcas);
                documentIDAnnotation.setDocumentID(id);
                documentIDAnnotation.addToIndexes();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                this.iv_logger.log(Level.ERROR, "Radiology input file corrupt or some record row contents are not valid.");
                throw new CollectionException(aioobe);
            }
            catch (CASException e) {
                throw new CollectionException(e);
            }
        }
        finally {
            ++this.iv_currentIndex;
        }
    }

    @Override
    public boolean hasNext() throws IOException, CollectionException {
        return this.iv_currentIndex < this.iv_linesFromFile.size();
    }

    @Override
    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.iv_currentIndex, this.iv_linesFromFile.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.iv_linesFromFile.size();
    }

    @Override
    public void close() throws IOException {
    }
}

