/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToGetUnicodeSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToSyntacticUninvert;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class LvgApi {
    private int outRecordNum_ = -1;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private RamTrie ramTrieD_ = null;
    private String configFile_ = null;
    private Configuration conf_ = null;
    private RTrieTree removeSTree_ = null;
    private Hashtable<String, String> properties_ = null;
    private int maxTerm_ = -1;
    private int maxCodeLength_ = -1;
    private Vector<String> stopWords_ = null;
    private Vector<String> nonInfoWords_ = null;
    private Vector<String> conjunctionWords_ = null;
    private Hashtable<Character, Character> diacriticMap_ = null;
    private Hashtable<Character, String> ligatureMap_ = null;
    private Hashtable<Character, Character> unicodeSynonymMap_ = null;
    private Hashtable<Character, String> symbolMap_ = null;
    private Hashtable<Character, String> unicodeMap_ = null;
    private Hashtable<Character, String> nonStripMap_ = null;

    public LvgApi() {
        this.Init();
    }

    public LvgApi(String configFile) {
        this.configFile_ = configFile;
        this.Init();
    }

    public LvgApi(Hashtable<String, String> properties) {
        this.properties_ = properties;
        this.Init();
    }

    public LvgApi(String configFile, Hashtable<String, String> properties) {
        this.configFile_ = configFile;
        this.properties_ = properties;
        this.Init();
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public void CloseConnection(Connection conn) {
        if (conn != null) {
            try {
                DbBase.CloseConnection(conn, this.conf_);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RamTrie GetInflectionTrie() {
        return this.ramTrieI_;
    }

    public RamTrie GetDerivationTrie() {
        return this.ramTrieD_;
    }

    public RTrieTree GetRemoveSTree() {
        return this.removeSTree_;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int GetMaxTerm() {
        return this.maxTerm_;
    }

    public int GetMaxCodeLength() {
        return this.maxCodeLength_;
    }

    public Vector<String> GetStopWords() {
        return this.stopWords_;
    }

    public Vector<String> GetNonInfoWords() {
        return this.nonInfoWords_;
    }

    public Vector<String> GetConjunctionWords() {
        return this.conjunctionWords_;
    }

    public Hashtable<Character, Character> GetDiacriticMap() {
        return this.diacriticMap_;
    }

    public Hashtable<Character, String> GetLigatureMap() {
        return this.ligatureMap_;
    }

    public Hashtable<Character, Character> GetUnicodeSynonymMap() {
        return this.unicodeSynonymMap_;
    }

    public Hashtable<Character, String> GetSymbolMap() {
        return this.symbolMap_;
    }

    public Hashtable<Character, String> GetUnicodeMap() {
        return this.unicodeMap_;
    }

    public Hashtable<Character, String> GetNonStripMap() {
        return this.nonStripMap_;
    }

    private void Init() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (this.properties_ != null) {
            this.conf_.OverwriteProperties(this.properties_);
        }
        int minTermLen = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = this.conf_.GetConfiguration("LVG_DIR");
        this.outRecordNum_ = Integer.parseInt(this.conf_.GetConfiguration("TRUNCATED_RESULTS"));
        this.maxTerm_ = Integer.parseInt(this.conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        this.maxCodeLength_ = Integer.parseInt(this.conf_.GetConfiguration("MAX_METAPHONE"));
        this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
        this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(this.conf_);
        this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(this.conf_);
        this.diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(this.conf_);
        this.ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(this.conf_);
        this.unicodeSynonymMap_ = ToGetUnicodeSynonyms.GetUnicodeSynonymMapFromFile(this.conf_);
        this.symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(this.conf_);
        this.unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(this.conf_);
        this.nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(this.conf_);
        int minTrieStemLength = Integer.parseInt(this.conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        this.removeSTree_ = ToRemoveS.GetRTrieTreeFromFile(this.conf_);
        try {
            this.conn_ = DbBase.OpenConnection(this.conf_);
            this.ramTrieI_ = new RamTrie(true, minTermLen, lvgDir, 0);
            this.ramTrieD_ = new RamTrie(false, minTermLen, lvgDir, minTrieStemLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Close() throws IOException, SQLException {
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_, this.conf_);
        }
    }
}

