/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Api.LvgCmdApi;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class LvgLexItemApi
extends LvgCmdApi {
    public LvgLexItemApi() {
    }

    public LvgLexItemApi(String optionStr) {
        super(optionStr);
    }

    public LvgLexItemApi(String optionStr, String configFile) {
        super(optionStr, configFile);
    }

    public LvgLexItemApi(Hashtable<String, String> properties) {
        super(properties);
    }

    public LvgLexItemApi(String optionStr, Hashtable<String, String> properties) {
        super(optionStr, properties);
    }

    public LvgLexItemApi(String optionStr, String configFile, Hashtable<String, String> properties) {
        super(optionStr, configFile, properties);
    }

    public Vector<LexItem> MutateLexItem(String inLine) throws Exception {
        Vector<LexItem> outs = new Vector();
        outs = this.ProcessLexItem(inLine);
        return outs;
    }

    public Vector<LexItem> ProcessLexItemsFromFCO(Vector<LexItem> ins) throws SQLException, IOException {
        if (ins == null) {
            return null;
        }
        Vector<LexItem> results = new Vector<LexItem>();
        for (int i = 0; i < ins.size(); ++i) {
            LexItem in = ins.elementAt(i);
            LexItem tempIn = LexItem.TargetToSource(in);
            Vector<LexItem> out = this.ProcessLexItem(in);
            results.addAll(out);
        }
        return results;
    }

    public Vector<LexItem> ProcessLexItems(Vector<LexItem> ins) throws SQLException, IOException {
        if (ins == null) {
            return null;
        }
        Vector<LexItem> results = new Vector<LexItem>();
        for (int i = 0; i < ins.size(); ++i) {
            LexItem in = ins.elementAt(i);
            Vector<LexItem> out = this.ProcessLexItem(in);
            results.addAll(out);
        }
        return results;
    }

    public Vector<LexItem> ProcessLexItem(LexItem in) throws SQLException, IOException {
        Vector<LexItem> results = new Vector<LexItem>();
        for (int flowNum = 0; flowNum < this.flowStrsList_.size(); ++flowNum) {
            this.flowStrs_ = (Vector)this.flowStrsList_.elementAt(flowNum);
            Vector<LexItem> ins = new Vector<LexItem>();
            Vector<LexItem> outs = new Vector<LexItem>();
            ins.addElement(in);
            for (int flowComp = 0; flowComp < this.flowStrs_.size(); ++flowComp) {
                Vector<LexItem> cur = new Vector<LexItem>();
                for (int inLex = 0; inLex < ins.size(); ++inLex) {
                    LexItem tempIn = (LexItem)ins.elementAt(inLex);
                    tempIn.SetFlowNumber(flowNum + 1);
                    Vector<LexItem> tempOuts = this.ExecuteFlow(tempIn, (String)this.flowStrs_.elementAt(flowComp));
                    cur.addAll(tempOuts);
                }
                outs.removeAllElements();
                outs.addAll(cur);
                ins = LexItem.TargetsToSources(outs);
            }
            results.addAll(outs);
        }
        return results;
    }

    public Vector<LexItem> ProcessLineLexItem() throws SQLException, IOException {
        if (!this.runFlag_) {
            return null;
        }
        if (this.promptFlag_) {
            this.GetPrompt();
        }
        String line = null;
        if (inReader_ == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            line = in.readLine();
        } else {
            line = inReader_.readLine();
        }
        if (line == null || this.quitStrList_.contains(line)) {
            return null;
        }
        Vector<LexItem> outs = this.ProcessLexItem(line);
        return outs;
    }

    private Vector<LexItem> ProcessLexItem(String line) throws SQLException, IOException {
        Vector<LexItem> results = new Vector<LexItem>();
        String fs = GlobalBehavior.GetFieldSeparator();
        String inTerm = InputFilter.GetInputTerm(line, fs, this.termFieldNum_);
        long inCat = InputFilter.GetInputCategory(line, fs, this.catFieldNum_);
        long inInfl = InputFilter.GetInputInflection(line, fs, this.inflFieldNum_);
        LexItem in = new LexItem(inTerm, inCat, inInfl);
        for (int flowNum = 0; flowNum < this.flowStrsList_.size(); ++flowNum) {
            this.flowStrs_ = (Vector)this.flowStrsList_.elementAt(flowNum);
            Vector<LexItem> ins = new Vector<LexItem>();
            Vector<LexItem> outs = new Vector<LexItem>();
            ins.addElement(in);
            for (int flowComp = 0; flowComp < this.flowStrs_.size(); ++flowComp) {
                Vector<LexItem> cur = new Vector<LexItem>();
                for (int inLex = 0; inLex < ins.size(); ++inLex) {
                    LexItem tempIn = (LexItem)ins.elementAt(inLex);
                    tempIn.SetFlowNumber(flowNum + 1);
                    Vector<LexItem> tempOuts = this.ExecuteFlow(tempIn, (String)this.flowStrs_.elementAt(flowComp));
                    cur.addAll(tempOuts);
                }
                outs.removeAllElements();
                outs.addAll(cur);
                ins = LexItem.TargetsToSources(outs);
            }
            results.addAll(outs);
        }
        return results;
    }
}

