/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Util.Str;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DbBase {
    public static Connection OpenConnection(Configuration config) throws SQLException {
        String driverName = DbBase.GetDbDriverFromConfig(config);
        String url = DbBase.GetDbUrlFromConfig(config);
        Connection conn = null;
        DbBase.LoadDbDriver(driverName);
        String userName = DbBase.GetDbUserNameFromConfig(config);
        String password = DbBase.GetDbPasswordFromConfig(config);
        conn = DriverManager.getConnection(url, userName, password);
        return conn;
    }

    public static Connection OpenConnection(String driverName, String url, String userName, String password) throws SQLException {
        Connection conn = null;
        DbBase.LoadDbDriver(driverName);
        conn = DriverManager.getConnection(url, userName, password);
        return conn;
    }

    public static void CloseConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public static void CloseConnection(Connection conn, Configuration config) throws SQLException {
        String dbStr = config.GetConfiguration("DB_TYPE");
        conn.close();
    }

    public static void ShutdownDb(Connection conn, Configuration config) throws SQLException {
        String dbStr = config.GetConfiguration("DB_TYPE");
        if (dbStr.equals("HSQLDB")) {
            DbBase.ExecuteDdl(conn, "SHUTDOWN");
        }
        conn.close();
    }

    public static String FormatSqlStr(String in) {
        String out = Str.Replace(in, "'", "''");
        return out;
    }

    static void SubmitDMLs(String query, Configuration config) {
        Connection conn = null;
        String driverName = DbBase.GetDbDriverFromConfig(config);
        DbBase.LoadDbDriver(driverName);
        try {
            String url = DbBase.GetDbUrlFromConfig(config);
            String userName = DbBase.GetDbUserNameFromConfig(config);
            String password = DbBase.GetDbPasswordFromConfig(config);
            conn = DriverManager.getConnection(url, userName, password);
            Statement statement = conn.createStatement();
            statement.executeQuery(query);
            statement.close();
            conn.close();
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    System.err.println("SQLException: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static void LoadDbDriver(String driverName) {
        try {
            Class.forName(driverName).newInstance();
        }
        catch (Exception e) {
            System.err.println("** Error: Unable to load driver (" + driverName + ").");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static String GetDbUserNameFromConfig(Configuration config) {
        String userName = config.GetConfiguration("DB_USERNAME");
        return userName;
    }

    private static String GetDbPasswordFromConfig(Configuration config) {
        String password = config.GetConfiguration("DB_PASSWORD");
        return password;
    }

    private static String GetDbDriverFromConfig(Configuration config) {
        String driverName = config.GetConfiguration("DB_DRIVER");
        return driverName;
    }

    private static String GetDbUrlFromConfig(Configuration config) {
        String dbStr = config.GetConfiguration("DB_TYPE");
        String url = null;
        if (dbStr.equals("HSQLDB")) {
            url = "jdbc:hsqldb:file:" + config.GetConfiguration("LVG_DIR") + "data/HSqlDb/" + config.GetConfiguration("DB_NAME");
        } else if (dbStr.equals("MYSQL")) {
            url = "jdbc:mysql://" + config.GetConfiguration("DB_HOST") + "/" + config.GetConfiguration("DB_NAME");
        } else if (dbStr.equals("OTHER")) {
            url = config.GetConfiguration("JDBC_URL");
        }
        return url;
    }

    private static void ExecuteDdl(Connection conn, String query) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(query);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("** Error: SQLException: " + e.getMessage());
            System.out.println("** Error: SQLState:     " + e.getSQLState());
            System.out.println("** Error: VendorError:  " + e.getErrorCode());
        }
    }
}

