/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.NominalizationComparator;
import gov.nih.nlm.nls.lvg.Db.NominalizationRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbNominalization {
    public static Vector<NominalizationRecord> GetNominalizations(String inStr, Connection conn) throws SQLException {
        NominalizationRecord nominalizationRecord;
        String query = "SELECT nomTerm1, eui1, cat1, nomTerm2, eui2, cat2 FROM Nominalization WHERE nomTerm1 = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        Vector<NominalizationRecord> nominalizations = new Vector<NominalizationRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            nominalizationRecord = new NominalizationRecord();
            nominalizationRecord.SetNominalization1(rs.getString(1));
            nominalizationRecord.SetEui1(rs.getString(2));
            nominalizationRecord.SetCat1(rs.getInt(3));
            nominalizationRecord.SetNominalization2(rs.getString(4));
            nominalizationRecord.SetEui2(rs.getString(5));
            nominalizationRecord.SetCat2(rs.getInt(6));
            nominalizations.addElement(nominalizationRecord);
        }
        rs.close();
        ps.close();
        query = "SELECT nomTerm2, eui2, cat2, nomTerm1, eui1, cat1 FROM Nominalization WHERE nomTerm2 = ?";
        ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        rs = ps.executeQuery();
        while (rs.next()) {
            nominalizationRecord = new NominalizationRecord();
            nominalizationRecord.SetNominalization1(rs.getString(1));
            nominalizationRecord.SetEui1(rs.getString(2));
            nominalizationRecord.SetCat1(rs.getInt(3));
            nominalizationRecord.SetNominalization2(rs.getString(4));
            nominalizationRecord.SetEui2(rs.getString(5));
            nominalizationRecord.SetCat2(rs.getInt(6));
            nominalizations.addElement(nominalizationRecord);
        }
        rs.close();
        ps.close();
        NominalizationComparator nc = new NominalizationComparator();
        Collections.sort(nominalizations, nc);
        return nominalizations;
    }

    public static void main(String[] args) {
        String testStr = "active";
        if (args.length == 1) {
            testStr = args[0];
        }
        System.out.println("--- TestStr:  " + testStr);
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<NominalizationRecord> nominalizationList = DbNominalization.GetNominalizations(testStr, conn);
                System.out.println("----- Total Nominalization found: " + nominalizationList.size());
                for (int j = 0; j < nominalizationList.size(); ++j) {
                    NominalizationRecord rec = nominalizationList.elementAt(j);
                    System.out.println("=== Found Nominalizations ===");
                    System.out.println(rec.GetNominalization1() + "|" + rec.GetEui1() + "|" + rec.GetCat1() + "|" + rec.GetNominalization2() + "|" + rec.GetEui2() + "|" + rec.GetCat2());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

