/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToDerivation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Vector;

public class ToDerivationByCategory
extends Transformation
implements Cloneable {
    private static final String INFO = "DerivationByCategory";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, long outCategory, boolean detailsFlag, boolean mutateFlag) {
        String infoStr = "DerivationByCategory <" + outCategory + ">";
        Vector<LexItem> ori = ToDerivation.GetDerivations(in, conn, trie, restrictFlag, infoStr, detailsFlag, mutateFlag);
        Vector<LexItem> out = ToDerivationByCategory.RestrictOutputByCategory(ori, outCategory);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToDerivationByCategory.GetTestStr(args, "help");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = false;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToDerivationByCategory.Mutate(in, conn, trie, 1, 128L, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToDerivationByCategory.PrintResults(in, outs);
    }

    private static Vector<LexItem> RestrictOutputByCategory(Vector<LexItem> in, long category) {
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < in.size(); ++i) {
            LexItem temp = in.elementAt(i);
            if (!OutputFilter.IsRecContainCategory(temp, category)) continue;
            out.addElement(temp);
        }
        return out;
    }
}

