/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.FileEventStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    public TwoPassDataIndexer(EventStream eventStream) throws IOException {
        this(eventStream, 0);
    }

    public TwoPassDataIndexer(EventStream eventStream, int n) throws IOException {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + n + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            File file = File.createTempFile("events", null);
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            int n2 = this.computeEventCounts(eventStream, bufferedWriter, tObjectIntHashMap, n);
            System.out.println("done. " + n2 + " events");
            System.out.print("\tIndexing...  ");
            List list = this.index(n2, new FileEventStream(file), tObjectIntHashMap);
            tObjectIntHashMap = null;
            file.delete();
            System.out.println("done.");
            System.out.print("Sorting and merging events... ");
            this.sortAndMerge(list);
            System.out.println("Done indexing.");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private int computeEventCounts(EventStream eventStream, Writer writer, TObjectIntHashMap tObjectIntHashMap, int n) throws IOException {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n2 = 0;
        HashSet hashSet = new HashSet();
        while (eventStream.hasNext()) {
            Event event = eventStream.nextEvent();
            ++n2;
            writer.write(FileEventStream.toLine(event));
            String[] stringArray = event.getContext();
            TwoPassDataIndexer.update(stringArray, hashSet, tObjectIntHashMap2, n);
        }
        this.predCounts = new int[hashSet.size()];
        int n3 = 0;
        for (String string : hashSet) {
            this.predCounts[n3] = tObjectIntHashMap2.get(string);
            tObjectIntHashMap.put(string, n3);
            ++n3;
        }
        writer.close();
        return n2;
    }

    private List index(int n, EventStream eventStream, TObjectIntHashMap tObjectIntHashMap) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n2 = 0;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        TIntArrayList tIntArrayList = new TIntArrayList();
        while (eventStream.hasNext()) {
            int n3;
            Event event = eventStream.nextEvent();
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (tObjectIntHashMap2.containsKey(string)) {
                n3 = tObjectIntHashMap2.get(string);
            } else {
                n3 = n2++;
                tObjectIntHashMap2.put(string, n3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!tObjectIntHashMap.containsKey(string2)) continue;
                tIntArrayList.add(tObjectIntHashMap.get(string2));
            }
            if (tIntArrayList.size() > 0) {
                ComparableEvent comparableEvent = new ComparableEvent(n3, tIntArrayList.toNativeArray());
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            tIntArrayList.resetQuick();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(tObjectIntHashMap2);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(tObjectIntHashMap);
        return arrayList;
    }
}

