/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.maxent.io.GISModelReader;
import opennlp.maxent.io.PlainTextGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class SuffixSensitiveGISModelReader
extends GISModelReader {
    private final GISModelReader suffixAppropriateReader;

    public SuffixSensitiveGISModelReader(File file) throws IOException {
        InputStream inputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            inputStream = new GZIPInputStream(new FileInputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            inputStream = new FileInputStream(file);
        }
        this.suffixAppropriateReader = string.endsWith(".bin") ? new BinaryGISModelReader(new DataInputStream(inputStream)) : new PlainTextGISModelReader(new BufferedReader(new InputStreamReader(inputStream)));
    }

    protected int readInt() throws IOException {
        return this.suffixAppropriateReader.readInt();
    }

    protected double readDouble() throws IOException {
        return this.suffixAppropriateReader.readDouble();
    }

    protected String readUTF() throws IOException {
        return this.suffixAppropriateReader.readUTF();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 2) {
            GISModel gISModel = new SuffixSensitiveGISModelReader(new File(stringArray[0])).getModel();
            new SuffixSensitiveGISModelWriter(gISModel, new File(stringArray[1])).persist();
        } else {
            System.err.println("Usage: SuffixSensitiveGISModelReader model1 mode2");
            System.err.println("Load model1 and converts it into the model file format specified by the model2 name.");
        }
    }
}

