/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.PooledGISModelReader;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.parser.Parse;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.util.Span;

public class NameFinder {
    public static String[] NAME_TYPES = new String[]{"person", "organization", "location", "date", "time", "percentage", "money"};
    private NameFinderME nameFinder;

    public NameFinder(MaxentModel mod) {
        this.nameFinder = new NameFinderME(mod);
    }

    private static void addNames(String tag, Span[] names, Parse[] tokens) {
        int nn = names.length;
        for (int ni = 0; ni < nn; ++ni) {
            Parse[] grandKids;
            Parse endToken;
            Span nameTokenSpan = names[ni];
            Parse startToken = tokens[nameTokenSpan.getStart()];
            Parse commonParent = startToken.getCommonParent(endToken = tokens[nameTokenSpan.getEnd() - 1]);
            if (commonParent == null) continue;
            Span nameSpan = new Span(startToken.getSpan().getStart(), endToken.getSpan().getEnd());
            if (nameSpan.equals(commonParent.getSpan())) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0, endToken.getHeadIndex()));
                continue;
            }
            Parse[] kids = commonParent.getChildren();
            boolean crossingKids = false;
            int kn = kids.length;
            for (int ki = 0; ki < kn; ++ki) {
                if (!nameSpan.crosses(kids[ki].getSpan())) continue;
                crossingKids = true;
            }
            if (!crossingKids) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0, endToken.getHeadIndex()));
                continue;
            }
            if (!commonParent.getType().equals("NP") || (grandKids = kids[0].getChildren()).length <= 1 || !nameSpan.contains(grandKids[grandKids.length - 1].getSpan())) continue;
            commonParent.insert(new Parse(commonParent.getText(), commonParent.getSpan(), tag, 1.0, commonParent.getHeadIndex()));
        }
    }

    private static void clearPrevTokenMaps(NameFinder[] finders) {
        for (int mi = 0; mi < finders.length; ++mi) {
            finders[mi].nameFinder.clearAdaptiveData();
        }
    }

    private static void processParse(NameFinder[] finders, String[] tags, BufferedReader input) throws IOException {
        Span[][] nameSpans = new Span[finders.length][];
        String line = input.readLine();
        while (null != line) {
            if (line.equals("")) {
                System.out.println();
                NameFinder.clearPrevTokenMaps(finders);
            } else {
                int fi;
                Parse p = Parse.parseParse(line);
                Parse[] tagNodes = p.getTagNodes();
                String[] tokens = new String[tagNodes.length];
                for (int ti = 0; ti < tagNodes.length; ++ti) {
                    tokens[ti] = tagNodes[ti].toString();
                }
                int fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    nameSpans[fi] = finders[fi].nameFinder.find(tokens);
                }
                fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    NameFinder.addNames(tags[fi], nameSpans[fi], tagNodes);
                }
                p.show();
            }
            line = input.readLine();
        }
    }

    private static void processText(NameFinder[] finders, String[] tags, BufferedReader input) throws IOException {
        Span[][] nameSpans = new Span[finders.length][];
        String[][] nameOutcomes = new String[finders.length][];
        SimpleTokenizer tokenizer = new SimpleTokenizer();
        StringBuffer output = new StringBuffer();
        String line = input.readLine();
        while (null != line) {
            if (line.equals("")) {
                NameFinder.clearPrevTokenMaps(finders);
                System.out.println();
            } else {
                int fi;
                output.setLength(0);
                Span[] spans = tokenizer.tokenizePos(line);
                String[] tokens = Span.spansToStrings(spans, line);
                int fl = finders.length;
                for (fi = 0; fi < fl; ++fi) {
                    nameSpans[fi] = finders[fi].nameFinder.find(tokens);
                    nameOutcomes[fi] = NameFinderEventStream.generateOutcomes(nameSpans[fi], null, tokens.length);
                }
                int tl = tokens.length;
                for (int ti = 0; ti < tl; ++ti) {
                    int fi2;
                    int fl2 = finders.length;
                    for (fi2 = 0; fi2 < fl2; ++fi2) {
                        if (ti == 0 || !nameOutcomes[fi2][ti].equals("start") && !nameOutcomes[fi2][ti].equals("other") || !nameOutcomes[fi2][ti - 1].equals("start") && !nameOutcomes[fi2][ti - 1].equals("cont")) continue;
                        output.append("</").append(tags[fi2]).append(">");
                    }
                    if (ti > 0 && spans[ti - 1].getEnd() < spans[ti].getStart()) {
                        output.append(line.substring(spans[ti - 1].getEnd(), spans[ti].getStart()));
                    }
                    fl2 = finders.length;
                    for (fi2 = 0; fi2 < fl2; ++fi2) {
                        if (!nameOutcomes[fi2][ti].equals("start")) continue;
                        output.append("<").append(tags[fi2]).append(">");
                    }
                    output.append(tokens[ti]);
                }
                if (tokens.length != 0) {
                    fl = finders.length;
                    for (fi = 0; fi < fl; ++fi) {
                        if (!nameOutcomes[fi][tokens.length - 1].equals("start") && !nameOutcomes[fi][tokens.length - 1].equals("cont")) continue;
                        output.append("</").append(tags[fi]).append(">");
                    }
                }
                if (tokens.length != 0 && spans[tokens.length - 1].getEnd() < line.length()) {
                    output.append(line.substring(spans[tokens.length - 1].getEnd()));
                }
                System.out.println(output);
            }
            line = input.readLine();
        }
    }

    public static void main(String[] args) throws IOException {
        int ai;
        if (args.length == 0) {
            System.err.println("Usage NameFinder -[parse] model1 model2 ... modelN < sentences");
            System.err.println(" -parse: Use this option to find names on parsed input.  Un-tokenized sentence text is the default.");
            System.exit(1);
        }
        boolean parsedInput = false;
        for (ai = 0; args[ai].startsWith("-") && ai < args.length; ++ai) {
            if (args[ai].equals("-parse")) {
                parsedInput = true;
                continue;
            }
            System.err.println("Ignoring unknown option " + args[ai]);
        }
        NameFinder[] finders = new NameFinder[args.length - ai];
        String[] names = new String[args.length - ai];
        int fi = 0;
        while (ai < args.length) {
            String modelName = args[ai];
            finders[fi] = new NameFinder(new PooledGISModelReader(new File(modelName)).getModel());
            int nameStart = modelName.lastIndexOf(System.getProperty("file.separator")) + 1;
            int nameEnd = modelName.indexOf(46, nameStart);
            if (nameEnd == -1) {
                nameEnd = modelName.length();
            }
            names[fi] = modelName.substring(nameStart, nameEnd);
            ++ai;
            ++fi;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (parsedInput) {
            NameFinder.processParse(finders, names, in);
        } else {
            NameFinder.processText(finders, names, in);
        }
    }
}

