/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.util.Sequence;

public class ParserChunker
extends ChunkerME
implements opennlp.tools.parser.ParserChunker {
    private static final int K = 10;
    private int beamSize;
    private Map continueStartMap;

    public ParserChunker(String modelFile) throws IOException {
        this(modelFile, 10, 10);
    }

    public ParserChunker(MaxentModel model) throws IOException {
        this(model, 10, 10);
    }

    public ParserChunker(String modelFile, int beamSize, int cacheSize) throws IOException {
        super(new SuffixSensitiveGISModelReader(new File(modelFile)).getModel(), new ChunkContextGenerator(cacheSize), beamSize);
        this.beamSize = beamSize;
        this.init();
    }

    public ParserChunker(MaxentModel model, int beamSize, int cacheSize) throws IOException {
        super(model, new ChunkContextGenerator(cacheSize), beamSize);
        this.beamSize = beamSize;
        this.init();
    }

    protected void init() {
        this.continueStartMap = new HashMap(this.model.getNumOutcomes());
        int on = this.model.getNumOutcomes();
        for (int oi = 0; oi < on; ++oi) {
            String outcome = this.model.getOutcome(oi);
            if (!outcome.startsWith("C-")) continue;
            this.continueStartMap.put(outcome, "S-" + outcome.substring("C-".length()));
        }
    }

    public Sequence[] topKSequences(List sentence, List tags) {
        return this.beam.bestSequences(this.beamSize, sentence.toArray(), new Object[]{tags});
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.beam.bestSequences(this.beamSize, sentence, new Object[]{tags}, minSequenceScore);
    }

    protected boolean validOutcome(String outcome, String[] tagList) {
        if (this.continueStartMap.containsKey(outcome)) {
            int lti = tagList.length - 1;
            if (lti == -1) {
                return false;
            }
            String lastTag = tagList[lti];
            if (lastTag.equals(outcome)) {
                return true;
            }
            if (lastTag.equals(this.continueStartMap.get(outcome))) {
                return true;
            }
            if (lastTag.equals("O")) {
                return false;
            }
            return false;
        }
        return true;
    }
}

