/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.sentdetect.SentenceDetectorME;

public class SentenceDetector
extends SentenceDetectorME {
    public SentenceDetector(String modelName) throws IOException {
        super(new SuffixSensitiveGISModelReader(new File(modelName)).getModel());
        this.useTokenEnd = true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.print("Usage java opennlp.tools.lang.english.SentenceDetector model < text");
            System.exit(1);
        }
        SentenceDetector sdetector = new SentenceDetector(args[0]);
        StringBuffer para = new StringBuffer();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                if (para.length() != 0) {
                    String[] sents = sdetector.sentDetect(para.toString());
                    int sn = sents.length;
                    for (int si = 0; si < sn; ++si) {
                        System.out.println(sents[si]);
                    }
                }
                System.out.println();
                para.setLength(0);
            } else {
                para.append(line).append(" ");
            }
            line = inReader.readLine();
        }
        if (para.length() != 0) {
            String[] sents = sdetector.sentDetect(para.toString());
            int sn = sents.length;
            for (int si = 0; si < sn; ++si) {
                System.out.println(sents[si]);
            }
        }
    }
}

