/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.tools.namefind.AdditionalContextFeatureGenerator;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.NameSampleStream;
import opennlp.tools.namefind.WindowFeatureGenerator;
import opennlp.tools.util.Span;

public class NameFinderEventStream
implements EventStream {
    private NameSampleStream nameSampleStream;
    private Iterator events = Collections.EMPTY_LIST.iterator();
    private NameContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();

    public NameFinderEventStream(NameSampleStream dataStream, NameContextGenerator contextGenerator) {
        this.nameSampleStream = dataStream;
        this.contextGenerator = contextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator(this.additionalContextFeatureGenerator, 8, 8));
    }

    public NameFinderEventStream(NameSampleStream dataStream) {
        this(dataStream, new DefaultNameContextGenerator());
    }

    public static String[] generateOutcomes(Span[] names, String[] nameTypes, int length) {
        String[] outcomes = new String[length];
        for (int i = 0; i < outcomes.length; ++i) {
            outcomes[i] = "other";
        }
        for (int nameIndex = 0; nameIndex < names.length; ++nameIndex) {
            Span name = names[nameIndex];
            outcomes[name.getStart()] = nameTypes == null ? "start" : nameTypes[nameIndex] + "-" + "start";
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                if (nameTypes == null) {
                    outcomes[i] = "cont";
                    continue;
                }
                outcomes[name.getStart()] = nameTypes[nameIndex] + "-" + "cont";
            }
        }
        return outcomes;
    }

    private void createNewEvents() {
        if (this.nameSampleStream.hasNext()) {
            int i;
            NameSample sample = this.nameSampleStream.next();
            while (sample.isClearAdaptiveDataSet()) {
                this.contextGenerator.clearAdaptiveData();
                if (this.nameSampleStream.hasNext()) {
                    sample = this.nameSampleStream.next();
                    continue;
                }
                return;
            }
            String[] outcomes = NameFinderEventStream.generateOutcomes(sample.getNames(), sample.getNameTypes(), sample.getSentence().length);
            this.additionalContextFeatureGenerator.setCurrentContext(sample.getAdditionalContext());
            String[] tokens = new String[sample.getSentence().length];
            ArrayList<Event> events = new ArrayList<Event>(outcomes.length);
            for (i = 0; i < sample.getSentence().length; ++i) {
                tokens[i] = sample.getSentence()[i].getToken();
            }
            for (i = 0; i < outcomes.length; ++i) {
                events.add(new Event(outcomes[i], this.contextGenerator.getContext(i, sample.getSentence(), outcomes, null)));
            }
            this.events = events.iterator();
            this.contextGenerator.updateAdaptiveData(tokens, outcomes);
        }
    }

    public boolean hasNext() {
        if (this.events.hasNext()) {
            return true;
        }
        this.createNewEvents();
        return this.events.hasNext();
    }

    public Event nextEvent() {
        if (!this.events.hasNext()) {
            throw new NoSuchElementException();
        }
        return (Event)this.events.next();
    }

    public static String[][] additionalContext(String[] tokens, Map prevMap) {
        String[][] ac = new String[tokens.length][1];
        for (int ti = 0; ti < tokens.length; ++ti) {
            String pt = (String)prevMap.get(tokens[ti]);
            ac[ti][0] = "pd=" + pt;
        }
        return ac;
    }

    public static final void main(String[] args) throws IOException {
        if (args.length != 0) {
            System.err.println("Usage: NameFinderEventStream < training files");
            System.exit(1);
        }
        NameFinderEventStream es = new NameFinderEventStream(new NameSampleDataStream(new PlainTextByLineDataStream(new InputStreamReader(System.in))));
        while (es.hasNext()) {
            System.out.println(es.nextEvent());
        }
    }
}

