/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.namefind.AdditionalContextFeatureGenerator;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.WindowFeatureGenerator;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.Span;

public class NameFinderME
implements TokenNameFinder {
    private static String[][] EMPTY = new String[0][0];
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    protected MaxentModel model;
    protected NameContextGenerator contextGenerator;
    private Sequence bestSequence;
    private BeamSearch beam;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();

    public NameFinderME(MaxentModel mod) {
        this(mod, new DefaultNameContextGenerator(), 3);
    }

    public NameFinderME(MaxentModel mod, NameContextGenerator cg) {
        this(mod, cg, 3);
    }

    public NameFinderME(MaxentModel mod, NameContextGenerator cg, int beamSize) {
        this.model = mod;
        this.contextGenerator = cg;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator(this.additionalContextFeatureGenerator, 8, 8));
        this.beam = new NameBeamSearch(beamSize, cg, mod, beamSize);
    }

    public Span[] find(String[] tokens) {
        return this.find(tokens, EMPTY);
    }

    public Span[] find(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.beam.bestSequence(tokens, (Object[])additionalContext);
        List c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(tokens.length);
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = (String)c.get(li);
            if (chunkTag.equals(START)) {
                if (start != -1) {
                    spans.add(new Span(start, end));
                }
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.equals(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (!chunkTag.equals(OTHER) || start == -1) continue;
            spans.add(new Span(start, end));
            start = -1;
            end = -1;
        }
        if (start != -1) {
            spans.add(new Span(start, end));
        }
        return spans.toArray(new Span[spans.size()]);
    }

    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public double[] probs(Span[] spans) {
        double[] sprobs = new double[spans.length];
        double[] probs = this.bestSequence.getProbs();
        for (int si = 0; si < spans.length; ++si) {
            double p = 1.0;
            for (int oi = spans[si].getStart(); oi < spans[si].getEnd(); ++oi) {
                p *= probs[oi];
            }
            sprobs[si] = p;
        }
        return sprobs;
    }

    public static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel(iterations, new TwoPassDataIndexer(es, cut));
    }

    public static void usage() {
        System.err.println("Usage: opennlp.tools.namefind.NameFinderME -encoding encoding training_file model");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            NameFinderME.usage();
        }
        int ai = 0;
        String encoding = null;
        while (args[ai].startsWith("-")) {
            if (args[ai].equals("-encoding") && ai + 1 < args.length) {
                encoding = args[++ai];
            } else {
                System.err.println("Unknown option: " + args[ai]);
                NameFinderME.usage();
            }
            ++ai;
        }
        File inFile = null;
        File outFile = null;
        if (ai < args.length) {
            inFile = new File(args[ai++]);
        } else {
            NameFinderME.usage();
        }
        if (ai < args.length) {
            outFile = new File(args[ai++]);
        } else {
            NameFinderME.usage();
        }
        int iterations = 100;
        int cutoff = 5;
        if (args.length > ai) {
            iterations = Integer.parseInt(args[ai++]);
        }
        if (args.length > ai) {
            cutoff = Integer.parseInt(args[ai++]);
        }
        NameFinderEventStream es = encoding != null ? new NameFinderEventStream(new NameSampleDataStream(new PlainTextByLineDataStream(new InputStreamReader((InputStream)new FileInputStream(inFile), encoding)))) : new NameFinderEventStream(new NameSampleDataStream(new PlainTextByLineDataStream(new FileReader(inFile))));
        GISModel mod = NameFinderME.train(es, iterations, cutoff);
        System.out.println("Saving the model as: " + outFile.toString());
        new SuffixSensitiveGISModelWriter(mod, outFile).persist();
    }

    private class NameBeamSearch
    extends BeamSearch {
        public NameBeamSearch(int size, NameContextGenerator cg, MaxentModel model, int beamSize) {
            super(size, cg, model, beamSize);
        }

        protected boolean validSequence(int size, Object[] inputSequence, String[] outcomesSequence, String outcome) {
            if (outcome.equals(NameFinderME.CONTINUE)) {
                int li = outcomesSequence.length - 1;
                if (li == -1) {
                    return false;
                }
                if (outcomesSequence[li].equals(NameFinderME.OTHER)) {
                    return false;
                }
            }
            return true;
        }
    }
}

