/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import opennlp.maxent.DataStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.ngram.Token;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserChunker;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserTagger;
import opennlp.tools.parser.chunking.BuildContextGenerator;
import opennlp.tools.parser.chunking.CheckContextGenerator;
import opennlp.tools.parser.chunking.ParserEventStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Span;

public class Parser
extends AbstractBottomUpParser {
    private MaxentModel buildModel;
    private MaxentModel checkModel;
    private BuildContextGenerator buildContextGenerator;
    private CheckContextGenerator checkContextGenerator;
    private double[] bprobs;
    private double[] cprobs;
    private static final String TOP_START = "S-TOP";
    private int topStartIndex;
    private Map startTypeMap;
    private Map contTypeMap;
    private int completeIndex;
    private int incompleteIndex;

    public Parser(MaxentModel buildModel, MaxentModel checkModel, ParserTagger tagger, ParserChunker chunker, HeadRules headRules) {
        this(buildModel, checkModel, tagger, chunker, headRules, 20, 0.95);
    }

    public Parser(MaxentModel buildModel, MaxentModel checkModel, ParserTagger tagger, ParserChunker chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        super(tagger, chunker, headRules, beamSize, advancePercentage);
        this.buildModel = buildModel;
        this.checkModel = checkModel;
        this.bprobs = new double[buildModel.getNumOutcomes()];
        this.cprobs = new double[checkModel.getNumOutcomes()];
        this.buildContextGenerator = new BuildContextGenerator();
        this.checkContextGenerator = new CheckContextGenerator();
        this.startTypeMap = new HashMap();
        this.contTypeMap = new HashMap();
        int bon = buildModel.getNumOutcomes();
        for (int boi = 0; boi < bon; ++boi) {
            String outcome = buildModel.getOutcome(boi);
            if (outcome.startsWith("S-")) {
                this.startTypeMap.put(outcome, outcome.substring("S-".length()));
                continue;
            }
            if (!outcome.startsWith("C-")) continue;
            this.contTypeMap.put(outcome, outcome.substring("C-".length()));
        }
        this.topStartIndex = buildModel.getIndex(TOP_START);
        this.completeIndex = checkModel.getIndex("c");
        this.incompleteIndex = checkModel.getIndex("i");
    }

    protected void advanceTop(Parse p) {
        this.buildModel.eval(this.buildContextGenerator.getContext(p.getChildren(), 0), this.bprobs);
        p.addProb(Math.log(this.bprobs[this.topStartIndex]));
        this.checkModel.eval(this.checkContextGenerator.getContext(p.getChildren(), "TOP", 0, 0), this.cprobs);
        p.addProb(Math.log(this.cprobs[this.completeIndex]));
        p.setType("TOP");
    }

    protected Parse[] advanceParses(Parse p, double probMass) {
        int advanceNodeIndex;
        double q = 1.0 - probMass;
        Parse lastStartNode = null;
        int lastStartIndex = -1;
        String lastStartType = null;
        Parse advanceNode = null;
        Parse[] originalChildren = p.getChildren();
        Parse[] children = Parser.collapsePunctuation(originalChildren, this.punctSet);
        int numNodes = children.length;
        if (numNodes == 0) {
            return null;
        }
        for (advanceNodeIndex = 0; advanceNodeIndex < numNodes && (advanceNode = children[advanceNodeIndex]).getLabel() != null; ++advanceNodeIndex) {
            if (!this.startTypeMap.containsKey(advanceNode.getLabel())) continue;
            lastStartType = (String)this.startTypeMap.get(advanceNode.getLabel());
            lastStartNode = advanceNode;
            lastStartIndex = advanceNodeIndex;
        }
        int originalAdvanceIndex = this.mapParseIndex(advanceNodeIndex, children, originalChildren);
        ArrayList<Parse> newParsesList = new ArrayList<Parse>(this.buildModel.getNumOutcomes());
        this.buildModel.eval(this.buildContextGenerator.getContext(children, advanceNodeIndex), this.bprobs);
        double bprobSum = 0.0;
        while (bprobSum < probMass) {
            int max = 0;
            for (int pi = 1; pi < this.bprobs.length; ++pi) {
                if (!(this.bprobs[pi] > this.bprobs[max])) continue;
                max = pi;
            }
            if (this.bprobs[max] == 0.0) break;
            double bprob = this.bprobs[max];
            this.bprobs[max] = 0.0;
            bprobSum += bprob;
            String tag = this.buildModel.getOutcome(max);
            if (max == this.topStartIndex) continue;
            if (this.startTypeMap.containsKey(tag)) {
                lastStartIndex = advanceNodeIndex;
                lastStartNode = advanceNode;
                lastStartType = (String)this.startTypeMap.get(tag);
            } else if (this.contTypeMap.containsKey(tag) && (lastStartNode == null || !lastStartType.equals(this.contTypeMap.get(tag)))) continue;
            Parse newParse1 = (Parse)p.clone();
            if (this.createDerivationString) {
                newParse1.getDerivation().append(max).append("-");
            }
            newParse1.setChild(originalAdvanceIndex, tag);
            newParse1.addProb(Math.log(bprob));
            this.checkModel.eval(this.checkContextGenerator.getContext(Parser.collapsePunctuation(newParse1.getChildren(), this.punctSet), lastStartType, lastStartIndex, advanceNodeIndex), this.cprobs);
            Parse newParse2 = newParse1;
            if (this.cprobs[this.completeIndex] > q) {
                newParse2 = (Parse)newParse1.clone();
                if (this.createDerivationString) {
                    newParse2.getDerivation().append(1).append(".");
                }
                newParse2.addProb(Math.log(this.cprobs[this.completeIndex]));
                Parse[] cons = new Parse[advanceNodeIndex - lastStartIndex + 1];
                boolean flat = true;
                cons[0] = lastStartNode;
                flat &= cons[0].isPosTag();
                cons[advanceNodeIndex - lastStartIndex] = advanceNode;
                flat &= cons[advanceNodeIndex - lastStartIndex].isPosTag();
                for (int ci = 1; ci < advanceNodeIndex - lastStartIndex; ++ci) {
                    cons[ci] = children[ci + lastStartIndex];
                    flat &= cons[ci].isPosTag();
                }
                if (!flat) {
                    if (lastStartIndex == 0 && advanceNodeIndex == numNodes - 1) {
                        newParse2.insert(new Parse(p.getText(), p.getSpan(), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    } else {
                        newParse2.insert(new Parse(p.getText(), new Span(lastStartNode.getSpan().getStart(), advanceNode.getSpan().getEnd()), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    }
                    newParsesList.add(newParse2);
                }
            }
            if (!(this.cprobs[this.incompleteIndex] > q)) continue;
            if (this.createDerivationString) {
                newParse1.getDerivation().append(0).append(".");
            }
            if (advanceNodeIndex == numNodes - 1) continue;
            newParse1.addProb(Math.log(this.cprobs[this.incompleteIndex]));
            newParsesList.add(newParse1);
        }
        Parse[] newParses = new Parse[newParsesList.size()];
        newParsesList.toArray(newParses);
        return newParses;
    }

    public static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel(iterations, new TwoPassDataIndexer(es, cut));
    }

    private static boolean lastChild(Parse child, Parse parent, Set punctSet) {
        Parse[] kids = Parser.collapsePunctuation(parent.getChildren(), punctSet);
        return kids[kids.length - 1] == child;
    }

    private static void usage() {
        System.err.println("Usage: Parser -[dict|tag|chunk|build|check|fun] trainingFile parserModelDirectory [iterations cutoff]");
        System.err.println();
        System.err.println("Training file should be one sentence per line where each line consists of a Penn Treebank Style parse");
        System.err.println("-dict Just build the dictionaries.");
        System.err.println("-tag Just build the tagging model.");
        System.err.println("-chunk Just build the chunking model.");
        System.err.println("-build Just build the build model");
        System.err.println("-check Just build the check model");
        System.err.println("-fun Predict function tags");
    }

    private static Dictionary buildDictionary(DataStream data, HeadRules rules, int cutoff) {
        NGramModel mdict = new NGramModel();
        while (data.hasNext()) {
            String parseStr = (String)data.nextToken();
            Parse p = Parse.parseParse(parseStr);
            p.updateHeads(rules);
            Parse[] pwords = p.getTagNodes();
            String[] words = new String[pwords.length];
            for (int wi = 0; wi < words.length; ++wi) {
                words[wi] = pwords[wi].toString();
            }
            mdict.add(Token.create(words), 1, 1);
            Parse[] chunks = Parser.collapsePunctuation(ParserEventStream.getInitialChunks(p), rules.getPunctuationTags());
            String[] cwords = new String[chunks.length];
            for (int wi = 0; wi < cwords.length; ++wi) {
                cwords[wi] = chunks[wi].getHead().toString();
            }
            mdict.add(Token.create(cwords), 2, 3);
            for (int ci = 0; ci < chunks.length; ++ci) {
                int reduceStart;
                if (!Parser.lastChild(chunks[ci], chunks[ci].getParent(), rules.getPunctuationTags())) continue;
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == chunks[ci].getParent(); --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, chunks[ci].getParent());
                ci = ++reduceStart;
                if (chunks.length != 0) {
                    String[] window = new String[5];
                    int wi = 0;
                    if (ci - 2 >= 0) {
                        window[wi++] = chunks[ci - 2].getHead().toString();
                    }
                    if (ci - 1 >= 0) {
                        window[wi++] = chunks[ci - 1].getHead().toString();
                    }
                    window[wi++] = chunks[ci].getHead().toString();
                    if (ci + 1 < chunks.length) {
                        window[wi++] = chunks[ci + 1].getHead().toString();
                    }
                    if (ci + 2 < chunks.length) {
                        window[wi++] = chunks[ci + 2].getHead().toString();
                    }
                    if (wi < 5) {
                        String[] subWindow = new String[wi];
                        for (int swi = 0; swi < wi; ++swi) {
                            subWindow[swi] = window[swi];
                        }
                        window = subWindow;
                    }
                    if (window.length >= 3) {
                        mdict.add(Token.create(window), 2, 3);
                    } else if (window.length == 2) {
                        mdict.add(Token.create(window), 2, 2);
                    }
                }
                ci = reduceStart - 1;
            }
        }
        mdict.cutoff(cutoff, Integer.MAX_VALUE);
        return mdict.toDictionary(true);
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        if (args.length < 3) {
            Parser.usage();
            System.exit(1);
        }
        boolean dict = false;
        boolean tag = false;
        boolean chunk = false;
        boolean build = false;
        boolean check = false;
        boolean fun = false;
        boolean all = true;
        int argIndex = 0;
        while (args[argIndex].startsWith("-")) {
            all = false;
            if (args[argIndex].equals("-dict")) {
                dict = true;
            } else if (args[argIndex].equals("-tag")) {
                tag = true;
            } else if (args[argIndex].equals("-chunk")) {
                chunk = true;
            } else if (args[argIndex].equals("-build")) {
                build = true;
            } else if (args[argIndex].equals("-check")) {
                check = true;
            } else if (args[argIndex].equals("-fun")) {
                fun = true;
            } else {
                if (args[argIndex].equals("--")) break;
                System.err.println("Invalid option " + args[argIndex]);
                Parser.usage();
                System.exit(1);
            }
            ++argIndex;
        }
        int n = ++argIndex;
        File inFile = new File(args[n]);
        int n2 = ++argIndex;
        ++argIndex;
        String modelDirectory = args[n2];
        opennlp.tools.lang.english.HeadRules rules = new opennlp.tools.lang.english.HeadRules(modelDirectory + "/head_rules");
        File dictFile = new File(modelDirectory + "/dict.bin.gz");
        File tagFile = new File(modelDirectory + "/tag.bin.gz");
        File chunkFile = new File(modelDirectory + "/chunk.bin.gz");
        File buildFile = new File(modelDirectory + "/build.bin.gz");
        File checkFile = new File(modelDirectory + "/check.bin.gz");
        int iterations = 100;
        int cutoff = 5;
        if (args.length > argIndex) {
            iterations = Integer.parseInt(args[argIndex++]);
            cutoff = Integer.parseInt(args[argIndex++]);
        }
        if (fun) {
            Parse.useFunctionTags(true);
        }
        if (dict || all) {
            System.err.println("Building dictionary");
            PlainTextByLineDataStream data = new PlainTextByLineDataStream(new FileReader(inFile));
            Dictionary mdict = Parser.buildDictionary(data, rules, cutoff);
            System.out.println("Saving the dictionary");
            mdict.serialize(new FileOutputStream(dictFile));
        }
        if (tag || all) {
            System.err.println("Training tagger");
            ParserEventStream tes = new ParserEventStream(new PlainTextByLineDataStream(new FileReader(inFile)), rules, ParserEventTypeEnum.TAG);
            GISModel tagModel = Parser.train(tes, iterations, cutoff);
            System.out.println("Saving the tagger model as: " + tagFile);
            new SuffixSensitiveGISModelWriter(tagModel, tagFile).persist();
        }
        if (chunk || all) {
            System.err.println("Training chunker");
            ParserEventStream ces = new ParserEventStream(new PlainTextByLineDataStream(new FileReader(inFile)), rules, ParserEventTypeEnum.CHUNK);
            GISModel chunkModel = Parser.train(ces, iterations, cutoff);
            System.out.println("Saving the chunker model as: " + chunkFile);
            new SuffixSensitiveGISModelWriter(chunkModel, chunkFile).persist();
        }
        if (build || all) {
            System.err.println("Loading Dictionary");
            Dictionary tridict = new Dictionary(new FileInputStream(dictFile.toString()), true);
            System.err.println("Training builder");
            ParserEventStream bes = new ParserEventStream(new PlainTextByLineDataStream(new FileReader(inFile)), rules, ParserEventTypeEnum.BUILD, tridict);
            GISModel buildModel = Parser.train(bes, iterations, cutoff);
            System.out.println("Saving the build model as: " + buildFile);
            new SuffixSensitiveGISModelWriter(buildModel, buildFile).persist();
        }
        if (check || all) {
            System.err.println("Training checker");
            ParserEventStream kes = new ParserEventStream(new PlainTextByLineDataStream(new FileReader(inFile)), rules, ParserEventTypeEnum.CHECK);
            GISModel checkModel = Parser.train(kes, iterations, cutoff);
            System.out.println("Saving the check model as: " + checkFile);
            new SuffixSensitiveGISModelWriter(checkModel, checkFile).persist();
        }
    }
}

