/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci.util;

import org.apache.uima.adapter.vinci.util.SaxVinciFrameBuilder;
import org.xml.sax.Attributes;

public class UimaSaxVinciFrameBuilder
extends SaxVinciFrameBuilder {
    private boolean mSupressDocumentText;
    private boolean mIncludeSpannedTextInAnnotations;
    private String mDocText;

    public UimaSaxVinciFrameBuilder(boolean aSupressDocumentText, boolean aIncludeSpannedTextInAnnotations, String aDocText) {
        this.mSupressDocumentText = aSupressDocumentText;
        this.mIncludeSpannedTextInAnnotations = aIncludeSpannedTextInAnnotations;
        this.mDocText = aDocText;
    }

    protected String getLeafContent(String aFrameName, Attributes aAttributes, StringBuffer aContentBuf) {
        if ("uima.tcas.Document".equals(aFrameName) || "uima.tcas.DocumentAnnotation".equals(aFrameName)) {
            if (this.mSupressDocumentText) {
                return "";
            }
        } else if (this.mIncludeSpannedTextInAnnotations && aContentBuf.length() == 0 && this.mDocText != null) {
            String begin = aAttributes.getValue("begin");
            String end = aAttributes.getValue("end");
            if (begin != null && end != null) {
                try {
                    int b = Integer.parseInt(begin);
                    int e = Integer.parseInt(end);
                    return this.mDocText.substring(b, e);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return super.getLeafContent(aFrameName, aAttributes, aContentBuf);
    }
}

