/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSBagIndex;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIntArrayIndex;
import org.apache.uima.cas.impl.FSIteratorAggregate;
import org.apache.uima.cas.impl.FSIteratorWrapper;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FSRBTSetIndex;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LLUnambiguousIteratorImpl;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.SortedIntSet;

public class FSIndexRepositoryImpl
implements FSIndexRepositoryMgr,
LowLevelIndexRepository {
    public static final int DEFAULT_INDEX_SIZE = 100;
    private CASImpl cas;
    private TypeSystemImpl typeSystem;
    private boolean locked = false;
    private ArrayList[] indexArray;
    int[] detectIllegalIndexUpdates;
    private HashMap name2indexMap;
    private LinearTypeOrderBuilder defaultOrderBuilder = null;
    private LinearTypeOrder defaultTypeOrder = null;

    private FSIndexRepositoryImpl() {
    }

    FSIndexRepositoryImpl(CASImpl cas) {
        this.cas = cas;
        this.typeSystem = cas.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.init();
    }

    FSIndexRepositoryImpl(CASImpl cas, FSIndexRepositoryImpl baseIndexRepo) {
        this.cas = cas;
        this.typeSystem = cas.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.init();
        Set keys = baseIndexRepo.name2indexMap.keySet();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                IndexIteratorCachePair iicp = (IndexIteratorCachePair)baseIndexRepo.name2indexMap.get(key);
                this.createIndexNoQuestionsAsked(iicp.index.getComparator(), key, iicp.index.getIndexingStrategy());
            }
        }
        this.defaultOrderBuilder = baseIndexRepo.defaultOrderBuilder;
        this.defaultTypeOrder = baseIndexRepo.defaultTypeOrder;
    }

    private void init() {
        int i;
        TypeSystemImpl ts = this.typeSystem;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.indexArray = new ArrayList[numTypes];
        for (i = 1; i < numTypes; ++i) {
            this.indexArray[i] = new ArrayList();
        }
        this.detectIllegalIndexUpdates = new int[numTypes];
        for (i = 0; i < this.detectIllegalIndexUpdates.length; ++i) {
            this.detectIllegalIndexUpdates[i] = Integer.MIN_VALUE;
        }
    }

    public void flush() {
        if (!this.locked) {
            return;
        }
        for (int i = 1; i < this.indexArray.length; ++i) {
            ArrayList v = this.indexArray[i];
            int max = v.size();
            for (int j = 0; j < max; ++j) {
                ((IndexIteratorCachePair)v.get(j)).index.flush();
            }
        }
    }

    public void addFS(int fsRef) {
        this.ll_addFS(fsRef);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator comparator, int indexType) {
        return this.addNewIndex(comparator, 100, indexType);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator comparator, int initialSize, int indexType) {
        FSLeafIndexImpl ind;
        Type type = comparator.getType();
        int typeCode = ((TypeImpl)type).getCode();
        if (typeCode >= this.indexArray.length) {
            // empty if block
        }
        ArrayList indexVector = this.indexArray[typeCode];
        switch (indexType) {
            case 1: {
                ind = new FSRBTSetIndex(this.cas, type, indexType);
                break;
            }
            case 2: {
                ind = new FSBagIndex(this.cas, type, initialSize, indexType);
                break;
            }
            case 3: {
                ind = new FSBagIndex(this.cas, type, initialSize, indexType);
                break;
            }
            default: {
                ind = new FSIntArrayIndex(this.cas, type, initialSize, 0);
            }
        }
        ind.init(comparator);
        IndexIteratorCachePair iicp = new IndexIteratorCachePair();
        iicp.index = ind;
        indexVector.add(iicp);
        return iicp;
    }

    private IndexIteratorCachePair addNewIndexRecursive(FSIndexComparator comparator, int indexType) {
        FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
        return this.addNewIndexRec(compCopy, indexType);
    }

    private static final int findIndex(ArrayList indexes, FSIndexComparator comp) {
        int max = indexes.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparator indexComp = ((IndexIteratorCachePair)indexes.get(i)).index.getComparator();
            if (!((Object)comp).equals(indexComp)) continue;
            return i;
        }
        return -1;
    }

    private IndexIteratorCachePair addNewIndexRec(FSIndexComparator comparator, int indexType) {
        IndexIteratorCachePair iicp = this.addNewIndex(comparator, indexType);
        if (indexType == 3) {
            return iicp;
        }
        Type superType = comparator.getType();
        Vector types = this.typeSystem.getDirectlySubsumedTypes(superType);
        int max = types.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
            compCopy.setType((Type)types.get(i));
            this.addNewIndexRec(compCopy, indexType);
        }
        return iicp;
    }

    private static final ArrayList getAllSubsumedTypes(Type t, TypeSystem ts) {
        ArrayList v = new ArrayList();
        FSIndexRepositoryImpl.addAllSubsumedTypes(t, ts, v);
        return v;
    }

    private static final void addAllSubsumedTypes(Type t, TypeSystem ts, ArrayList v) {
        v.add(t);
        List sub = ts.getDirectSubtypes(t);
        int len = sub.size();
        for (int i = 0; i < len; ++i) {
            FSIndexRepositoryImpl.addAllSubsumedTypes((Type)sub.get(i), ts, v);
        }
    }

    public void commit() {
        this.getDefaultTypeOrder();
        this.locked = true;
    }

    public LinearTypeOrder getDefaultTypeOrder() {
        if (this.defaultTypeOrder == null) {
            if (this.defaultOrderBuilder == null) {
                this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
            }
            try {
                this.defaultTypeOrder = this.defaultOrderBuilder.getOrder();
            }
            catch (CASException cASException) {
                // empty catch block
            }
        }
        return this.defaultTypeOrder;
    }

    public LinearTypeOrderBuilder getDefaultOrderBuilder() {
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
        }
        return this.defaultOrderBuilder;
    }

    void setDefaultTypeOrder(LinearTypeOrder order) {
        this.defaultTypeOrder = order;
    }

    public boolean createIndex(FSIndexComparator comp, String label, int indexType) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(0);
        }
        return this.createIndexNoQuestionsAsked(comp, label, indexType);
    }

    public boolean createIndexNoQuestionsAsked(FSIndexComparator comp, String label, int indexType) {
        IndexIteratorCachePair cp = (IndexIteratorCachePair)this.name2indexMap.get(label);
        if (cp == null) {
            cp = this.addNewIndexRecursive(comp, indexType);
            this.name2indexMap.put(label, cp);
            return true;
        }
        return false;
    }

    public Iterator getIndexes() {
        ArrayList<FSIndex> indexList = new ArrayList<FSIndex>();
        Iterator it = this.getLabels();
        while (it.hasNext()) {
            String label = (String)it.next();
            indexList.add(this.getIndex(label));
        }
        return indexList.iterator();
    }

    public Iterator getLabels() {
        return this.name2indexMap.keySet().iterator();
    }

    public Iterator getLabels(FSIndexComparator comp) {
        ArrayList<String> labels = new ArrayList<String>();
        Iterator it = this.getLabels();
        while (it.hasNext()) {
            String label = (String)it.next();
            if (!((Object)((IndexIteratorCachePair)this.name2indexMap.get(label)).index.getComparator()).equals(comp)) continue;
            labels.add(label);
        }
        return labels.iterator();
    }

    public FSIndex getIndex(String label, Type type) {
        Type componentType;
        IndexIteratorCachePair iicp = (IndexIteratorCachePair)this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        if (type.isArray() && (componentType = type.getComponentType()) != null && !componentType.isPrimitive() && !componentType.getName().equals("uima.cas.TOP")) {
            return null;
        }
        Type indexType = iicp.index.getType();
        if (!this.typeSystem.subsumes(indexType, type)) {
            CASRuntimeException cre = new CASRuntimeException("TYPE_NOT_IN_INDEX", new String[]{label, type.getName(), indexType.getName()});
            throw cre;
        }
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList inds = this.indexArray[typeCode];
        int indexCode = FSIndexRepositoryImpl.findIndex(inds, iicp.index.getComparator());
        if (indexCode < 0) {
            return null;
        }
        return new IndexImpl((IndexIteratorCachePair)inds.get(indexCode));
    }

    public FSIndex getIndex(String label) {
        IndexIteratorCachePair iicp = (IndexIteratorCachePair)this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        return new IndexImpl(iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label) {
        IndexImpl index = (IndexImpl)this.getIndex(label);
        if (index == null) {
            return null;
        }
        return new PointerIterator(index.iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label, Type type) {
        IndexImpl index = (IndexImpl)this.getIndex(label, type);
        if (index == null) {
            return null;
        }
        return new PointerIterator(index.iicp);
    }

    public int getIndexSize(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList indexVector = this.indexArray[typeCode];
        if (indexVector.size() == 0) {
            return 0;
        }
        int numFSs = ((IndexIteratorCachePair)indexVector.get(0)).index.size();
        Vector typeVector = this.typeSystem.getDirectlySubsumedTypes(type);
        int max = typeVector.size();
        for (int i = 0; i < max; ++i) {
            numFSs += this.getIndexSize((Type)typeVector.get(i));
        }
        return numFSs;
    }

    public FSIndexComparator createComparator() {
        return new FSIndexComparatorImpl(this.cas);
    }

    public boolean isCommitted() {
        return this.locked;
    }

    public boolean createIndex(FSIndexComparator comp, String label) throws CASAdminException {
        return this.createIndex(comp, label, 0);
    }

    public int[] getIndexedFSs() {
        IntVector v = new IntVector();
        for (int i = 0; i < this.indexArray.length; ++i) {
            int k;
            ArrayList iv = this.indexArray[i];
            if (iv == null) continue;
            int jMax = iv.size();
            ArrayList<IndexIteratorCachePair> cv = new ArrayList<IndexIteratorCachePair>();
            for (int j = 0; j < jMax; ++j) {
                IndexIteratorCachePair iicp = (IndexIteratorCachePair)iv.get(j);
                int indStrat = iicp.index.getIndexingStrategy();
                if (indStrat != 1) {
                    if (cv.size() > 0) {
                        cv = new ArrayList();
                    }
                    cv.add(iicp);
                    break;
                }
                cv.add(iicp);
            }
            if (cv.size() <= 0) continue;
            SortedIntSet set = new SortedIntSet();
            for (k = 0; k < cv.size(); ++k) {
                IntPointerIterator it = ((IndexIteratorCachePair)cv.get(k)).index.refIterator();
                while (it.isValid()) {
                    set.add(it.get());
                    it.inc();
                }
            }
            for (k = 0; k < set.size(); ++k) {
                v.add(set.get(k));
            }
        }
        return v.toArray();
    }

    public void addFS(FeatureStructure fs) {
        this.addFS(((FeatureStructureImpl)fs).getAddress());
    }

    private void incrementIllegalIndexUpdateDetector(int typeCode) {
        int n = typeCode;
        this.detectIllegalIndexUpdates[n] = this.detectIllegalIndexUpdates[n] + 1;
    }

    public void removeFS(FeatureStructure fs) {
        this.ll_removeFS(this.cas.ll_getFSRef(fs));
    }

    public LinearTypeOrderBuilder createTypeSortOrder() {
        LinearTypeOrderBuilderImpl orderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = orderBuilder;
        }
        return orderBuilder;
    }

    public LowLevelIndex ll_getIndex(String indexName) {
        return (LowLevelIndex)((Object)this.getIndex(indexName));
    }

    public LowLevelIndex ll_getIndex(String indexName, int typeCode) {
        if (!this.typeSystem.isType(typeCode) || !this.cas.ll_isRefType(typeCode)) {
            LowLevelException e = new LowLevelException(10);
            e.addArgument(Integer.toString(typeCode));
            throw e;
        }
        return (LowLevelIndex)((Object)this.getIndex(indexName, this.typeSystem.ll_getTypeForCode(typeCode)));
    }

    public final void ll_addFS(int fsRef, boolean doChecks) {
        if (doChecks) {
            this.cas.checkFsRef(fsRef);
            this.cas.ll_isRefType(this.cas.ll_getFSRefType(fsRef));
        }
        this.ll_addFS(fsRef);
    }

    public void ll_addFS(int fsRef) {
        int typeCode = this.cas.getHeapValue(fsRef);
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList indexes = this.indexArray[typeCode];
        int size = indexes.size();
        for (int i = 0; i < size; ++i) {
            ((IndexIteratorCachePair)indexes.get(i)).index.insert(fsRef);
        }
        if (size == 0) {
            Type type = this.typeSystem.ll_getTypeForCode(typeCode);
            String defIndexName = FSIndexRepositoryImpl.getAutoIndexNameForType(type);
            FSIndexComparator comparator = this.createComparator();
            comparator.setType(type);
            this.createIndexNoQuestionsAsked(comparator, defIndexName, 3);
            assert (this.indexArray[typeCode].size() == 1);
            ((IndexIteratorCachePair)this.indexArray[typeCode].get(0)).index.insert(fsRef);
        }
    }

    private static final String getAutoIndexNameForType(Type type) {
        return "_" + type.getName() + "_GeneratedIndex";
    }

    public void ll_removeFS(int fsRef) {
        int typeCode = this.cas.ll_getFSRefType(fsRef);
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList idxList = this.indexArray[typeCode];
        int max = idxList.size();
        for (int i = 0; i < max; ++i) {
            ((IndexIteratorCachePair)idxList.get(i)).index.remove(fsRef);
        }
    }

    public FSIterator getAllIndexedFS(Type type) {
        ArrayList iteratorList = new ArrayList();
        this.getAllIndexedFS(type, iteratorList);
        return new FSIteratorAggregate(iteratorList);
    }

    private final void getAllIndexedFS(Type type, List iteratorList) {
        FSIndex autoIndex = this.getIndex(FSIndexRepositoryImpl.getAutoIndexNameForType(type));
        if (autoIndex != null) {
            iteratorList.add(autoIndex.iterator());
            List subtypes = this.typeSystem.getDirectSubtypes(type);
            for (int i = 0; i < subtypes.size(); ++i) {
                this.getAllIndexedFS((Type)subtypes.get(i), iteratorList);
            }
            return;
        }
        FSIndex setIndex = null;
        Iterator iter = this.getLabels();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            FSIndex index = this.getIndex(label);
            if (index.getIndexingStrategy() == 3 || !this.typeSystem.subsumes(index.getType(), type)) continue;
            if (index.getIndexingStrategy() != 1) {
                iteratorList.add(this.getIndex(label, type).iterator());
                return;
            }
            setIndex = this.getIndex(label, type);
        }
        if (setIndex != null) {
            iteratorList.add(setIndex.iterator());
            return;
        }
        List subtypes = this.typeSystem.getDirectSubtypes(type);
        for (int i = 0; i < subtypes.size(); ++i) {
            this.getAllIndexedFS((Type)subtypes.get(i), iteratorList);
        }
    }

    private class IndexImpl
    implements FSIndex,
    FSIndexImpl {
        private IndexIteratorCachePair iicp;

        private IndexImpl(IndexIteratorCachePair iicp) {
            this.iicp = iicp;
        }

        public int ll_compare(int ref1, int ref2) {
            return this.iicp.index.ll_compare(ref1, ref2);
        }

        public int getIndexingStrategy() {
            return this.iicp.index.getIndexingStrategy();
        }

        public FSIndexComparator getComparator() {
            return this.iicp.index.getComparator();
        }

        protected IntComparator getIntComparator() {
            return this.iicp.index.getIntComparator();
        }

        public void flush() {
            this.iicp.index.flush();
        }

        public int compare(FeatureStructure fs1, FeatureStructure fs2) {
            return this.iicp.index.compare(fs1, fs2);
        }

        public boolean contains(FeatureStructure fs) {
            return this.iicp.index.contains(fs);
        }

        public FeatureStructure find(FeatureStructure fs) {
            return this.iicp.index.find(fs);
        }

        public Type getType() {
            return this.iicp.index.getType();
        }

        public FSIterator iterator() {
            return new FSIteratorWrapper(new PointerIterator(this.iicp), FSIndexRepositoryImpl.this.cas);
        }

        public FSIterator iterator(FeatureStructure fs) {
            return new FSIteratorWrapper(new PointerIterator(this.iicp, ((FeatureStructureImpl)fs).getAddress()), FSIndexRepositoryImpl.this.cas);
        }

        public IntPointerIterator getIntIterator() {
            return new PointerIterator(this.iicp);
        }

        public int size() {
            this.iicp.createIndexIteratorCache();
            int size = 0;
            ArrayList subIndex = this.iicp.iteratorCache;
            int max = subIndex.size();
            for (int i = 0; i < max; ++i) {
                size += ((FSIndex)subIndex.get(i)).size();
            }
            return size;
        }

        public LowLevelIterator ll_iterator() {
            return new PointerIterator(this.iicp);
        }

        public LowLevelIterator ll_iterator(boolean ambiguous) {
            if (ambiguous) {
                return this.ll_iterator();
            }
            return new LLUnambiguousIteratorImpl(this.ll_iterator(), ((IndexIteratorCachePair)this.iicp).index.lowLevelCAS);
        }
    }

    private class PointerIterator
    implements IntPointerIterator,
    LowLevelIterator {
        private IndexIteratorCachePair iicp;
        private ComparableIntPointerIterator[] indexes;
        private int indexesSize;
        private int numIndexes;
        private int currentIndex;
        private boolean wentForward;
        private IntComparator iteratorComparator;

        private PointerIterator() {
        }

        private void initPointerIterator(IndexIteratorCachePair iicp0) {
            this.iicp = iicp0;
            iicp0.createIndexIteratorCache();
            ArrayList iteratorCache = iicp0.iteratorCache;
            this.indexesSize = iteratorCache.size();
            this.indexes = new ComparableIntPointerIterator[this.indexesSize];
            this.numIndexes = this.indexesSize;
            this.iteratorComparator = new IteratorComparator((FSLeafIndexImpl)iteratorCache.get(0));
            for (int i = 0; i < this.indexesSize; ++i) {
                ComparableIntPointerIterator it;
                FSLeafIndexImpl leafIndex = (FSLeafIndexImpl)iteratorCache.get(i);
                this.indexes[i] = it = leafIndex.pointerIterator(this.iteratorComparator, FSIndexRepositoryImpl.this.detectIllegalIndexUpdates, ((TypeImpl)leafIndex.getType()).getCode());
            }
        }

        private PointerIterator(IndexIteratorCachePair iicp) {
            this.initPointerIterator(iicp);
            this.moveToFirst();
        }

        private PointerIterator(IndexIteratorCachePair iicp, int fs) {
            this.initPointerIterator(iicp);
            this.moveTo(fs);
        }

        public boolean isValid() {
            return this.numIndexes > 0;
        }

        private ComparableIntPointerIterator checkConcurrentModification(int i) {
            ComparableIntPointerIterator cipi = this.indexes[i];
            if (cipi.isConcurrentModification()) {
                throw new ConcurrentModificationException();
            }
            return cipi;
        }

        private void resetConcurrentModification(int i) {
            ComparableIntPointerIterator cipi = this.indexes[i];
            cipi.resetConcurrentModification();
        }

        private void checkConcurrentModificationAll() {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.checkConcurrentModification(i);
            }
        }

        public void moveToFirst() {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.resetConcurrentModification(i);
                this.indexes[i].moveToFirst();
            }
            this.numIndexes = this.indexes.length;
            this.checkIndexesTo(this.numIndexes);
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.wentForward = true;
        }

        public void moveToLast() {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.resetConcurrentModification(i);
                this.indexes[i].moveToLast();
            }
            this.numIndexes = this.indexes.length;
            this.checkIndexesTo(this.numIndexes);
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.currentIndex = this.numIndexes - 1;
            this.wentForward = false;
        }

        public void moveToNext() {
            if (!this.isValid()) {
                return;
            }
            this.checkConcurrentModificationAll();
            boolean tempWentForward = this.wentForward;
            this.incrementIterators();
            if (!this.isValid()) {
                return;
            }
            if (tempWentForward) {
                this.insert(0, this.indexes, this.numIndexes);
            } else {
                Arrays.sort(this.indexes, 0, this.numIndexes);
            }
            this.currentIndex = 0;
        }

        private final void insert(int pos, Comparable[] array, int size) {
            int max = size - 1;
            while (pos < max) {
                int next = pos + 1;
                int comp = array[pos].compareTo(array[next]);
                if (comp <= 0) {
                    return;
                }
                Comparable tmp = array[pos];
                array[pos] = array[next];
                array[next] = tmp;
                ++pos;
            }
        }

        private void ensureIndexValidity(int index) {
            if (!this.indexes[index].isValid()) {
                if (index + 1 == this.numIndexes) {
                    --this.numIndexes;
                } else {
                    --this.numIndexes;
                    ComparableIntPointerIterator tempIt = this.indexes[index];
                    this.indexes[index] = this.indexes[this.numIndexes];
                    this.indexes[this.numIndexes] = tempIt;
                }
            }
        }

        private void checkIndexesTo(int max) {
            for (int i = max - 1; i >= 0; --i) {
                this.ensureIndexValidity(i);
            }
        }

        private void incrementIterators() {
            if (this.wentForward) {
                this.indexes[this.currentIndex].inc();
                this.ensureIndexValidity(this.currentIndex);
            } else {
                for (int i = 0; i < this.indexesSize; ++i) {
                    if (i == this.currentIndex) continue;
                    ComparableIntPointerIterator it = this.indexes[i];
                    if (!it.isValid()) {
                        it.moveToFirst();
                    }
                    while (it.isValid() && this.iteratorComparator.compare(it.get(), this.indexes[this.currentIndex].get()) < 0) {
                        it.inc();
                    }
                }
                this.indexes[this.currentIndex].inc();
                this.numIndexes = this.indexesSize;
                this.checkIndexesTo(this.numIndexes);
            }
            this.wentForward = true;
        }

        public void moveToPrevious() {
            if (!this.isValid()) {
                return;
            }
            this.checkConcurrentModificationAll();
            this.decrementIterators();
            if (!this.isValid()) {
                return;
            }
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.currentIndex = this.numIndexes - 1;
        }

        private void decrementIterators() {
            if (!this.wentForward) {
                this.indexes[this.currentIndex].dec();
                this.ensureIndexValidity(this.currentIndex);
            } else {
                for (int i = 0; i < this.indexesSize; ++i) {
                    if (i == this.currentIndex) continue;
                    ComparableIntPointerIterator it = this.indexes[i];
                    if (!it.isValid()) {
                        it.moveToLast();
                    }
                    while (it.isValid() && this.iteratorComparator.compare(it.get(), this.indexes[this.currentIndex].get()) > 0) {
                        it.dec();
                    }
                }
                this.indexes[this.currentIndex].dec();
                this.numIndexes = this.indexesSize;
                this.checkIndexesTo(this.numIndexes);
            }
            this.wentForward = false;
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.checkConcurrentModification(this.currentIndex).get();
        }

        public Object copy() {
            if (this.isValid()) {
                return new PointerIterator(this.iicp, this.get());
            }
            PointerIterator pi = new PointerIterator(this.iicp);
            pi.moveToFirst();
            pi.moveToPrevious();
            return pi;
        }

        public void moveTo(int fs) {
            this.numIndexes = this.indexes.length;
            for (int i = 0; i < this.numIndexes; ++i) {
                this.resetConcurrentModification(i);
                this.indexes[i].moveTo(fs);
            }
            this.checkIndexesTo(this.numIndexes);
            if (this.numIndexes > 1) {
                Arrays.sort(this.indexes, 0, this.numIndexes);
            }
            this.wentForward = true;
            this.currentIndex = 0;
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return this.iicp.size();
        }

        public LowLevelIndex ll_getIndex() {
            return this.iicp.index;
        }
    }

    private static class IteratorComparator
    implements IntComparator {
        private final IntComparator comp;

        private IteratorComparator(IntComparator comp) {
            this.comp = comp;
        }

        public int compare(int i, int j) {
            int compResult = this.comp.compare(i, j);
            if (compResult == 0) {
                if (i < j) {
                    return -1;
                }
                if (i > j) {
                    return 1;
                }
            }
            return compResult;
        }
    }

    private class IndexIteratorCachePair
    implements Comparable {
        private FSLeafIndexImpl index = null;
        private ArrayList iteratorCache = null;

        private IndexIteratorCachePair() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexIteratorCachePair)) {
                return false;
            }
            IndexIteratorCachePair iicp = (IndexIteratorCachePair)o;
            return ((Object)this.index.getComparator()).equals(iicp.index.getComparator()) && this.index.getIndexingStrategy() == iicp.index.getIndexingStrategy();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private void createIndexIteratorCache() {
            if (this.iteratorCache != null) {
                return;
            }
            this.iteratorCache = new ArrayList();
            Type rootType = this.index.getComparator().getType();
            ArrayList allTypes = null;
            if (this.index.getIndexingStrategy() == 3) {
                allTypes = new ArrayList();
                allTypes.add(rootType);
            } else {
                allTypes = FSIndexRepositoryImpl.getAllSubsumedTypes(rootType, FSIndexRepositoryImpl.this.typeSystem);
            }
            int len = allTypes.size();
            for (int i = 0; i < len; ++i) {
                int typeCode = ((TypeImpl)allTypes.get(i)).getCode();
                ArrayList indexList = FSIndexRepositoryImpl.this.indexArray[typeCode];
                int indexPos = indexList.indexOf(this);
                if (indexPos < 0) continue;
                this.iteratorCache.add(((IndexIteratorCachePair)indexList.get((int)indexPos)).index);
            }
        }

        public int compareTo(Object o) {
            int typeCode2;
            IndexIteratorCachePair cp = (IndexIteratorCachePair)o;
            int typeCode1 = ((TypeImpl)this.index.getType()).getCode();
            if (typeCode1 < (typeCode2 = ((TypeImpl)cp.index.getType()).getCode())) {
                return -1;
            }
            if (typeCode1 > typeCode2) {
                return 1;
            }
            return this.index.getComparator().compareTo(cp.index.getComparator());
        }

        int size() {
            int size = 0;
            for (int i = 0; i < this.iteratorCache.size(); ++i) {
                size += ((LowLevelIndex)this.iteratorCache.get(i)).size();
            }
            return size;
        }
    }
}

