/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;

public class FSIntArrayIndex
extends FSLeafIndexImpl {
    private IntVector index;

    FSIntArrayIndex(CASImpl cas, Type type, int initialSize, int indexType) {
        super(cas, type, indexType);
        this.index = new IntVector(initialSize);
    }

    boolean init(FSIndexComparator comp) {
        boolean rc = super.init(comp);
        return rc;
    }

    IntVector getVector() {
        return this.index;
    }

    public void flush() {
        this.index.removeAllElements();
    }

    public final boolean insert(int fs) {
        int[] indexArray = this.index.getArray();
        int length = this.index.size();
        if (length == 0) {
            this.index.add(fs);
            return true;
        }
        int last = indexArray[length - 1];
        if (this.compare(last, fs) < 0) {
            this.index.add(fs);
            return true;
        }
        int pos = this.binarySearch(indexArray, fs, 0, length);
        if (pos >= 0) {
            this.index.add(pos + 1, fs);
        } else {
            this.index.add(-(pos + 1), fs);
        }
        return true;
    }

    private final int find(int ele) {
        return this.binarySearch(this.index.getArray(), ele, 0, this.index.size());
    }

    private final int binarySearch(int[] array, int ele, int start, int end) {
        --end;
        while (start <= end) {
            int i = (start + end) / 2;
            int comp = this.compare(ele, array[i]);
            if (comp == 0) {
                return i;
            }
            if (start == end) {
                if (comp < 0) {
                    return -i - 1;
                }
                return -i - 2;
            }
            if (comp < 0) {
                end = i - 1;
                continue;
            }
            start = i + 1;
        }
        return -start - 1;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        IntVectorIterator ivi = new IntVectorIterator(comp);
        ivi.modificationSnapshot = detectIllegalIndexUpdates[typeCode];
        IntVectorIterator.access$402(ivi, detectIllegalIndexUpdates);
        ivi.typeCode = typeCode;
        return ivi;
    }

    protected IntPointerIterator refIterator() {
        return new IntVectorIterator();
    }

    public LowLevelIterator ll_iterator() {
        return new IntVectorIterator();
    }

    protected IntPointerIterator refIterator(int fsCode) {
        IntVectorIterator it = new IntVectorIterator();
        int pos = this.find(fsCode);
        if (pos >= 0) {
            it.itPos = pos;
        } else {
            it.itPos = -(pos + 1);
        }
        return it;
    }

    public boolean contains(FeatureStructure fs) {
        return this.find(((FeatureStructureImpl)fs).getAddress()) >= 0;
    }

    public FeatureStructure find(FeatureStructure fs) {
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int resultAddr = this.find(fsi.getAddress());
        if (resultAddr >= 0) {
            return fsi.getCASImpl().createFS(this.index.get(resultAddr));
        }
        return null;
    }

    public int size() {
        return this.index.size();
    }

    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        int pos = this.index.indexOf(addr);
        if (pos >= 0) {
            this.index.remove(pos);
        }
    }

    public void remove(int fsRef) {
        int pos = this.index.indexOf(fsRef);
        if (pos >= 0) {
            this.index.remove(pos);
        }
    }

    private class IntVectorIterator
    implements ComparableIntPointerIterator,
    LowLevelIterator {
        private int itPos = 0;
        private IntComparator comp;
        private int modificationSnapshot;
        private int[] detectIllegalIndexUpdates;
        private int typeCode;

        public boolean isConcurrentModification() {
            return this.modificationSnapshot != this.detectIllegalIndexUpdates[this.typeCode];
        }

        public void resetConcurrentModification() {
            this.modificationSnapshot = this.detectIllegalIndexUpdates[this.typeCode];
        }

        private IntVectorIterator() {
        }

        private IntVectorIterator(IntComparator comp) {
            this();
            this.comp = comp;
        }

        public boolean isValid() {
            return this.itPos >= 0 && this.itPos < FSIntArrayIndex.this.index.size();
        }

        public void moveToFirst() {
            this.itPos = 0;
        }

        public void moveToLast() {
            this.itPos = FSIntArrayIndex.this.index.size() - 1;
        }

        public void moveToNext() {
            ++this.itPos;
        }

        public void moveToPrevious() {
            --this.itPos;
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return FSIntArrayIndex.this.index.get(this.itPos);
        }

        public Object copy() {
            IntVectorIterator copy = new IntVectorIterator(this.comp);
            copy.itPos = this.itPos;
            return copy;
        }

        public int compareTo(Object o) throws NoSuchElementException {
            return this.comp.compare(this.get(), ((IntVectorIterator)o).get());
        }

        public void moveTo(int i) {
            int position = FSIntArrayIndex.this.find(i);
            this.itPos = position >= 0 ? position : -(position + 1);
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return FSIntArrayIndex.this.size();
        }

        public LowLevelIndex ll_getIndex() {
            return FSIntArrayIndex.this;
        }

        static /* synthetic */ int[] access$402(IntVectorIterator x0, int[] x1) {
            x0.detectIllegalIndexUpdates = x1;
            return x1;
        }
    }
}

