/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import org.apache.uima.internal.util.IntArrayUtils;

public final class Heap {
    public static final int MIN_SIZE = 1000;
    public static final int DEFAULT_SIZE = 500000;
    private int initialSize;
    int[] heap;
    private int pos;
    private int max;
    private static final int SIZE_POS = 0;
    private static final int TMPP_POS = 1;
    private static final int TMPM_POS = 2;
    private static final int PGSZ_POS = 5;
    private static final int AVSZ_POS = 6;
    private static final int AVST_POS = 7;

    public Heap() {
        this(500000);
    }

    public Heap(int initialSize) {
        if (initialSize < 1000) {
            initialSize = 1000;
        }
        this.initialSize = initialSize;
        this.initHeap();
    }

    private final void initHeap() {
        this.heap = new int[this.initialSize];
        this.pos = 1;
        this.max = this.heap.length;
    }

    void reinit(int[] md, int[] shortHeap) {
        if (md == null) {
            this.reinitNoMetaData(shortHeap);
            return;
        }
        int heapSize = md[0];
        this.pos = md[1];
        this.max = md[2];
        this.initialSize = md[5];
        this.heap = new int[heapSize];
        System.arraycopy(shortHeap, 0, this.heap, 0, shortHeap.length);
    }

    private void reinitNoMetaData(int[] shortHeap) {
        int n = this.initialSize = shortHeap.length < 1000 ? 1000 : shortHeap.length;
        if (shortHeap.length >= this.initialSize) {
            this.heap = shortHeap;
        } else {
            System.arraycopy(shortHeap, 0, this.heap, 0, shortHeap.length);
        }
        this.pos = shortHeap.length;
        this.max = this.initialSize;
    }

    void reinitSizeOnly(int newSize) {
        this.initialSize = newSize < 1000 ? 1000 : newSize;
        this.heap = new int[this.initialSize];
        this.pos = newSize;
        this.max = this.initialSize;
    }

    int getCellsUsed() {
        return this.pos;
    }

    int getHeapSize() {
        return this.heap.length;
    }

    int[] getMetaData() {
        int arSize = 7;
        int[] ar = new int[7];
        ar[0] = this.heap.length;
        ar[1] = this.pos;
        ar[2] = this.max;
        ar[5] = this.initialSize;
        boolean availablePagesSize = false;
        ar[6] = 0;
        return ar;
    }

    private void grow() {
        int start = this.heap.length;
        this.heap = IntArrayUtils.ensure_size(this.heap, start + this.initialSize, 2, 500000);
        this.max = this.heap.length;
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean doFullReset) {
        if (doFullReset) {
            this.initHeap();
        } else {
            Arrays.fill(this.heap, 0, this.heap.length, 0);
            this.pos = 1;
        }
    }

    public int add(int[] fs) {
        while (this.pos + fs.length >= this.max) {
            this.grow();
        }
        System.arraycopy(fs, 0, this.heap, this.pos, fs.length);
        int pos1 = this.pos;
        this.pos += fs.length;
        return pos1;
    }

    public int add(int len, int val) {
        while (this.pos + len >= this.max) {
            this.grow();
        }
        int pos1 = this.pos;
        this.pos += len;
        this.heap[pos1] = val;
        return pos1;
    }
}

