/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class IntArrayFSImpl
extends CommonArrayFSImpl
implements IntArrayFS {
    private IntArrayFSImpl() {
    }

    public IntArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new IntArrayFSGenerator();
    }

    public int get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getIntArrayValue(this.addr, i);
    }

    public void set(int i, int value) {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setIntArrayValue(this.addr, i, value);
    }

    public void copyFromArray(int[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        System.arraycopy(src, srcOffset, this.casImpl.getHeap().heap, destOffset += this.casImpl.getArrayStartAddress(this.addr), length);
    }

    public void copyToArray(int srcOffset, int[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        System.arraycopy(this.casImpl.getHeap().heap, srcOffset += this.casImpl.getArrayStartAddress(this.addr), dest, destOffset, length);
    }

    public int[] toArray() {
        int size = this.size();
        int[] outArray = new int[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        srcOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Integer.toString(heap[i + srcOffset]);
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        destOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            heap[i + destOffset] = Integer.parseInt(src[i + srcOffset]);
        }
    }

    private static class IntArrayFSGenerator
    implements FSGenerator {
        private IntArrayFSGenerator() {
        }

        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new IntArrayFSImpl(addr, cas);
        }
    }
}

