/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ListUtils {
    CASImpl cas;
    private int intListType;
    private int floatListType;
    private int stringListType;
    private int fsListType;
    private int neIntListType;
    private int neFloatListType;
    private int neStringListType;
    private int neFsListType;
    private int eIntListType;
    private int eFloatListType;
    private int eStringListType;
    private int eFsListType;
    private int intHeadFeat;
    private int intTailFeat;
    private int floatHeadFeat;
    private int floatTailFeat;
    private int stringHeadFeat;
    private int stringTailFeat;
    private int fsHeadFeat;
    private int fsTailFeat;
    private Logger logger;
    private ErrorHandler eh;

    public ListUtils(CASImpl aCASImpl, Logger aLogger, ErrorHandler aErrorHandler) {
        this.cas = aCASImpl;
        this.logger = aLogger;
        this.eh = aErrorHandler;
        TypeSystemImpl ts = aCASImpl.getTypeSystemImpl();
        this.intListType = ts.ll_getCodeForTypeName("uima.cas.IntegerList");
        this.floatListType = ts.ll_getCodeForTypeName("uima.cas.FloatList");
        this.stringListType = ts.ll_getCodeForTypeName("uima.cas.StringList");
        this.fsListType = ts.ll_getCodeForTypeName("uima.cas.FSList");
        this.neIntListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyIntegerList");
        this.neFloatListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFloatList");
        this.neStringListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyStringList");
        this.neFsListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFSList");
        this.eIntListType = ts.ll_getCodeForTypeName("uima.cas.EmptyIntegerList");
        this.eFloatListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFloatList");
        this.eStringListType = ts.ll_getCodeForTypeName("uima.cas.EmptyStringList");
        this.eFsListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFSList");
        this.intHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:head");
        this.floatHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:head");
        this.stringHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:head");
        this.fsHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:head");
        this.intTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:tail");
        this.floatTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:tail");
        this.stringTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:tail");
        this.fsTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:tail");
    }

    public boolean isIntListType(int type) {
        return type == this.intListType || type == this.neIntListType || type == this.eIntListType;
    }

    public boolean isFloatListType(int type) {
        return type == this.floatListType || type == this.neFloatListType || type == this.eFloatListType;
    }

    public boolean isStringListType(int type) {
        return type == this.stringListType || type == this.neStringListType || type == this.eStringListType;
    }

    public boolean isFsListType(int type) {
        return type == this.fsListType || type == this.neFsListType || type == this.eFsListType;
    }

    public boolean isListType(int type) {
        return this.isIntListType(type) || this.isFloatListType(type) || this.isStringListType(type) || this.isFsListType(type);
    }

    public String[] intListToStringArray(int addr) throws SAXException {
        IntRedBlackTree visited = new IntRedBlackTree();
        boolean foundCycle = false;
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neIntListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = Integer.toString(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intHeadFeat)));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + Arrays.asList(array).toString());
        }
        return array;
    }

    public String[] floatListToStringArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFloatListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = Float.toString(CASImpl.int2float(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatHeadFeat))));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in a FloatList.  List truncated to " + Arrays.asList(array).toString() + ".");
        }
        return array;
    }

    public String[] stringListToStringArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neStringListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = this.cas.getStringForCode(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringHeadFeat)));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in a StringList.  List truncated to " + Arrays.asList(array).toString() + ".");
        }
        return array;
    }

    public String[] fsListToXmiIdStringArray(int addr, XmiSerializationSharedData sharedData) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFsListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        String[] strArray = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            int heapVal = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsHeadFeat));
            if (heapVal == 0) {
                XmiSerializationSharedData.OotsElementData oed;
                strArray[i] = "0";
                if (sharedData != null && (oed = sharedData.getOutOfTypeSystemFeatures(curNode)) != null) {
                    assert (oed.attributes.size() == 1);
                    XmlAttribute attr = (XmlAttribute)oed.attributes.get(0);
                    assert ("head".equals(attr.name));
                    strArray[i] = attr.value;
                }
            } else {
                strArray[i] = sharedData != null ? (heapVal == 0 ? null : sharedData.getXmiId(heapVal)) : Integer.toString(heapVal);
            }
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an FSList.  List truncated to " + Arrays.asList(strArray).toString() + ".");
        }
        return strArray;
    }

    public int[] fsListToAddressArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFsListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        int[] array = new int[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsHeadFeat));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an FSList.  List truncated where cycle occurs.");
        }
        return array;
    }

    public int createIntList(List stringValues) {
        int first = this.cas.ll_createFS(this.eIntListType);
        ListIterator iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt((String)iter.previous());
            int node = this.cas.ll_createFS(this.neIntListType);
            this.cas.setFeatureValue(node, this.intHeadFeat, value);
            this.cas.setFeatureValue(node, this.intTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFloatList(List stringValues) {
        int first = this.cas.ll_createFS(this.eFloatListType);
        ListIterator iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            float value = Float.parseFloat((String)iter.previous());
            int node = this.cas.ll_createFS(this.neFloatListType);
            this.cas.setFeatureValue(node, this.floatHeadFeat, CASImpl.float2int(value));
            this.cas.setFeatureValue(node, this.floatTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createStringList(List stringValues) {
        int first = this.cas.ll_createFS(this.eStringListType);
        ListIterator iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            String value = (String)iter.previous();
            int node = this.cas.ll_createFS(this.neStringListType);
            this.cas.setFeatureValue(node, this.stringHeadFeat, this.cas.addString(value));
            this.cas.setFeatureValue(node, this.stringTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFsList(List stringValues, IntVector fsAddresses) {
        int first = this.cas.ll_createFS(this.eFsListType);
        ListIterator iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt((String)iter.previous());
            int node = this.cas.ll_createFS(this.neFsListType);
            fsAddresses.add(node);
            this.cas.setFeatureValue(node, this.fsHeadFeat, value);
            this.cas.setFeatureValue(node, this.fsTailFeat, first);
            first = node;
        }
        return first;
    }

    private void reportWarning(String message) throws SAXException {
        if (this.logger != null) {
            this.logger.log(Level.WARNING, message);
        }
        if (this.eh != null) {
            this.eh.warning(new SAXParseException(message, null));
        }
    }
}

