/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.StringTypeImpl;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TypeSystem2Xml {
    public static void typeSystem2Xml(TypeSystem aTypeSystem, OutputStream aOutputStream) throws SAXException, IOException {
        XMLSerializer sax2xml = new XMLSerializer(aOutputStream);
        TypeSystem2Xml.typeSystem2Xml(aTypeSystem, sax2xml.getContentHandler());
    }

    public static void typeSystem2Xml(TypeSystem aTypeSystem, ContentHandler aContentHandler) throws SAXException {
        ResourceSpecifierFactory factory = UIMAFramework.getResourceSpecifierFactory();
        TypeSystemDescription tsDesc = factory.createTypeSystemDescription();
        ArrayList<TypeDescription> typeDescs = new ArrayList<TypeDescription>();
        Iterator typeIterator = aTypeSystem.getTypeIterator();
        while (typeIterator.hasNext()) {
            Type type = (Type)typeIterator.next();
            Type superType = aTypeSystem.getParent(type);
            if (type.getName().startsWith("uima.cas") && type.isFeatureFinal()) continue;
            TypeDescription typeDesc = factory.createTypeDescription();
            typeDesc.setName(type.getName());
            typeDesc.setSupertypeName(superType.getName());
            ArrayList<FeatureDescription> featDescs = new ArrayList<FeatureDescription>();
            for (Feature feat : type.getFeatures()) {
                FeatureDescription featDesc = factory.createFeatureDescription();
                featDesc.setName(feat.getShortName());
                featDesc.setRangeTypeName(feat.getRange().getName());
                featDescs.add(featDesc);
            }
            FeatureDescription[] featDescArr = new FeatureDescription[featDescs.size()];
            featDescs.toArray(featDescArr);
            typeDesc.setFeatures(featDescArr);
            if (type instanceof StringTypeImpl) {
                LowLevelTypeSystem lts = aTypeSystem.getLowLevelTypeSystem();
                int typeCode = lts.ll_getCodeForType(type);
                String[] strings = lts.ll_getStringSet(typeCode);
                AllowedValue[] allowedVals = new AllowedValue[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    allowedVals[i] = factory.createAllowedValue();
                    allowedVals[i].setString(strings[i]);
                }
                typeDesc.setAllowedValues(allowedVals);
            }
            typeDescs.add(typeDesc);
        }
        TypeDescription[] typeDescArr = new TypeDescription[typeDescs.size()];
        typeDescs.toArray(typeDescArr);
        tsDesc.setTypes(typeDescArr);
        aContentHandler.startDocument();
        tsDesc.toXML(aContentHandler);
        aContentHandler.endDocument();
    }
}

