/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmiCasDeserializer {
    private TypeSystemImpl ts;
    private Map xmiNamespaceToUimaNamespaceMap = new HashMap();

    public XmiCasDeserializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
    }

    public XmiCasDeserializer(TypeSystem ts) {
        this(ts, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cas) {
        return this.getXmiCasHandler(cas, false);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, null, -1);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, -1);
    }

    public DefaultHandler getXmiCasHandler(CAS cas, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint) {
        return new XmiCasDeserializerHandler((CASImpl)cas, lenient, sharedData, mergePoint);
    }

    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, false, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, null, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(aStream, aCAS, aLenient, aSharedData, -1);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient, XmiSerializationSharedData aSharedData, int aMergePoint) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    private String xmiElementName2uimaTypeName(String nsUri, String localName) throws SAXException {
        String uimaNamespace = (String)this.xmiNamespaceToUimaNamespaceMap.get(nsUri);
        if (uimaNamespace == null) {
            if ("http:///uima/noNamespace.ecore".equals(nsUri)) {
                uimaNamespace = "";
            } else {
                URI uri;
                try {
                    uri = new URI(nsUri);
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
                String path = uri.getPath();
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith(".ecore")) {
                    path = path.substring(0, path.length() - 6);
                }
                uimaNamespace = path.replace('/', '.') + '.';
            }
            this.xmiNamespaceToUimaNamespaceMap.put(nsUri, uimaNamespace);
        }
        return uimaNamespace + localName;
    }

    private class XmiCasDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int FEAT_CONTENT_STATE = 3;
        private static final int IGNORING_XMI_ELEMENTS_STATE = 4;
        private static final int REF_FEAT_STATE = 5;
        private static final String unknownXMLSource = "<unknown>";
        private String ID_ATTR_NAME = "xmi:id";
        private Locator locator;
        private CASImpl casBeingFilled;
        private IntVector deserializedFsAddrs;
        private IntVector fsListNodesFromMultivaluedProperties;
        private int state;
        private StringBuffer buffer;
        private int currentAddr;
        private TypeImpl currentType;
        private int currentArrayId;
        private List currentArrayElements;
        private Map multiValuedFeatures = new TreeMap();
        private int sofaTypeCode;
        private int sofaNumFeatCode;
        private int sofaFeatCode;
        private ArrayList indexRepositories;
        private ArrayList views;
        private ListUtils listUtils;
        private int[] featureType;
        boolean lenient;
        private int ignoreDepth = 0;
        private HashMap nsPrefixToUriMap = new HashMap();
        private XmiSerializationSharedData sharedData;
        private int nextSofaNum;
        private int mergePoint;
        private XmiSerializationSharedData.OotsElementData outOfTypeSystemElement = null;
        private RedBlackTree localXmiIdToFsAddrMap = new RedBlackTree();

        private XmiCasDeserializerHandler(CASImpl aCAS, boolean lenient, XmiSerializationSharedData sharedData, int mergePoint) {
            this.casBeingFilled = aCAS.getBaseCAS();
            this.lenient = lenient;
            this.sharedData = sharedData != null ? sharedData : new XmiSerializationSharedData();
            this.mergePoint = mergePoint;
            if (mergePoint < 0) {
                this.casBeingFilled.resetNoQuestions();
                this.sharedData.clearIdMap();
                this.nextSofaNum = 2;
            } else {
                this.nextSofaNum = this.casBeingFilled.getBaseSofaCount() + 1;
            }
            this.deserializedFsAddrs = new IntVector();
            this.fsListNodesFromMultivaluedProperties = new IntVector();
            this.buffer = new StringBuffer();
            this.indexRepositories = new ArrayList();
            this.views = new ArrayList();
            this.indexRepositories.add(this.casBeingFilled.getBaseIndexRepository());
            this.indexRepositories.add(this.casBeingFilled.getView("_InitialView").getIndexRepository());
            FSIterator sofaIter = this.casBeingFilled.getSofaIterator();
            while (sofaIter.hasNext()) {
                SofaFS sofa = (SofaFS)sofaIter.next();
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                    continue;
                }
                this.indexRepositories.add(this.casBeingFilled.getSofaIndexRepository(sofa));
            }
            TypeSystemImpl tsOfReceivingCas = this.casBeingFilled.getTypeSystemImpl();
            this.sofaTypeCode = tsOfReceivingCas.ll_getCodeForTypeName("uima.cas.Sofa");
            this.sofaNumFeatCode = tsOfReceivingCas.ll_getCodeForFeatureName("uima.cas.Sofa:sofaNum");
            this.sofaFeatCode = tsOfReceivingCas.ll_getCodeForFeatureName("uima.tcas.Annotation:sofa");
            this.listUtils = new ListUtils(this.casBeingFilled, UIMAFramework.getLogger(XmiCasDeserializer.class), null);
            this.featureType = new int[tsOfReceivingCas.getNumberOfFeatures() + 1];
            Iterator it = tsOfReceivingCas.getFeatures();
            while (it.hasNext()) {
                FeatureImpl feat = (FeatureImpl)it.next();
                this.featureType[feat.getCode()] = this.classifyType(tsOfReceivingCas.range(feat.getCode()));
            }
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        public void startDocument() throws SAXException {
            this.state = 0;
        }

        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String attrName = attrs.getQName(i);
                            if (!attrName.startsWith("xmlns:")) continue;
                            String prefix = attrName.substring(6);
                            String uri = attrs.getValue(i);
                            this.nsPrefixToUriMap.put(prefix, uri);
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    int idInt;
                    String id;
                    if (qualifiedName.startsWith("xmi")) {
                        this.state = 4;
                        ++this.ignoreDepth;
                        return;
                    }
                    if (this.mergePoint >= 0 && (id = attrs.getValue(this.ID_ATTR_NAME)) != null && (idInt = Integer.parseInt(id)) <= this.mergePoint) {
                        this.state = 4;
                        ++this.ignoreDepth;
                        return;
                    }
                    if (nameSpaceURI == null || nameSpaceURI.length() == 0) {
                        int colonIndex = qualifiedName.indexOf(58);
                        if (colonIndex != -1) {
                            String prefix = qualifiedName.substring(0, colonIndex);
                            nameSpaceURI = (String)this.nsPrefixToUriMap.get(prefix);
                            if (nameSpaceURI == null) {
                                nameSpaceURI = "http:///" + prefix + ".ecore";
                            }
                            localName = qualifiedName.substring(colonIndex + 1);
                        } else {
                            nameSpaceURI = "http:///uima/noNamespace.ecore";
                        }
                    }
                    this.readFS(nameSpaceURI, localName, qualifiedName, attrs);
                    this.multiValuedFeatures.clear();
                    this.state = 2;
                    break;
                }
                case 2: {
                    String href = attrs.getValue("href");
                    if (href != null && href.startsWith("#")) {
                        if (this.outOfTypeSystemElement != null) {
                            XmlElementName elemName = new XmlElementName(nameSpaceURI, localName, qualifiedName);
                            ArrayList<XmlAttribute> ootsAttrs = new ArrayList<XmlAttribute>();
                            ootsAttrs.add(new XmlAttribute("href", href));
                            XmlElementNameAndContents elemWithContents = new XmlElementNameAndContents(elemName, null, ootsAttrs);
                            this.outOfTypeSystemElement.childElements.add(elemWithContents);
                        } else {
                            ArrayList<String> valueList = (ArrayList<String>)this.multiValuedFeatures.get(qualifiedName);
                            if (valueList == null) {
                                valueList = new ArrayList<String>();
                                this.multiValuedFeatures.put(qualifiedName, valueList);
                            }
                            valueList.add(href.substring(1));
                        }
                        this.state = 5;
                        break;
                    }
                    this.state = 3;
                    break;
                }
                case 4: {
                    ++this.ignoreDepth;
                    break;
                }
                default: {
                    throw this.createException(1, qualifiedName);
                }
            }
        }

        private void readFS(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            String typeName = XmiCasDeserializer.this.xmiElementName2uimaTypeName(nameSpaceURI, localName);
            this.currentType = (TypeImpl)XmiCasDeserializer.this.ts.getType(typeName);
            if (this.currentType == null) {
                if ("uima.cas.NULL".equals(typeName)) {
                    return;
                }
                if ("uima.cas.View".equals(typeName)) {
                    this.processView(attrs.getValue("sofa"), attrs.getValue("members"));
                    return;
                }
                if (!this.lenient) {
                    throw this.createException(4, typeName);
                }
                this.addToOutOfTypeSystemData(new XmlElementName(nameSpaceURI, localName, qualifiedName), attrs);
                return;
            }
            if (this.casBeingFilled.isArrayType(this.currentType)) {
                String idStr = attrs.getValue(this.ID_ATTR_NAME);
                this.currentArrayId = idStr == null ? -1 : Integer.parseInt(idStr);
                String elements = attrs.getValue("elements");
                if (this.casBeingFilled.isByteArrayType(this.currentType)) {
                    this.createByteArray(elements, this.currentArrayId);
                } else if (elements != null) {
                    String[] parsedElements = this.parseArray(elements);
                    this.currentArrayElements = Arrays.asList(parsedElements);
                } else {
                    this.currentArrayElements = null;
                }
            } else {
                int addr = this.casBeingFilled.ll_createFS(this.currentType.getCode());
                this.readFS(addr, attrs);
            }
        }

        private void processView(String sofa, String membersString) {
            if (membersString != null) {
                int sofaNum = 1;
                if (sofa != null) {
                    int sofaXmiId = Integer.parseInt(sofa);
                    int sofaAddr = this.getFsAddrForXmiId(sofaXmiId);
                    sofaNum = this.casBeingFilled.getFeatureValue(sofaAddr, this.sofaNumFeatCode);
                }
                FSIndexRepositoryImpl indexRep = (FSIndexRepositoryImpl)this.indexRepositories.get(sofaNum);
                String[] members = this.parseArray(membersString);
                for (int i = 0; i < members.length; ++i) {
                    int id = Integer.parseInt(members[i]);
                    if (id <= this.mergePoint) continue;
                    try {
                        int addr = this.getFsAddrForXmiId(id);
                        indexRep.addFS(addr);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        if (!this.lenient) {
                            throw e;
                        }
                        this.sharedData.addOutOfTypeSystemViewMember(sofa, members[i]);
                    }
                }
            }
        }

        private void readFS(int addr, Attributes attrs) throws SAXParseException {
            this.currentAddr = addr;
            int id = -1;
            int typeCode = this.casBeingFilled.getHeapValue(addr);
            Type type = this.casBeingFilled.getTypeSystemImpl().ll_getTypeForCode(typeCode);
            int thisSofaNum = 0;
            if (this.sofaTypeCode == typeCode) {
                String sofaID = attrs.getValue("sofaID");
                thisSofaNum = sofaID.equals("_InitialView") || sofaID.equals("_DefaultTextSofaName") ? 1 : this.nextSofaNum++;
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals(this.ID_ATTR_NAME)) {
                    try {
                        id = Integer.parseInt(attrValue);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(5, attrValue);
                    }
                }
                if (this.sofaTypeCode == typeCode && attrName.equals("sofaID")) {
                    if (attrValue.equals("_DefaultTextSofaName")) {
                        attrValue = "_InitialView";
                    }
                } else if (this.sofaTypeCode == typeCode && attrName.equals("sofaNum")) {
                    attrValue = Integer.toString(thisSofaNum);
                }
                this.handleFeature(type, addr, attrName, attrValue);
            }
            if (this.sofaTypeCode == typeCode) {
                SofaFS sofa = (SofaFS)this.casBeingFilled.createFS(addr);
                this.casBeingFilled.getBaseIndexRepository().addFS(sofa);
                CAS view = this.casBeingFilled.getView(sofa);
                if (sofa.getSofaRef() == 1) {
                    this.casBeingFilled.registerInitialSofa();
                } else {
                    this.indexRepositories.add(this.casBeingFilled.getSofaIndexRepository(sofa));
                }
                ((CASImpl)view).registerView(sofa);
                this.views.add(view);
            }
            this.deserializedFsAddrs.add(addr);
            this.addFsAddrXmiIdMapping(addr, id);
        }

        private final boolean emptyVal(String val) {
            return val == null || val.length() == 0;
        }

        private void handleFeature(Type type, int addr, String featName, String featVal) throws SAXParseException {
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                this.sharedData.addOutOfTypeSystemAttribute(addr, featName, featVal);
                return;
            }
            this.handleFeature(addr, feat.getCode(), featVal);
        }

        private void handleFeature(Type type, int addr, String featName, List featVals) throws SAXParseException {
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(featName);
            if (feat == null) {
                if (!this.lenient) {
                    throw this.createException(8, featName);
                }
                this.sharedData.addOutOfTypeSystemChildElements(addr, featName, featVals);
                return;
            }
            this.handleFeature(addr, feat.getCode(), featVals);
        }

        private void handleFeature(int addr, int featCode, String featVal) throws SAXParseException {
            switch (this.featureType[featCode]) {
                case 1: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        if (featCode == this.sofaFeatCode) {
                            int sofaXmiId = Integer.parseInt(featVal);
                            int sofaAddr = this.getFsAddrForXmiId(sofaXmiId);
                            int sofaNum = this.casBeingFilled.getFeatureValue(sofaAddr, this.sofaNumFeatCode);
                            this.casBeingFilled.setFeatureValue(addr, featCode, sofaNum);
                            break;
                        }
                        this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, featVal);
                    }
                }
                case 2: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        this.casBeingFilled.setFeatureValueFromString(addr, featCode, featVal);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(10, featVal);
                    }
                }
                case 3: {
                    if (featVal == null) break;
                    this.casBeingFilled.setStringValue(addr, featCode, featVal);
                    break;
                }
                case 8: {
                    try {
                        if (this.emptyVal(featVal)) break;
                        this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, featVal);
                    }
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(featVal)) break;
                            this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(9, featVal);
                        }
                    }
                    if (this.featureType[featCode] == 15) {
                        int casArray = this.createByteArray(featVal, -1);
                        this.casBeingFilled.setFeatureValue(addr, featCode, casArray);
                        break;
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeature(addr, featCode, Arrays.asList(arrayVals));
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    if (XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(featVal)) break;
                            this.casBeingFilled.setFeatureValue(addr, featCode, Integer.parseInt(featVal));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(9, featVal);
                        }
                    }
                    String[] arrayVals = this.parseArray(featVal);
                    this.handleFeature(addr, featCode, Arrays.asList(arrayVals));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private String[] parseArray(String val) {
            String[] arrayVals = this.emptyVal(val = val.trim()) ? new String[]{} : val.split("\\s+");
            return arrayVals;
        }

        private void handleFeature(int addr, int featCode, List featVals) throws SAXParseException {
            switch (this.featureType[featCode]) {
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (featVals.size() != 1) {
                        throw new SAXParseException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "multiple_values_unexpected", new Object[]{XmiCasDeserializer.this.ts.ll_getFeatureForCode(featCode).getName()}), this.locator);
                    }
                    this.handleFeature(addr, featCode, (String)featVals.get(0));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    int casArray = this.createArray(this.casBeingFilled.getTypeSystemImpl().range(featCode), featVals, -1);
                    this.casBeingFilled.setFeatureValue(addr, featCode, casArray);
                    break;
                }
                case 7: {
                    int casArray = this.createArray(this.casBeingFilled.getTypeSystemImpl().range(featCode), featVals, -1);
                    this.casBeingFilled.setFeatureValue(addr, featCode, casArray);
                    break;
                }
                case 101: {
                    int listFS = this.listUtils.createIntList(featVals);
                    this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    break;
                }
                case 102: {
                    int listFS = this.listUtils.createFloatList(featVals);
                    this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    break;
                }
                case 103: {
                    int listFS = this.listUtils.createStringList(featVals);
                    this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    break;
                }
                case 104: {
                    int listFS = this.listUtils.createFsList(featVals, this.fsListNodesFromMultivaluedProperties);
                    this.casBeingFilled.setFeatureValue(addr, featCode, listFS);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private int createArray(int arrayType, List values, int xmiId) {
            FeatureStructureImpl fs = this.casBeingFilled.isIntArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createIntArrayFS(values.size())) : (this.casBeingFilled.isFloatArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createFloatArrayFS(values.size())) : (this.casBeingFilled.isStringArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createStringArrayFS(values.size())) : (this.casBeingFilled.isBooleanArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createBooleanArrayFS(values.size())) : (this.casBeingFilled.isByteArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createByteArrayFS(values.size())) : (this.casBeingFilled.isShortArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createShortArrayFS(values.size())) : (this.casBeingFilled.isLongArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createLongArrayFS(values.size())) : (this.casBeingFilled.isDoubleArrayType(arrayType) ? (FeatureStructureImpl)((Object)this.casBeingFilled.createDoubleArrayFS(values.size())) : (FeatureStructureImpl)((Object)this.casBeingFilled.createArrayFS(values.size())))))))));
            int casArray = fs.getAddress();
            for (int i = 0; i < values.size(); ++i) {
                String stringVal = (String)values.get(i);
                this.casBeingFilled.setArrayValueFromString(casArray, i, stringVal);
            }
            this.deserializedFsAddrs.add(casArray);
            this.addFsAddrXmiIdMapping(casArray, xmiId);
            return casArray;
        }

        private int createByteArray(String hexString, int xmiId) {
            int arrayLen = hexString.length() / 2;
            ByteArrayFS fs = this.casBeingFilled.createByteArrayFS(arrayLen);
            for (int i = 0; i < arrayLen; ++i) {
                byte high = this.hexCharToByte(hexString.charAt(i * 2));
                byte low = this.hexCharToByte(hexString.charAt(i * 2 + 1));
                byte b = (byte)(high << 4 | low);
                fs.set(i, b);
            }
            int arrayAddr = ((FeatureStructureImpl)((Object)fs)).getAddress();
            this.deserializedFsAddrs.add(arrayAddr);
            this.addFsAddrXmiIdMapping(arrayAddr, xmiId);
            return arrayAddr;
        }

        private byte hexCharToByte(char c) {
            if ('0' <= c && c <= '9') {
                return (byte)(c - 48);
            }
            if ('A' <= c && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            if ('1' <= c && c <= 'f') {
                return (byte)(c - 49 + 10);
            }
            throw new NumberFormatException("Invalid hex char: " + c);
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: {
                    this.buffer.append(chars, start, length);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer b) {
            int len = b.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(b.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 3: {
                    ArrayList<String> valueList = (ArrayList<String>)this.multiValuedFeatures.get(qualifiedName);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                        this.multiValuedFeatures.put(qualifiedName, valueList);
                    }
                    valueList.add(this.buffer.toString());
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.outOfTypeSystemElement != null) {
                        if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry entry : this.multiValuedFeatures.entrySet()) {
                                String featName = (String)entry.getKey();
                                List featVals = (List)entry.getValue();
                                this.addOutOfTypeSystemFeature(this.outOfTypeSystemElement, featName, featVals);
                            }
                        }
                        this.outOfTypeSystemElement = null;
                    } else if (this.currentType != null) {
                        if (this.casBeingFilled.isArrayType(this.currentType) && !this.casBeingFilled.isByteArrayType(this.currentType)) {
                            if (this.currentArrayElements == null) {
                                this.currentArrayElements = (List)this.multiValuedFeatures.get("elements");
                                if (this.currentArrayElements == null) {
                                    this.currentArrayElements = Collections.EMPTY_LIST;
                                }
                            }
                            this.createArray(this.currentType.getCode(), this.currentArrayElements, this.currentArrayId);
                        } else if (!this.multiValuedFeatures.isEmpty()) {
                            for (Map.Entry entry : this.multiValuedFeatures.entrySet()) {
                                String featName = (String)entry.getKey();
                                List featVals = (List)entry.getValue();
                                this.handleFeature((Type)this.currentType, this.currentAddr, featName, featVals);
                            }
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    --this.ignoreDepth;
                    if (this.ignoreDepth != 0) break;
                    this.state = 1;
                }
            }
        }

        public void endDocument() throws SAXException {
            int i;
            for (i = 0; i < this.deserializedFsAddrs.size(); ++i) {
                this.finalizeFS(this.deserializedFsAddrs.get(i));
            }
            for (i = 0; i < this.fsListNodesFromMultivaluedProperties.size(); ++i) {
                this.remapFSListHeads(this.fsListNodesFromMultivaluedProperties.get(i));
            }
            for (i = 0; i < this.views.size(); ++i) {
                ((CASImpl)this.views.get(i)).updateDocumentAnnotation();
            }
        }

        private void finalizeFS(int addr) {
            int type = this.casBeingFilled.getHeapValue(addr);
            if (this.casBeingFilled.isArrayType(type)) {
                this.finalizeArray(type, addr);
                return;
            }
            int[] feats = this.casBeingFilled.getTypeSystemImpl().ll_getAppropriateFeatures(type);
            for (int i = 0; i < feats.length; ++i) {
                int featVal;
                Feature feat = XmiCasDeserializer.this.ts.ll_getFeatureForCode(feats[i]);
                int typeCode = XmiCasDeserializer.this.ts.ll_getRangeType(feats[i]);
                if (!this.casBeingFilled.ll_isRefType(typeCode) || this.featureType[feats[i]] != 8 && !feat.isMultipleReferencesAllowed() || (featVal = this.casBeingFilled.getFeatureValue(addr, feats[i])) == 0) continue;
                int fsValAddr = 0;
                try {
                    fsValAddr = this.getFsAddrForXmiId(featVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw e;
                    }
                    this.sharedData.addOutOfTypeSystemAttribute(addr, feat.getShortName(), Integer.toString(featVal));
                }
                this.casBeingFilled.setFeatureValue(addr, feats[i], fsValAddr);
            }
        }

        private void remapFSListHeads(int addr) {
            int type = this.casBeingFilled.getHeapValue(addr);
            if (!this.listUtils.isFsListType(type)) {
                return;
            }
            int[] feats = this.casBeingFilled.getTypeSystemImpl().ll_getAppropriateFeatures(type);
            if (feats.length == 0) {
                return;
            }
            int headFeat = feats[0];
            int featVal = this.casBeingFilled.getFeatureValue(addr, headFeat);
            if (featVal != 0) {
                int fsValAddr = 0;
                try {
                    fsValAddr = this.getFsAddrForXmiId(featVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw e;
                    }
                    this.sharedData.addOutOfTypeSystemAttribute(addr, "head", Integer.toString(featVal));
                }
                this.casBeingFilled.setFeatureValue(addr, headFeat, fsValAddr);
            }
        }

        private void finalizeArray(int type, int addr) {
            if (!this.casBeingFilled.isFSArrayType(type)) {
                return;
            }
            int size = this.casBeingFilled.ll_getArraySize(addr);
            for (int i = 0; i < size; ++i) {
                int arrayVal = this.casBeingFilled.getArrayValue(addr, i);
                if (arrayVal == 0) continue;
                int arrayValAddr = 0;
                try {
                    arrayValAddr = this.getFsAddrForXmiId(arrayVal);
                }
                catch (NoSuchElementException e) {
                    if (!this.lenient) {
                        throw e;
                    }
                    this.sharedData.addOutOfTypeSystemArrayElement(addr, i, arrayVal);
                }
                this.casBeingFilled.setArrayValue(addr, i, arrayValAddr);
            }
        }

        private XCASParsingException createException(int code) {
            XCASParsingException e = new XCASParsingException(code);
            String source = unknownXMLSource;
            String line = unknownXMLSource;
            String col = unknownXMLSource;
            if (this.locator != null) {
                source = this.locator.getSystemId();
                if (source == null) {
                    source = this.locator.getPublicId();
                }
                if (source == null) {
                    source = unknownXMLSource;
                }
                line = Integer.toString(this.locator.getLineNumber());
                col = Integer.toString(this.locator.getColumnNumber());
            }
            e.addArgument(source);
            e.addArgument(line);
            e.addArgument(col);
            return e;
        }

        private XCASParsingException createException(int code, String arg) {
            XCASParsingException e = this.createException(code);
            e.addArgument(arg);
            return e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private final int classifyType(int type) {
            if (this.listUtils.isIntListType(type)) {
                return 101;
            }
            if (this.listUtils.isFloatListType(type)) {
                return 102;
            }
            if (this.listUtils.isStringListType(type)) {
                return 103;
            }
            if (this.listUtils.isFsListType(type)) {
                return 104;
            }
            return this.casBeingFilled.ll_getTypeClass(type);
        }

        private void addFsAddrXmiIdMapping(int fsAddr, int xmiId) {
            if (xmiId > 0) {
                if (this.mergePoint < 0) {
                    this.sharedData.addIdMapping(fsAddr, xmiId);
                } else {
                    this.localXmiIdToFsAddrMap.put(xmiId, fsAddr);
                }
            }
        }

        private int getFsAddrForXmiId(int xmiId) {
            if (this.mergePoint < 0 || xmiId <= this.mergePoint) {
                int addr = this.sharedData.getFsAddrForXmiId(xmiId);
                if (addr > 0) {
                    return addr;
                }
                throw new NoSuchElementException();
            }
            Integer localAddr = (Integer)this.localXmiIdToFsAddrMap.get(xmiId);
            if (localAddr != null) {
                return localAddr;
            }
            throw new NoSuchElementException();
        }

        private void addToOutOfTypeSystemData(XmlElementName xmlElementName, Attributes attrs) throws XCASParsingException {
            this.outOfTypeSystemElement = new XmiSerializationSharedData.OotsElementData();
            this.outOfTypeSystemElement.elementName = xmlElementName;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals(this.ID_ATTR_NAME)) {
                    this.outOfTypeSystemElement.xmiId = attrValue;
                    continue;
                }
                this.outOfTypeSystemElement.attributes.add(new XmlAttribute(attrName, attrValue));
            }
            this.sharedData.addOutOfTypeSystemElement(this.outOfTypeSystemElement);
        }

        private void addOutOfTypeSystemFeature(XmiSerializationSharedData.OotsElementData ootsElem, String featName, List featVals) {
            Iterator iter = featVals.iterator();
            XmlElementName elemName = new XmlElementName(null, featName, featName);
            while (iter.hasNext()) {
                ootsElem.childElements.add(new XmlElementNameAndContents(elemName, (String)iter.next()));
            }
        }
    }
}

